/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.StopwatchProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.StopwatchCustomizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class StopwatchProfilingPointFactory
extends CodeProfilingPointFactory {
    private static final String PP_TYPE = NbBundle.getMessage(StopwatchProfilingPointFactory.class, (String)"StopwatchProfilingPointFactory_PpType");
    private static final String PP_DESCR = NbBundle.getMessage(StopwatchProfilingPointFactory.class, (String)"StopwatchProfilingPointFactory_PpDescr");
    private static final String PP_DEFAULT_NAME = NbBundle.getMessage(StopwatchProfilingPointFactory.class, (String)"StopwatchProfilingPointFactory_PpDefaultName");
    public static final Icon RESET_RESULTS_PP_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/ppoints/ui/resources/stopwatchProfilingPoint.png", (boolean)false);
    public static final String RESET_RESULTS_PP_TYPE = PP_TYPE;
    public static final String RESET_RESULTS_PP_DESCR = PP_DESCR;
    private static final String START_LOCATION_PREFIX = "start_";
    private static final String END_LOCATION_PREFIX = "end_";

    @Override
    public String getDescription() {
        return RESET_RESULTS_PP_DESCR;
    }

    @Override
    public Icon getIcon() {
        return RESET_RESULTS_PP_ICON;
    }

    @Override
    public int getScope() {
        return 1;
    }

    @Override
    public String getType() {
        return RESET_RESULTS_PP_TYPE;
    }

    @Override
    public ProfilingPoint create(Project project) {
        CodeProfilingPoint.Location[] locationArray;
        if (project == null) {
            project = Utils.getCurrentProject();
        }
        if ((locationArray = Utils.getCurrentSelectionLocations()).length != 2) {
            CodeProfilingPoint.Location location = Utils.getCurrentLocation(Integer.MIN_VALUE);
            if (location.equals(CodeProfilingPoint.Location.EMPTY)) {
                String string = "";
                String string2 = Utils.getUniqueName(this.getType(), "", project);
                return new StopwatchProfilingPoint(string2, location, null, project, this);
            }
            File file = FileUtil.normalizeFile((File)new File(location.getFile()));
            String string = FileUtil.toFileObject((File)file).getName();
            String string3 = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", string, location.getLine()), project);
            return new StopwatchProfilingPoint(string3, location, null, project, this);
        }
        CodeProfilingPoint.Location location = locationArray[0];
        CodeProfilingPoint.Location location2 = locationArray[1];
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        String string = FileUtil.toFileObject((File)file).getName();
        String string4 = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", string, location.getLine()), project);
        return new StopwatchProfilingPoint(string4, location, location2, project, this);
    }

    @Override
    public boolean supportsCPU() {
        return true;
    }

    @Override
    public boolean supportsMemory() {
        return true;
    }

    @Override
    public boolean supportsMonitor() {
        return false;
    }

    @Override
    protected Class getProfilingPointsClass() {
        return StopwatchProfilingPoint.class;
    }

    @Override
    protected String getServerHandlerClassName() {
        return "org.netbeans.lib.profiler.global.ProfilingPointServerHandler";
    }

    @Override
    protected StopwatchCustomizer createCustomizer() {
        return new StopwatchCustomizer(this.getType(), this.getIcon());
    }

    @Override
    protected ProfilingPoint loadProfilingPoint(Project project, Properties properties, int n) {
        String string = properties.getProperty(n + "_" + "p_name", null);
        String string2 = properties.getProperty(n + "_" + "p_enabled", null);
        CodeProfilingPoint.Location location = CodeProfilingPoint.Location.load(project, n, START_LOCATION_PREFIX, properties);
        CodeProfilingPoint.Location location2 = CodeProfilingPoint.Location.load(project, n, END_LOCATION_PREFIX, properties);
        if (string == null || string2 == null || location == null) {
            return null;
        }
        StopwatchProfilingPoint stopwatchProfilingPoint = null;
        try {
            stopwatchProfilingPoint = new StopwatchProfilingPoint(string, location, location2, project, this);
            stopwatchProfilingPoint.setEnabled(Boolean.parseBoolean(string2));
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(65536, exception.getMessage());
        }
        return stopwatchProfilingPoint;
    }

    @Override
    protected void storeProfilingPoint(ProfilingPoint profilingPoint, int n, Properties properties) {
        StopwatchProfilingPoint stopwatchProfilingPoint = (StopwatchProfilingPoint)profilingPoint;
        properties.put(n + "_" + "p_name", stopwatchProfilingPoint.getName());
        properties.put(n + "_" + "p_enabled", Boolean.toString(stopwatchProfilingPoint.isEnabled()));
        stopwatchProfilingPoint.getStartLocation().store(stopwatchProfilingPoint.getProject(), n, START_LOCATION_PREFIX, properties);
        if (stopwatchProfilingPoint.usesEndLocation()) {
            stopwatchProfilingPoint.getEndLocation().store(stopwatchProfilingPoint.getProject(), n, END_LOCATION_PREFIX, properties);
        }
    }
}

