/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;
import org.netbeans.modules.vmd.midp.screen.display.ItemDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.openide.util.NbBundle;

public class DateFieldDisplayPresenter
extends ItemDisplayPresenter {
    private JLabel label = new JLabel();

    public DateFieldDisplayPresenter() {
        this.setContentComponent(this.label);
    }

    @Override
    public void reload(ScreenDeviceInfo screenDeviceInfo) {
        super.reload(screenDeviceInfo);
        PropertyValue propertyValue = this.getComponent().readProperty("inputMode");
        PropertyValue propertyValue2 = this.getComponent().readProperty("date");
        String string = NbBundle.getMessage(DateFieldDisplayPresenter.class, (String)"DISP_user_input_mode");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
            int n = MidpTypes.getInteger(propertyValue);
            switch (n) {
                case 1: {
                    string = NbBundle.getMessage(DateFieldDisplayPresenter.class, (String)"DISP_user_date");
                    dateFormat = DateFormat.getDateInstance(2);
                    break;
                }
                case 3: {
                    string = NbBundle.getMessage(DateFieldDisplayPresenter.class, (String)"DISP_user_date_time");
                    break;
                }
                case 2: {
                    string = NbBundle.getMessage(DateFieldDisplayPresenter.class, (String)"DISP_user_time");
                    dateFormat = DateFormat.getTimeInstance(2);
                }
            }
        }
        if (MidpDatabindingSupport.getConnector(this.getComponent(), "date") != null) {
            string = ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/screen/display/Bundle").getString("LBL_Databinding");
        } else if (propertyValue2.getKind() == PropertyValue.Kind.VALUE) {
            string = dateFormat.format(new Date(MidpTypes.getLong(propertyValue2)));
        }
        if (string == null || string.length() == 0) {
            this.label.setText(" ");
        } else {
            this.label.setText(string);
        }
    }

    @Override
    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ResourcePropertyEditor resourcePropertyEditor = new ResourcePropertyEditor("date", this.getComponent());
        ArrayList<ScreenPropertyDescriptor> arrayList = new ArrayList<ScreenPropertyDescriptor>();
        arrayList.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.label, (ScreenPropertyEditor)resourcePropertyEditor));
        arrayList.addAll(super.getPropertyDescriptors());
        return arrayList;
    }
}

