/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.components.commands.ListSelectCommandCD;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class PropertyEditorListSelectCommand
extends PropertyEditorUserCode
implements PropertyEditorElement,
CleanUp {
    private List<String> tags = new ArrayList<String>();
    private Map<String, DesignComponent> values = new TreeMap<String, DesignComponent>();
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private TypeID typeID;
    private String noneItem;
    private String defaultItem;
    private String mnemonic;

    public static PropertyEditorListSelectCommand createInstance() {
        String mnemonic = NbBundle.getMessage(PropertyEditorListSelectCommand.class, (String)"LBL_SEL_COMMAND_STR");
        String noneItem = NbBundle.getMessage(PropertyEditorListSelectCommand.class, (String)"LBL_SELECTCOMMAND_NONE");
        String defaultItem = NbBundle.getMessage(PropertyEditorListSelectCommand.class, (String)"LBL_SELECTCOMMAND_DEFAULT");
        String userCodeLabel = NbBundle.getMessage(PropertyEditorListSelectCommand.class, (String)"LBL_SELECTCOMMAND_UCLABEL");
        return new PropertyEditorListSelectCommand(ListSelectCommandCD.TYPEID, mnemonic, noneItem, defaultItem, userCodeLabel);
    }

    private PropertyEditorListSelectCommand(TypeID typeID, String mnemonic, String noneItem, String defaultItem, String userCodeLabel) {
        super(userCodeLabel);
        this.typeID = typeID;
        this.noneItem = noneItem;
        this.defaultItem = defaultItem;
        this.mnemonic = mnemonic;
    }

    @Override
    public void clean(DesignComponent component) {
        super.cleanUp(component);
        this.tags = null;
        this.values = null;
        if (this.customEditor != null) {
            this.customEditor.clean();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.typeID = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.customEditor = new CustomEditor();
        this.radioButton.addActionListener(this.customEditor);
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return false;
    }

    @Override
    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return this.noneItem;
        }
        PropertyValue value = (PropertyValue)super.getValue();
        return this.getDecodeValue(value);
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    @Override
    public void updateState(PropertyValue value) {
        this.customEditor.updateModel();
        if (this.isCurrentValueANull() || value == null) {
            this.customEditor.setValue(null);
        } else {
            this.customEditor.setValue(value);
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String text) {
        if (text.length() > 0) {
            if (this.noneItem.equals(text)) {
                super.setValue((Object)NULL_VALUE);
            } else {
                super.setValue((Object)PropertyValue.createComponentReference((DesignComponent)this.getCommandEvenSource(text)));
            }
        }
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    @Override
    public Boolean canEditAsText() {
        return null;
    }

    public String[] getTags() {
        this.tags.clear();
        if (this.isCurrentValueAUserCodeType()) {
            this.tags.add(PropertyEditorUserCode.USER_CODE_TEXT);
        } else {
            this.tags.add(this.noneItem);
            this.values.clear();
            this.values.put(this.noneItem, null);
            if (this.component != null && this.component.get() != null) {
                final DesignDocument document = ((DesignComponent)this.component.get()).getDocument();
                document.getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        Collection components = MidpDocumentSupport.getCategoryComponent(document, CommandsCategoryCD.TYPEID).getComponents();
                        ArrayList<DesignComponent> commands = new ArrayList<DesignComponent>(components.size());
                        for (DesignComponent command : components) {
                            PropertyValue ordinaryValue = command.readProperty("ordinary");
                            if (!MidpTypes.getBoolean(ordinaryValue)) continue;
                            commands.add(command);
                        }
                        PropertyEditorListSelectCommand.this.tags.add(PropertyEditorListSelectCommand.this.defaultItem);
                        PropertyEditorListSelectCommand.this.values.put(PropertyEditorListSelectCommand.this.defaultItem, PropertyEditorListSelectCommand.this.getListSelectCommand(document));
                        for (DesignComponent command : commands) {
                            String displayName = PropertyEditorListSelectCommand.this.getComponentDisplayName(command);
                            PropertyEditorListSelectCommand.this.tags.add(displayName);
                            PropertyEditorListSelectCommand.this.values.put(displayName, command);
                        }
                    }
                });
            }
        }
        return this.tags.toArray(new String[this.tags.size()]);
    }

    private DesignComponent getListSelectCommand(DesignDocument document) {
        return MidpDocumentSupport.getSingletonCommand(document, this.typeID);
    }

    private String getComponentDisplayName(DesignComponent component) {
        return MidpValueSupport.getHumanReadableString(component);
    }

    private String getDecodeValue(final PropertyValue value) {
        DesignDocument document;
        final String[] decodeValue = new String[1];
        DesignComponent valueComponent = value.getComponent();
        if (valueComponent != null && (document = valueComponent.getDocument()) != null) {
            document.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    DesignComponent refComponent;
                    PropertyValue pv;
                    DesignComponent valueComponent = value.getComponent();
                    decodeValue[0] = valueComponent != null ? ((pv = valueComponent.readProperty("command")) != null ? ((refComponent = pv.getComponent()) != null && refComponent.equals(PropertyEditorListSelectCommand.this.getListSelectCommand(document)) ? PropertyEditorListSelectCommand.this.defaultItem : PropertyEditorListSelectCommand.this.getComponentDisplayName(valueComponent)) : PropertyEditorListSelectCommand.this.noneItem) : PropertyEditorListSelectCommand.this.noneItem;
                }
            });
        }
        return decodeValue[0];
    }

    private DesignComponent getCommandEvenSource(final String name) {
        final DesignComponent[] itemCommandEvenSource = new DesignComponent[1];
        if (this.component != null && this.component.get() != null) {
            final DesignComponent listComponent = (DesignComponent)this.component.get();
            listComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    DesignComponent command = (DesignComponent)PropertyEditorListSelectCommand.this.values.get(name);
                    List listESValues = listComponent.readProperty("commands").getArray();
                    for (PropertyValue esValue : listESValues) {
                        DesignComponent existingES = esValue.getComponent();
                        if (!existingES.readProperty("command").getComponent().equals(command)) continue;
                        itemCommandEvenSource[0] = existingES;
                        break;
                    }
                    if (itemCommandEvenSource[0] == null) {
                        itemCommandEvenSource[0] = MidpDocumentSupport.attachCommandToDisplayable(listComponent, command);
                    }
                }
            });
        }
        return itemCommandEvenSource[0];
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)this.mnemonic);
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private JComboBox combobox;

        public CustomEditor() {
            this.initComponents();
        }

        void clean() {
            this.combobox.removeActionListener(this);
            this.combobox = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.combobox = new JComboBox();
            this.combobox.setModel(new DefaultComboBoxModel());
            this.combobox.addActionListener(this);
            this.add((Component)this.combobox, "Center");
            this.combobox.getAccessibleContext().setAccessibleName(PropertyEditorListSelectCommand.this.radioButton.getAccessibleContext().getAccessibleName());
            this.combobox.getAccessibleContext().setAccessibleDescription(PropertyEditorListSelectCommand.this.radioButton.getAccessibleContext().getAccessibleDescription());
        }

        public void setValue(final PropertyValue value) {
            if (value == null) {
                this.combobox.setSelectedItem(PropertyEditorListSelectCommand.this.noneItem);
                return;
            }
            final PropertyValue[] cmdValue = new PropertyValue[1];
            if (PropertyEditorListSelectCommand.this.component != null && PropertyEditorListSelectCommand.this.component.get() != null) {
                DesignDocument document = ((DesignComponent)PropertyEditorListSelectCommand.this.component.get()).getDocument();
                document.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        cmdValue[0] = value.getComponent().readProperty("command");
                    }
                });
            }
            if (cmdValue[0] == null) {
                return;
            }
            DesignComponent command = cmdValue[0].getComponent();
            for (String key : PropertyEditorListSelectCommand.this.values.keySet()) {
                DesignComponent tmpCommand = (DesignComponent)PropertyEditorListSelectCommand.this.values.get(key);
                if (tmpCommand == null || !tmpCommand.equals(command)) continue;
                this.combobox.setSelectedItem(key);
                break;
            }
        }

        public String getText() {
            return (String)this.combobox.getSelectedItem();
        }

        public void updateModel() {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.combobox.getModel();
            model.removeAllElements();
            for (String tag : PropertyEditorListSelectCommand.this.tags) {
                model.addElement(tag);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PropertyEditorListSelectCommand.this.radioButton.setSelected(true);
        }
    }
}

