/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.spi.toolchain.CompilerProvider;
import org.netbeans.modules.cnd.toolchain.compilers.Assembler;
import org.netbeans.modules.cnd.toolchain.compilers.CustomTool;
import org.netbeans.modules.cnd.toolchain.compilers.GNUCCCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.GNUCCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.GNUDebuggerTool;
import org.netbeans.modules.cnd.toolchain.compilers.GNUFortranCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.GNUMaketool;
import org.netbeans.modules.cnd.toolchain.compilers.GeneralTool;
import org.netbeans.modules.cnd.toolchain.compilers.MsvcCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.SunCCCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.SunCCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.SunDebuggerTool;
import org.netbeans.modules.cnd.toolchain.compilers.SunFortranCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.SunMaketool;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

public class MakeProjectCompilerProvider
extends CompilerProvider {
    @Override
    public Tool createCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        if (flavor.isSunStudioCompiler()) {
            if (kind == PredefinedToolKind.CCompiler) {
                return SunCCompiler.create(env, flavor, kind, name, displayName, path);
            }
            if (kind == PredefinedToolKind.CCCompiler) {
                return SunCCCompiler.create(env, flavor, kind, name, displayName, path);
            }
            if (kind == PredefinedToolKind.FortranCompiler) {
                return SunFortranCompiler.create(env, flavor, kind, name, displayName, path);
            }
            if (kind == PredefinedToolKind.MakeTool) {
                return SunMaketool.create(env, flavor, name, displayName, path);
            }
            if (kind == PredefinedToolKind.DebuggerTool) {
                return SunDebuggerTool.create(env, flavor, name, displayName, path);
            }
            if (kind == PredefinedToolKind.Assembler) {
                return Assembler.create(env, flavor, kind, name, displayName, path);
            }
        } else {
            if (kind == PredefinedToolKind.CCompiler) {
                if ("MSVC".equals(flavor.toString())) {
                    return MsvcCompiler.create(env, flavor, kind, name, displayName, path);
                }
                return GNUCCompiler.create(env, flavor, kind, name, displayName, path);
            }
            if (kind == PredefinedToolKind.CCCompiler) {
                if ("MSVC".equals(flavor.toString())) {
                    return new MsvcCompiler(env, flavor, kind, name, displayName, path);
                }
                return GNUCCCompiler.create(env, flavor, kind, name, displayName, path);
            }
            if (kind == PredefinedToolKind.FortranCompiler) {
                return GNUFortranCompiler.create(env, flavor, kind, name, displayName, path);
            }
            if (kind == PredefinedToolKind.MakeTool) {
                return GNUMaketool.create(env, flavor, name, displayName, path);
            }
            if (kind == PredefinedToolKind.DebuggerTool) {
                return GNUDebuggerTool.create(env, flavor, name, displayName, path);
            }
            if (kind == PredefinedToolKind.Assembler) {
                return Assembler.create(env, flavor, kind, name, displayName, path);
            }
        }
        if (kind == PredefinedToolKind.CustomTool) {
            return CustomTool.create(env);
        }
        if (kind == PredefinedToolKind.QMakeTool || kind == PredefinedToolKind.CMakeTool) {
            return GeneralTool.create(env, flavor, kind, name, displayName, path);
        }
        return null;
    }
}

