/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.doxygensupport;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.spi.editor.completion.CompletionDocumentation;

public class DoxygenDocumentation {
    private static final Pattern STRIP_STARS = Pattern.compile("^[ \t]*\\*[ \t]?", 8);
    private static final String[] formatItalic = new String[]{"<i>", "</i>"};
    private static final Map<String, CommandDescription> commands = new HashMap<String, CommandDescription>();

    static String doxygen2HTML(String doxygen) {
        doxygen = doxygen.substring(3, doxygen.length() - 2);
        doxygen = STRIP_STARS.matcher(doxygen).replaceAll("");
        doxygen = doxygen.trim();
        StringBuilder output = new StringBuilder();
        LinkedList<String> wordEnd = new LinkedList<String>();
        LinkedList<String> lineEnd = new LinkedList<String>();
        LinkedList<String> parEnd = new LinkedList<String>();
        String[] nextWordFormat = null;
        for (Token t : DoxygenDocumentation.lex(doxygen)) {
            switch (t.id) {
                case WHITESPACE: {
                    output.append(t.image);
                    break;
                }
                case WORD: {
                    if (nextWordFormat != null) {
                        output.append((String)nextWordFormat[0]);
                    }
                    output.append(t.image);
                    for (String s : wordEnd) {
                        output.append(s);
                    }
                    wordEnd.clear();
                    if (nextWordFormat != null) {
                        output.append((String)nextWordFormat[1]);
                    }
                    nextWordFormat = null;
                    break;
                }
                case LINE_END: {
                    for (String s : wordEnd) {
                        output.append(s);
                    }
                    wordEnd.clear();
                    for (String s : lineEnd) {
                        output.append(s);
                    }
                    lineEnd.clear();
                    output.append(t.image);
                    output.append("</p><p>\n");
                    break;
                }
                case PAR_END: {
                    for (String s : wordEnd) {
                        output.append(s);
                    }
                    wordEnd.clear();
                    for (String s : lineEnd) {
                        output.append(s);
                    }
                    for (String s : parEnd) {
                        output.append(s);
                    }
                    lineEnd.clear();
                    parEnd.clear();
                    output.append("</p><p>\n");
                    break;
                }
                case COMMAND: {
                    CommandDescription cd = commands.get(t.image);
                    if (cd == null) {
                        cd = new CommandDescription(EndsOn.PAR, "<strong>" + t.image.substring(1) + ":</strong><br>&nbsp; ", "");
                    }
                    output.append(cd.htmlStart);
                    switch (cd.end) {
                        case WORD: {
                            wordEnd.add(cd.htmlEnd);
                            break;
                        }
                        case LINE: {
                            lineEnd.add(cd.htmlEnd);
                            break;
                        }
                        case PAR: {
                            parEnd.add(cd.htmlEnd);
                        }
                    }
                    if (!t.image.equals("\\param")) break;
                    nextWordFormat = formatItalic;
                }
            }
        }
        return "<html><body><p>" + output.toString() + "</p>";
    }

    public static CompletionDocumentation create(CsmObject csmObject) {
        if (!(csmObject instanceof CsmOffsetable)) {
            return null;
        }
        CsmOffsetable csmOffsetable = (CsmOffsetable)csmObject;
        TokenHierarchy h = TokenHierarchy.create((CharSequence)csmOffsetable.getContainingFile().getText(), (Language)CppTokenId.languageHeader());
        TokenSequence ts = h.tokenSequence(CppTokenId.languageHeader());
        ts.move(csmOffsetable.getStartOffset());
        String docText = null;
        block5: while (ts.movePrevious()) {
            switch ((CppTokenId)ts.token().id()) {
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case WHITESPACE: 
                case NEW_LINE: {
                    continue block5;
                }
                case DOXYGEN_COMMENT: {
                    docText = ((Object)ts.token().text()).toString();
                    break block5;
                }
                case SEMICOLON: 
                case RBRACKET: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
        }
        if (docText == null) {
            return null;
        }
        String htmlDocText = DoxygenDocumentation.doxygen2HTML(docText);
        return new CompletionDocumentationImpl(htmlDocText);
    }

    static Collection<Token> lex(String text) {
        LinkedList<Token> result = new LinkedList<Token>();
        StringBuilder img = new StringBuilder();
        int i = 0;
        boolean wasContent = true;
        boolean verbatimMode = false;
        block5: while (i < text.length()) {
            switch (text.charAt(i)) {
                case '\n': {
                    if (i < text.length() - 1) {
                        if (!verbatimMode) {
                            while (i < text.length() - 1 && (text.charAt(i + 1) == ' ' || text.charAt(i + 1) == '\t')) {
                                ++i;
                            }
                        }
                        if (text.charAt(i + 1) == '@' || text.charAt(i + 1) == '\\' || text.charAt(i + 1) == '\n') {
                            Token last = result.getLast();
                            if (last.id != TokenId.LINE_END && last.id != TokenId.PAR_END) {
                                result.add(new Token(wasContent ? TokenId.LINE_END : TokenId.PAR_END, "\n"));
                                wasContent = false;
                            }
                        } else if (!verbatimMode) {
                            result.add(new Token(TokenId.WHITESPACE, " "));
                            wasContent = false;
                        }
                    }
                    ++i;
                    continue block5;
                }
                case '\t': 
                case ' ': {
                    img.append(text.charAt(i++));
                    while (i < text.length() && (text.charAt(i) == ' ' || text.charAt(i) == '\t')) {
                        img.append(text.charAt(i++));
                    }
                    result.add(new Token(TokenId.WHITESPACE, img.toString()));
                    img = new StringBuilder();
                    continue block5;
                }
                case '@': 
                case '\\': {
                    img.append('\\');
                    ++i;
                    while (i < text.length() && Character.isLetter(text.charAt(i))) {
                        img.append(text.charAt(i++));
                    }
                    result.add(new Token(TokenId.COMMAND, img.toString()));
                    if (img.toString().equals("\\verbatim")) {
                        verbatimMode = true;
                    }
                    if (verbatimMode && img.toString().equals("\\endverbatim")) {
                        verbatimMode = false;
                    }
                    img = new StringBuilder();
                    wasContent = true;
                    continue block5;
                }
            }
            img.append(text.charAt(i++));
            while (i < text.length() && (verbatimMode || text.charAt(i) != ' ' && text.charAt(i) != '\t' && text.charAt(i) != '\n') && text.charAt(i) != '\\' && text.charAt(i) != '@') {
                img.append(text.charAt(i++));
            }
            result.add(new Token(TokenId.WORD, img.toString()));
            img = new StringBuilder();
            wasContent = true;
        }
        return result;
    }

    static {
        commands.put("\\c", new CommandDescription(EndsOn.WORD, "<tt>", "</tt>"));
        commands.put("\\p", new CommandDescription(EndsOn.WORD, "<tt>", "</tt>"));
        commands.put("\\a", new CommandDescription(EndsOn.WORD, "<i>", "</i>"));
        commands.put("\\n", new CommandDescription(EndsOn.NONE, "<br/>", ""));
        commands.put("\\author", new CommandDescription(EndsOn.PAR, "<strong>Author:</strong><br>&nbsp; ", ""));
        commands.put("\\exception", new CommandDescription(EndsOn.PAR, "<strong>Exceptions:</strong><br>&nbsp; ", ""));
        commands.put("\\throw", new CommandDescription(EndsOn.PAR, "<strong>Throws:</strong><br>&nbsp; ", ""));
        commands.put("\\return", new CommandDescription(EndsOn.PAR, "<strong>Returns:</strong><br>&nbsp; ", ""));
        commands.put("\\param", new CommandDescription(EndsOn.PAR, "<strong>Parameter:</strong><br>&nbsp; ", ""));
        commands.put("\\sa", new CommandDescription(EndsOn.PAR, "<strong>See Also:</strong><br>&nbsp; ", ""));
        commands.put("\\verbatim", new CommandDescription(EndsOn.NONE, "<pre>", ""));
        commands.put("\\endverbatim", new CommandDescription(EndsOn.NONE, "</pre>", ""));
        commands.put("\\brief", new CommandDescription(EndsOn.PAR, "", ""));
        commands.put("\\date", new CommandDescription(EndsOn.PAR, "<strong>Date:</strong><br>&nbsp; ", ""));
        commands.put("\\bug", new CommandDescription(EndsOn.PAR, "<strong>Bug:</strong><br>&nbsp; ", ""));
        commands.put("\\warning", new CommandDescription(EndsOn.PAR, "<strong>Warning:</strong><br>&nbsp; ", ""));
        commands.put("\\version", new CommandDescription(EndsOn.PAR, "<strong>Version:</strong><br>&nbsp; ", ""));
    }

    private static final class CompletionDocumentationImpl
    implements CompletionDocumentation {
        private final String text;

        public CompletionDocumentationImpl(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    static enum TokenId {
        COMMAND,
        WHITESPACE,
        PAR_END,
        LINE_END,
        WORD;

    }

    static class Token {
        final TokenId id;
        final String image;

        public Token(TokenId id, String image) {
            this.id = id;
            this.image = image;
        }

        public String toString() {
            return (Object)((Object)this.id) + ":" + this.image;
        }
    }

    static enum EndsOn {
        WORD,
        LINE,
        PAR,
        NONE;

    }

    static final class CommandDescription {
        final EndsOn end;
        final String htmlStart;
        final String htmlEnd;

        public CommandDescription(EndsOn end, String htmlStart, String htmlEnd) {
            this.end = end;
            this.htmlStart = htmlStart;
            this.htmlEnd = htmlEnd;
        }
    }
}

