/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.Transform;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGPath;

public class Path
implements SVGPath {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    static final int INITIAL_COMMAND_CAPACITY = 10;
    static final int INITIAL_DATA_CAPACITY = 40;
    public static final byte MOVE_TO_IMPL = 0;
    public static final byte LINE_TO_IMPL = 1;
    public static final byte QUAD_TO_IMPL = 2;
    public static final byte CURVE_TO_IMPL = 3;
    public static final int CLOSE_IMPL = 4;
    public static final int[] COMMAND_OFFSET = new int[]{2, 2, 4, 6, 0};
    protected byte[] commands;
    protected float[] data;
    protected int nSegments;
    protected int nData;
    protected int lastCmdIndex;
    protected int lastOffset;

    public int getNumberOfSegments() {
        return this.nSegments;
    }

    public Path() {
        this(10, 40);
    }

    public Path(int commandCapacity, int dataCapacity) {
        this.commands = new byte[commandCapacity];
        this.data = new float[dataCapacity];
    }

    public Path(Path model) {
        if (model != null) {
            this.data = new float[model.data.length];
            System.arraycopy(model.data, 0, this.data, 0, model.data.length);
            this.commands = new byte[model.commands.length];
            System.arraycopy(model.commands, 0, this.commands, 0, model.commands.length);
            this.nData = model.nData;
            this.nSegments = model.nSegments;
        }
    }

    public byte[] getCommands() {
        return this.commands;
    }

    public float[] getData() {
        return this.data;
    }

    public void setData(float[] newData) {
        if (this.nData == 0) {
            return;
        }
        this.data = newData;
    }

    static short toSVGPathCommand(int command) {
        switch (command) {
            case 0: {
                return 77;
            }
            case 1: {
                return 76;
            }
            case 2: {
                return 81;
            }
            case 3: {
                return 67;
            }
        }
        return 90;
    }

    public short getSegment(int cmdIndex) throws DOMException {
        if (cmdIndex >= this.nSegments || cmdIndex < 0) {
            throw new DOMException(1, "");
        }
        return Path.toSVGPathCommand(this.commands[cmdIndex]);
    }

    public float getSegmentParam(int cmdIndex, int paramIndex) throws DOMException {
        if (cmdIndex >= this.nSegments || cmdIndex < 0 || paramIndex < 0) {
            throw new DOMException(1, "");
        }
        switch (this.commands[cmdIndex]) {
            case 4: {
                throw new DOMException(1, "");
            }
            case 0: 
            case 1: {
                if (paramIndex <= 1) break;
                throw new DOMException(1, "");
            }
            case 2: {
                if (paramIndex <= 3) break;
                throw new DOMException(1, "");
            }
            case 3: {
                if (paramIndex <= 5) break;
                throw new DOMException(1, "");
            }
            default: {
                throw new DOMException(1, "");
            }
        }
        return this.data[this.checkOffset(cmdIndex) + paramIndex];
    }

    final int checkOffset(int cmdIndex) {
        if (cmdIndex == this.lastCmdIndex) {
            return this.lastOffset;
        }
        if (cmdIndex > this.lastCmdIndex) {
            for (int ci = this.lastCmdIndex; ci < cmdIndex; ++ci) {
                this.lastOffset += COMMAND_OFFSET[this.commands[ci]];
            }
        } else {
            for (int ci = this.lastCmdIndex - 1; ci >= cmdIndex; --ci) {
                this.lastOffset -= COMMAND_OFFSET[this.commands[ci]];
            }
        }
        this.lastCmdIndex = cmdIndex;
        return this.lastOffset;
    }

    void newCommand(int nPoints) {
        if (this.nSegments == this.commands.length) {
            byte[] tmpCommands = new byte[this.commands.length * 2 + 1];
            System.arraycopy(this.commands, 0, tmpCommands, 0, this.commands.length);
            this.commands = tmpCommands;
        }
        if (this.nData + nPoints * 2 > this.data.length) {
            float[] tmpData = new float[(this.nData + nPoints * 2) * 2];
            System.arraycopy(this.data, 0, tmpData, 0, this.data.length);
            this.data = tmpData;
        }
    }

    public void moveTo(float x, float y) {
        this.newCommand(1);
        this.commands[this.nSegments] = 0;
        this.data[this.nData] = x;
        this.data[this.nData + 1] = y;
        ++this.nSegments;
        this.nData += 2;
    }

    public void lineTo(float x, float y) {
        this.newCommand(1);
        this.commands[this.nSegments] = 1;
        this.data[this.nData] = x;
        this.data[this.nData + 1] = y;
        ++this.nSegments;
        this.nData += 2;
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        this.newCommand(2);
        this.commands[this.nSegments] = 2;
        this.data[this.nData] = x1;
        this.data[this.nData + 1] = y1;
        this.data[this.nData + 2] = x2;
        this.data[this.nData + 3] = y2;
        ++this.nSegments;
        this.nData += 4;
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.newCommand(3);
        this.commands[this.nSegments] = 3;
        this.data[this.nData] = x1;
        this.data[this.nData + 1] = y1;
        this.data[this.nData + 2] = x2;
        this.data[this.nData + 3] = y2;
        this.data[this.nData + 4] = x3;
        this.data[this.nData + 5] = y3;
        ++this.nSegments;
        this.nData += 6;
    }

    public void close() {
        this.newCommand(0);
        this.commands[this.nSegments] = 4;
        ++this.nSegments;
    }

    public String toString() {
        return this.toString(this.data);
    }

    public String toString(float[] d) {
        StringBuffer sb = new StringBuffer();
        int offset = 0;
        block7: for (int i = 0; i < this.nSegments; ++i) {
            switch (this.commands[i]) {
                case 0: {
                    sb.append('M');
                    sb.append(d[offset]);
                    sb.append(',');
                    sb.append(d[offset + 1]);
                    offset += 2;
                    continue block7;
                }
                case 1: {
                    sb.append('L');
                    sb.append(d[offset]);
                    sb.append(',');
                    sb.append(d[offset + 1]);
                    offset += 2;
                    continue block7;
                }
                case 2: {
                    sb.append('Q');
                    sb.append(d[offset]);
                    sb.append(',');
                    sb.append(d[offset + 1]);
                    sb.append(',');
                    sb.append(d[offset + 2]);
                    sb.append(',');
                    sb.append(d[offset + 3]);
                    offset += 4;
                    continue block7;
                }
                case 3: {
                    sb.append('C');
                    sb.append(d[offset]);
                    sb.append(',');
                    sb.append(d[offset + 1]);
                    sb.append(',');
                    sb.append(d[offset + 2]);
                    sb.append(',');
                    sb.append(d[offset + 3]);
                    sb.append(',');
                    sb.append(d[offset + 4]);
                    sb.append(',');
                    sb.append(d[offset + 5]);
                    offset += 6;
                    continue block7;
                }
                case 4: {
                    sb.append('Z');
                    continue block7;
                }
                default: {
                    throw new Error();
                }
            }
        }
        return sb.toString();
    }

    public String toPointsString() {
        return this.toPointsString(this.data);
    }

    public String toPointsString(float[] d) {
        StringBuffer sb = new StringBuffer();
        int off = 0;
        boolean cmd = false;
        block5: for (int curSegment = 0; curSegment < this.nSegments; ++curSegment) {
            switch (this.commands[curSegment]) {
                case 0: {
                    if (curSegment > 0) {
                        throw new IllegalArgumentException();
                    }
                    sb.append(d[off]);
                    sb.append(',');
                    sb.append(d[off + 1]);
                    sb.append(' ');
                    off += 2;
                    continue block5;
                }
                case 1: {
                    sb.append(d[off]);
                    sb.append(',');
                    sb.append(d[off + 1]);
                    sb.append(' ');
                    off += 2;
                    continue block5;
                }
                case 4: {
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return sb.toString().trim();
    }

    public Box getBounds() {
        float y1;
        float y2;
        float x1;
        float x2;
        int i = this.nData - 2;
        if (this.nData > 0) {
            x1 = x2 = this.data[i];
            y1 = y2 = this.data[i + 1];
            i -= 2;
            while (i >= 0) {
                float x = this.data[i];
                float y = this.data[i + 1];
                i -= 2;
                if (x < x1) {
                    x1 = x;
                }
                if (y < y1) {
                    y1 = y;
                }
                if (x > x2) {
                    x2 = x;
                }
                if (!(y > y2)) continue;
                y2 = y;
            }
        } else {
            y2 = 0.0f;
            x2 = 0.0f;
            y1 = 0.0f;
            x1 = 0.0f;
        }
        return new Box(x1, y1, x2 - x1, y2 - y1);
    }

    public Box getTransformedBounds(Transform t) {
        float y1;
        float y2;
        float x1;
        float x2;
        int i = this.nData - 2;
        if (this.nData > 0) {
            float x0 = this.data[i];
            float y0 = this.data[i + 1];
            x1 = x2 = x0 * t.m0 + y0 * t.m2 + t.m4;
            y1 = y2 = x0 * t.m1 + y0 * t.m3 + t.m5;
            i -= 2;
            while (i >= 0) {
                x0 = this.data[i];
                y0 = this.data[i + 1];
                i -= 2;
                float x = x0 * t.m0 + y0 * t.m2 + t.m4;
                float y = x0 * t.m1 + y0 * t.m3 + t.m5;
                if (x < x1) {
                    x1 = x;
                }
                if (y < y1) {
                    y1 = y;
                }
                if (x > x2) {
                    x2 = x;
                }
                if (!(y > y2)) continue;
                y2 = y;
            }
        } else {
            y2 = 0.0f;
            x2 = 0.0f;
            y1 = 0.0f;
            x1 = 0.0f;
        }
        return new Box(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Path)) {
            return false;
        }
        Path p = (Path)obj;
        if (this.nSegments != p.nSegments || this.nData != this.nData) {
            return false;
        }
        for (int ci = 0; ci < this.nSegments; ++ci) {
            if (this.commands[ci] == p.commands[ci]) continue;
            return false;
        }
        for (int di = 0; di < this.nData; ++di) {
            if (this.data[di] == p.data[di]) continue;
            return false;
        }
        return true;
    }
}

