/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.highlight.InterrupterImpl;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.cnd.highlight.semantic.options.SemanticHighlightingOptions;
import org.netbeans.modules.cnd.model.tasks.CaretAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class MarkOccurrencesHighlighter
extends HighlighterBase {
    private static AttributeSet defaultColors;
    public static final Color ES_COLOR;
    private boolean valid = true;

    public static OffsetsBag getHighlightsBag(Document doc) {
        if (doc == null) {
            return null;
        }
        OffsetsBag bag = (OffsetsBag)doc.getProperty(MarkOccurrencesHighlighter.class);
        if (bag == null) {
            bag = new OffsetsBag(doc, false);
            doc.putProperty(MarkOccurrencesHighlighter.class, bag);
            final OffsetsBag bagFin = bag;
            DocumentListener l = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    bagFin.removeHighlights(e.getOffset(), e.getOffset(), false);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    bagFin.removeHighlights(e.getOffset(), e.getOffset(), false);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
            doc.addDocumentListener(l);
        }
        return bag;
    }

    private void clean() {
        BaseDocument doc = this.getDocument();
        if (doc != null) {
            MarkOccurrencesHighlighter.getHighlightsBag((Document)doc).clear();
            OccurrencesMarkProvider.get((Document)doc).setOccurrences(Collections.<Mark>emptySet());
        }
    }

    public MarkOccurrencesHighlighter(Document doc) {
        super(doc);
        this.init(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CsmFileTaskFactory.PhaseRunner.Phase phase) {
        InterrupterImpl interrupter = new InterrupterImpl();
        try {
            this.addCancelListener(interrupter);
            this.runImpl(phase, interrupter);
        }
        finally {
            this.removeCancelListener(interrupter);
        }
    }

    public void runImpl(CsmFileTaskFactory.PhaseRunner.Phase phase, CsmReferenceRepository.Interrupter interruptor) {
        if (!SemanticHighlightingOptions.instance().getEnableMarkOccurrences()) {
            this.clean();
            this.valid = false;
            return;
        }
        if (phase == CsmFileTaskFactory.PhaseRunner.Phase.CLEANUP) {
            this.clean();
        } else {
            Collection<CsmReference> out;
            BaseDocument doc = this.getDocument();
            if (doc == null) {
                this.clean();
                return;
            }
            CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
            FileObject fo = CsmUtilities.getFileObject((Document)doc);
            if (file == null || fo == null) {
                this.clean();
                return;
            }
            int lastPosition = CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)fo);
            Document doc2 = (Document)doc.getProperty(Document.class);
            if (doc2 != null) {
                FileObject fo2;
                boolean useOwnCarretPosition = true;
                Object obj = doc.getProperty((Object)"use-own-caret-position");
                if (obj != null) {
                    useOwnCarretPosition = (Boolean)obj;
                }
                if (!useOwnCarretPosition && (fo2 = CsmUtilities.getFileObject((Document)doc2)) != null) {
                    lastPosition = MarkOccurrencesHighlighter.getDocumentOffset((Document)doc, MarkOccurrencesHighlighter.getFileOffset(doc2, CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)fo2)));
                }
            }
            if (doc.getProperty((Object)"macro-expansion-view-document") == null) {
                HighlightsSequence hs = MarkOccurrencesHighlighter.getHighlightsBag((Document)doc).getHighlights(0, doc.getLength() - 1);
                while (hs.moveNext()) {
                    if (lastPosition < hs.getStartOffset() || lastPosition > hs.getEndOffset()) continue;
                    return;
                }
            }
            if ((out = MarkOccurrencesHighlighter.getOccurrences((AbstractDocument)doc, file, lastPosition, interruptor)).isEmpty()) {
                if (!SemanticHighlightingOptions.instance().getKeepMarks()) {
                    this.clean();
                }
            } else {
                OffsetsBag obag = new OffsetsBag((Document)doc);
                obag.clear();
                for (CsmReference csmReference : out) {
                    int[][] usages = CsmMacroExpansion.getUsages((Document)doc, (int)csmReference.getStartOffset());
                    if (usages != null) {
                        for (int i = 0; i < usages.length; ++i) {
                            int startOffset = usages[i][0];
                            int endOffset = usages[i][1];
                            if (startOffset >= doc.getLength() || endOffset <= 0 || startOffset >= endOffset) continue;
                            obag.addHighlight(startOffset > 0 ? startOffset : 0, endOffset < doc.getLength() ? endOffset : doc.getLength(), defaultColors);
                        }
                        continue;
                    }
                    int startOffset = MarkOccurrencesHighlighter.getDocumentOffset((Document)doc, csmReference.getStartOffset());
                    int endOffset = MarkOccurrencesHighlighter.getDocumentOffset((Document)doc, csmReference.getEndOffset());
                    if (startOffset >= doc.getLength() || endOffset <= 0 || startOffset >= endOffset) continue;
                    obag.addHighlight(startOffset > 0 ? startOffset : 0, endOffset < doc.getLength() ? endOffset : doc.getLength(), defaultColors);
                }
                MarkOccurrencesHighlighter.getHighlightsBag((Document)doc).setHighlights(obag);
                OccurrencesMarkProvider.get((Document)doc).setOccurrences(OccurrencesMarkProvider.createMarks((Document)doc, out, ES_COLOR, NbBundle.getMessage(MarkOccurrencesHighlighter.class, (String)"LBL_ES_TOOLTIP")));
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isHighPriority() {
        return true;
    }

    static Collection<CsmReference> getOccurrences(AbstractDocument doc, CsmFile file, int position, CsmReferenceRepository.Interrupter interrupter) {
        CsmReference ref;
        position = MarkOccurrencesHighlighter.getFileOffset(doc, position);
        Collection<Object> out = Collections.emptyList();
        if (MarkOccurrencesHighlighter.isPreprocessorConditionalBlock(doc, position)) {
            return MarkOccurrencesHighlighter.getPreprocReferences(doc, file, position, interrupter);
        }
        if (file != null && file.isParsed() && (ref = CsmReferenceResolver.getDefault().findReference(file, position)) != null && ref.getReferencedObject() != null) {
            out = CsmReferenceRepository.getDefault().getReferences(ref.getReferencedObject(), file, CsmReferenceKind.ALL, interrupter);
        }
        return out;
    }

    private static int getFileOffset(Document doc, int documentOffset) {
        return CsmMacroExpansion.getOffsetInOriginalText((Document)doc, (int)documentOffset);
    }

    private static int getDocumentOffset(Document doc, int fileOffset) {
        return CsmMacroExpansion.getOffsetInExpandedText((Document)doc, (int)fileOffset);
    }

    @Override
    protected void updateFontColors(FontColorProvider provider) {
        defaultColors = provider.getColor(FontColorProvider.Entity.MARK_OCCURENCES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPreprocessorConditionalBlock(AbstractDocument doc, int offset) {
        if (doc == null) {
            return false;
        }
        doc.readLock();
        try {
            int[] span;
            TokenSequence<CppTokenId> ts = MarkOccurrencesHighlighter.cppTokenSequence(doc, offset, false);
            if (ts != null && ts.language() == CppTokenId.languagePreproc() && MarkOccurrencesHighlighter.isIn(span = MarkOccurrencesHighlighter.getPreprocConditionalOffsets(ts), offset)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            doc.readUnlock();
        }
        return false;
    }

    private static int[] getPreprocConditionalOffsets(TokenSequence<CppTokenId> ts) {
        ts.moveStart();
        ts.moveNext();
        int start = ts.offset();
        block4: while (ts.moveNext()) {
            switch ((CppTokenId)ts.token().id()) {
                case PREPROCESSOR_START: 
                case WHITESPACE: 
                case BLOCK_COMMENT: 
                case ESCAPED_LINE: 
                case ESCAPED_WHITESPACE: {
                    continue block4;
                }
                case PREPROCESSOR_IF: 
                case PREPROCESSOR_IFDEF: 
                case PREPROCESSOR_IFNDEF: 
                case PREPROCESSOR_ELIF: 
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ENDIF: {
                    int end = ts.offset() + ts.token().length();
                    return new int[]{start, end};
                }
            }
            return null;
        }
        return null;
    }

    private static TokenSequence<CppTokenId> cppTokenSequence(Document doc, int offset, boolean backwardBias) {
        return CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)true, (boolean)backwardBias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<CsmReference> getPreprocReferences(AbstractDocument doc, CsmFile file, int searchOffset, CsmReferenceRepository.Interrupter interrupter) {
        TokenSequence<CppTokenId> origPreprocTS = MarkOccurrencesHighlighter.cppTokenSequence(doc, searchOffset, false);
        if (origPreprocTS == null || origPreprocTS.language() != CppTokenId.languagePreproc()) {
            return Collections.emptyList();
        }
        doc.readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            List ppSequences = th.tokenSequenceList(origPreprocTS.languagePath(), 0, doc.getLength());
            ConditionalBlock top = new ConditionalBlock(null);
            ConditionalBlock current = new ConditionalBlock(top);
            ConditionalBlock offsetContainer = null;
            for (TokenSequence ts : ppSequences) {
                if (interrupter != null && interrupter.cancelled()) {
                    List<CsmReference> list = Collections.emptyList();
                    return list;
                }
                TokenSequence ppTS = ts;
                int[] span = MarkOccurrencesHighlighter.getPreprocConditionalOffsets((TokenSequence<CppTokenId>)ppTS);
                if (span == null) continue;
                switch ((CppTokenId)ppTS.token().id()) {
                    case PREPROCESSOR_IF: 
                    case PREPROCESSOR_IFDEF: 
                    case PREPROCESSOR_IFNDEF: {
                        current = current.startNestedBlock(span);
                        break;
                    }
                    case PREPROCESSOR_ELIF: 
                    case PREPROCESSOR_ELSE: 
                    case PREPROCESSOR_ENDIF: {
                        current.addDirective(span);
                        break;
                    }
                    default: {
                        assert (false) : "unexpected token " + ts.token();
                        break;
                    }
                }
                if (offsetContainer == null && MarkOccurrencesHighlighter.isIn(span, searchOffset)) {
                    offsetContainer = current;
                }
                if (ppTS.token().id() != CppTokenId.PREPROCESSOR_ENDIF || (current = current.getParent()) != null) continue;
                Collection<CsmReference> collection = MarkOccurrencesHighlighter.toRefs(offsetContainer);
                return collection;
            }
            Collection<CsmReference> collection = MarkOccurrencesHighlighter.toRefs(offsetContainer);
            return collection;
        }
        finally {
            doc.readUnlock();
        }
    }

    private static boolean isIn(int[] span, int offset) {
        return span != null && span[0] <= offset && offset <= span[1];
    }

    private static Collection<CsmReference> toRefs(ConditionalBlock block) {
        if (block == null || block.getDirectives().isEmpty()) {
            return Collections.emptyList();
        }
        List<int[]> directives = block.getDirectives();
        ArrayList<CsmReference> out = new ArrayList<CsmReference>(directives.size());
        for (int[] directive : directives) {
            out.add(new PreprocRef(directive[0], directive[1]));
        }
        return out;
    }

    static {
        ES_COLOR = new Color(175, 172, 102);
    }

    private static final class PreprocRef
    implements CsmReference {
        private final int start;
        private final int end;

        public PreprocRef(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public CsmReferenceKind getKind() {
            throw new UnsupportedOperationException("Must not be called");
        }

        public CsmObject getReferencedObject() {
            throw new UnsupportedOperationException("Must not be called");
        }

        public CsmObject getOwner() {
            throw new UnsupportedOperationException("Must not be called");
        }

        public CsmFile getContainingFile() {
            throw new UnsupportedOperationException("Must not be called");
        }

        public int getStartOffset() {
            return this.start;
        }

        public int getEndOffset() {
            return this.end;
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException("Must not be called");
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException("Must not be called");
        }

        public CharSequence getText() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static final class ConditionalBlock {
        private final List<int[]> directivePositions = new ArrayList<int[]>(4);
        private final List<ConditionalBlock> nested = new ArrayList<ConditionalBlock>(4);
        private final ConditionalBlock parent;

        public ConditionalBlock(ConditionalBlock parent) {
            this.parent = parent;
        }

        public void addDirective(int[] span) {
            this.directivePositions.add(span);
        }

        public ConditionalBlock startNestedBlock(int[] span) {
            ConditionalBlock nestedBlock = new ConditionalBlock(this);
            nestedBlock.addDirective(span);
            this.nested.add(nestedBlock);
            return nestedBlock;
        }

        public ConditionalBlock getParent() {
            return this.parent;
        }

        public List<int[]> getDirectives() {
            return Collections.unmodifiableList(this.directivePositions);
        }
    }
}

