/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.Pair;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class SourceAnalyser {
    private final Index index;
    private final Map<Pair<String, String>, Object[]> references;
    private final Set<Pair<String, String>> toDelete;
    private static final boolean fullIndex = Boolean.getBoolean(SourceAnalyser.class.getName() + ".fullIndex");

    public SourceAnalyser(Index index) {
        assert (index != null);
        this.index = index;
        this.references = new HashMap<Pair<String, String>, Object[]>();
        this.toDelete = new HashSet<Pair<String, String>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException {
        if (this.references.size() > 0 || this.toDelete.size() > 0) {
            try {
                this.index.store(this.references, this.toDelete);
            }
            finally {
                this.references.clear();
                this.toDelete.clear();
            }
        }
    }

    public boolean isValid() throws IOException {
        return this.index.isValid(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyse(Iterable<? extends CompilationUnitTree> data, JavacTaskImpl jt, JavaFileManager manager, JavaCustomIndexer.CompileTuple tuple, Set<? super ElementHandle<TypeElement>> newTypes, boolean[] mainMethod) throws IOException {
        HashMap<Pair<String, String>, Data> usages = new HashMap<Pair<String, String>, Data>();
        for (CompilationUnitTree compilationUnitTree : data) {
            UsagesVisitor uv = new UsagesVisitor(jt, compilationUnitTree, manager, tuple.jfo, newTypes, tuple);
            uv.scan((Tree)compilationUnitTree, (Map<Pair<String, String>, Data>)usages);
            mainMethod[0] = mainMethod[0] | uv.mainMethod;
            if (uv.sourceName == null || uv.rsList == null || uv.rsList.size() <= 0) continue;
            int index = uv.sourceName.lastIndexOf(46);
            String pkg = index == -1 ? "" : uv.sourceName.substring(0, index);
            String simpleName = index == -1 ? uv.sourceName : uv.sourceName.substring(index + 1);
            String ext = tuple.virtual ? FileObjects.getExtension(tuple.indexable.getURL().getPath()) + '.' + "rx" : "rs";
            String rsName = simpleName + '.' + ext;
            FileObject fo = manager.getFileForOutput(StandardLocation.CLASS_OUTPUT, pkg, rsName, tuple.jfo);
            assert (fo != null);
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(fo.openInputStream(), "UTF-8"));
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        uv.rsList.add(line);
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            PrintWriter rsOut = new PrintWriter(new OutputStreamWriter(fo.openOutputStream(), "UTF-8"));
            try {
                for (String sig : uv.rsList) {
                    rsOut.println(sig);
                }
            }
            finally {
                rsOut.close();
            }
        }
        if (tuple.index) {
            for (Map.Entry entry : usages.entrySet()) {
                Pair key = (Pair)entry.getKey();
                Data value = (Data)entry.getValue();
                this.addClassReferences(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyseUnitAndStore(CompilationUnitTree cu, JavacTaskImpl jt, JavaFileManager manager) throws IOException {
        try {
            HashMap<Pair<String, String>, Data> usages = new HashMap<Pair<String, String>, Data>();
            ArrayList<Pair<String, String>> topLevels = new ArrayList<Pair<String, String>>();
            UsagesVisitor uv = new UsagesVisitor(jt, cu, manager, cu.getSourceFile(), topLevels);
            uv.scan((Tree)cu, (Map<Pair<String, String>, Data>)usages);
            for (Map.Entry oe : usages.entrySet()) {
                Pair key = (Pair)oe.getKey();
                Data data = (Data)oe.getValue();
                this.addClassReferences(key, data);
            }
            this.index.store(this.references, topLevels);
        }
        catch (OutputFileManager.InvalidSourcePath e) {
        }
        finally {
            this.references.clear();
        }
    }

    public void delete(Pair<String, String> name) throws IOException {
        this.toDelete.add(name);
    }

    private void addClassReferences(Pair<String, String> name, Data data) {
        assert (name != null);
        assert (data != null);
        Object[] result = new Object[3];
        Map<String, Set<ClassIndexImpl.UsageType>> usages = data.usages;
        Set<CharSequence> fids = data.featuresIdents;
        Set<CharSequence> ids = data.idents;
        LinkedList<String> ru = new LinkedList<String>();
        for (Map.Entry<String, Set<ClassIndexImpl.UsageType>> ue : usages.entrySet()) {
            ru.add(DocumentUtil.encodeUsage(ue.getKey(), ue.getValue()));
        }
        StringBuilder fidents = new StringBuilder();
        for (CharSequence id : fids) {
            fidents.append(id);
            fidents.append(' ');
        }
        StringBuilder idents = new StringBuilder();
        for (CharSequence id : ids) {
            idents.append(id);
            idents.append(' ');
        }
        result[0] = ru;
        result[1] = fidents.toString();
        result[2] = idents.toString();
        this.references.put(name, result);
    }

    private static void dumpUsages(Map<Pair<String, String>, Data> usages) throws IOException {
        assert (usages != null);
        for (Map.Entry<Pair<String, String>, Data> oe : usages.entrySet()) {
            System.out.println("Usages in class: " + oe.getKey());
            for (Map.Entry<String, Set<ClassIndexImpl.UsageType>> ue : oe.getValue().usages.entrySet()) {
                System.out.println("\t" + ue.getKey() + "\t: " + ue.getValue().toString());
            }
            System.out.println("Feature idents in class: " + oe.getKey());
            for (CharSequence s : oe.getValue().featuresIdents) {
                System.out.println("\t" + s);
            }
            System.out.println("All idents in class: " + oe.getKey());
            for (CharSequence s : oe.getValue().idents) {
                System.out.println("\t" + s);
            }
        }
    }

    static class UsagesVisitor
    extends TreeScanner<Void, Map<Pair<String, String>, Data>> {
        private final Stack<Pair<String, String>> activeClass;
        private JavaFileManager manager;
        private final JavacTaskImpl jt;
        private final Name errorName;
        private final CompilationUnitTree cu;
        private final Types types;
        private final TransTypes trans;
        private final URL siblingUrl;
        private final String sourceName;
        private final boolean signatureFiles;
        private final List<? super Pair<String, String>> topLevels;
        private final Set<? super ElementHandle<TypeElement>> newTypes;
        private final Set<String> imports;
        private final Set<String> staticImports;
        private final Set<Pair<String, ClassIndexImpl.UsageType>> packageAnnotations;
        private final Set<CharSequence> importIdents;
        private final Set<CharSequence> packageAnnotationIdents;
        private final boolean virtual;
        private final boolean storeIndex;
        private boolean isStaticImport;
        private State state;
        private Element enclosingElement = null;
        private Set<String> rsList;
        private boolean crossedTopLevel;
        private boolean mainMethod;

        public UsagesVisitor(JavacTaskImpl jt, CompilationUnitTree cu, JavaFileManager manager, JavaFileObject sibling, Set<? super ElementHandle<TypeElement>> newTypes, JavaCustomIndexer.CompileTuple tuple) throws MalformedURLException {
            assert (jt != null);
            assert (cu != null);
            assert (manager != null);
            assert (sibling != null);
            this.activeClass = new Stack();
            this.imports = new HashSet<String>();
            this.staticImports = new HashSet<String>();
            this.importIdents = new HashSet<CharSequence>();
            this.packageAnnotationIdents = new HashSet<CharSequence>();
            this.packageAnnotations = new HashSet<Pair<String, ClassIndexImpl.UsageType>>();
            this.jt = jt;
            this.errorName = Names.instance((Context)jt.getContext()).error;
            this.state = State.OTHER;
            this.types = Types.instance(jt.getContext());
            this.trans = TransTypes.instance(jt.getContext());
            this.cu = cu;
            this.signatureFiles = true;
            this.manager = manager;
            this.virtual = tuple.virtual;
            this.storeIndex = tuple.index;
            this.siblingUrl = this.virtual ? tuple.indexable.getURL() : sibling.toUri().toURL();
            this.sourceName = this.inferBinaryName(manager, sibling);
            this.topLevels = null;
            this.newTypes = newTypes;
        }

        protected UsagesVisitor(JavacTaskImpl jt, CompilationUnitTree cu, JavaFileManager manager, JavaFileObject sibling, List<? super Pair<String, String>> topLevels) throws MalformedURLException {
            assert (jt != null);
            assert (cu != null);
            assert (manager != null);
            assert (sibling != null);
            this.activeClass = new Stack();
            this.imports = new HashSet<String>();
            this.staticImports = new HashSet<String>();
            this.importIdents = new HashSet<CharSequence>();
            this.packageAnnotationIdents = new HashSet<CharSequence>();
            this.packageAnnotations = new HashSet<Pair<String, ClassIndexImpl.UsageType>>();
            this.jt = jt;
            this.errorName = Names.instance((Context)jt.getContext()).error;
            this.state = State.OTHER;
            this.types = Types.instance(jt.getContext());
            this.trans = TransTypes.instance(jt.getContext());
            this.cu = cu;
            this.signatureFiles = false;
            this.manager = manager;
            this.siblingUrl = sibling.toUri().toURL();
            this.sourceName = this.inferBinaryName(manager, sibling);
            this.topLevels = topLevels;
            this.newTypes = null;
            this.virtual = false;
            this.storeIndex = true;
        }

        final Types getTypes() {
            return this.types;
        }

        final TransTypes getTransTypes() {
            return this.trans;
        }

        @Override
        public Void scan(Tree node, Map<Pair<String, String>, Data> p) {
            if (node == null) {
                return null;
            }
            super.scan(node, p);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitCompilationUnit(CompilationUnitTree node, Map<Pair<String, String>, Data> p) {
            Pair<String, Object> name;
            String classNameType;
            State oldState = this.state;
            try {
                this.state = State.PACKAGE_ANN;
                this.scan(node.getPackageAnnotations(), p);
                this.scan((Tree)node.getPackageName(), p);
                this.state = State.IMPORT;
                this.scan(node.getImports(), p);
            }
            finally {
                this.state = oldState;
            }
            this.scan(node.getTypeDecls(), p);
            String className = null;
            if (!this.imports.isEmpty() || !this.staticImports.isEmpty()) {
                className = UsagesVisitor.getResourceName(node);
                if (className != null) {
                    classNameType = className + DocumentUtil.encodeKind(ElementKind.CLASS);
                    name = Pair.of(classNameType, null);
                    for (String string : this.imports) {
                        this.addUsage(name, string, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                    for (String string : this.staticImports) {
                        this.addUsage(name, string, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        this.addUsage(name, string, p, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                        this.addUsage(name, string, p, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                    }
                    for (CharSequence charSequence : this.importIdents) {
                        this.addIdent(name, charSequence, p, false);
                    }
                }
                this.imports.clear();
                this.staticImports.clear();
                this.importIdents.clear();
            }
            if (!this.packageAnnotations.isEmpty()) {
                if (className == null) {
                    className = UsagesVisitor.getResourceName(node);
                }
                if (className != null) {
                    classNameType = className + DocumentUtil.encodeKind(ElementKind.CLASS);
                    name = Pair.of(classNameType, null);
                    for (Pair pair : this.packageAnnotations) {
                        this.addUsage(name, (String)pair.first, p, (ClassIndexImpl.UsageType)((Object)pair.second));
                    }
                    for (CharSequence charSequence : this.packageAnnotationIdents) {
                        this.addIdent(name, charSequence, p, false);
                    }
                }
                this.packageAnnotations.clear();
                this.packageAnnotationIdents.clear();
            }
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, Map<Pair<String, String>, Data> p) {
            this.handleVisitIdentSelect(((JCTree.JCFieldAccess)node).sym, node.getIdentifier(), p);
            State oldState = this.state;
            this.state = this.state == State.IMPORT || this.state == State.PACKAGE_ANN ? this.state : State.OTHER;
            Void ret = (Void)super.visitMemberSelect(node, p);
            this.state = oldState;
            return ret;
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Map<Pair<String, String>, Data> p) {
            this.handleVisitIdentSelect(((JCTree.JCIdent)node).sym, node.getName(), p);
            return (Void)super.visitIdentifier(node, p);
        }

        @Override
        public Void visitImport(ImportTree node, Map<Pair<String, String>, Data> p) {
            this.isStaticImport = node.isStatic();
            Void ret = (Void)super.visitImport(node, p);
            this.isStaticImport = false;
            return ret;
        }

        private void handleVisitIdentSelect(Symbol sym, CharSequence name, Map<Pair<String, String>, Data> p) {
            if (!this.activeClass.empty()) {
                this.addIdent(this.activeClass.peek(), name, p, false);
                if (sym != null) {
                    String className;
                    Symbol owner;
                    if (sym.kind == 31 && ((owner = sym.getEnclosingElement()).getKind().isClass() || owner.getKind().isInterface()) && (className = UsagesVisitor.encodeClassName(owner)) != null) {
                        this.addUsage(this.activeClass.peek(), className, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    }
                    if (sym.getKind().isClass() || sym.getKind().isInterface()) {
                        String className2 = UsagesVisitor.encodeClassName(sym);
                        if (className2 != null) {
                            switch (this.state) {
                                case EXTENDS: {
                                    this.addUsage(this.activeClass.peek(), className2, p, ClassIndexImpl.UsageType.SUPER_CLASS);
                                    break;
                                }
                                case IMPLEMENTS: {
                                    this.addUsage(this.activeClass.peek(), className2, p, ClassIndexImpl.UsageType.SUPER_INTERFACE);
                                    break;
                                }
                                case OTHER: 
                                case GT: {
                                    this.addUsage(this.activeClass.peek(), className2, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                                }
                            }
                        }
                    } else if (sym.getKind().isField()) {
                        owner = sym.getEnclosingElement();
                        if ((owner.getKind().isClass() || owner.getKind().isInterface()) && (className = UsagesVisitor.encodeClassName(owner)) != null) {
                            this.addUsage(this.activeClass.peek(), className, p, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                        }
                    } else if ((sym.getKind() == ElementKind.CONSTRUCTOR || sym.getKind() == ElementKind.METHOD) && ((owner = sym.getEnclosingElement()).getKind().isClass() || owner.getKind().isInterface()) && (className = UsagesVisitor.encodeClassName(owner)) != null) {
                        this.addUsage(this.activeClass.peek(), className, p, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                    }
                }
            } else if (this.state == State.IMPORT) {
                String className;
                this.importIdents.add(name);
                if (sym != null && (sym.getKind().isClass() || sym.getKind().isInterface()) && (className = UsagesVisitor.encodeClassName(sym)) != null) {
                    if (this.isStaticImport) {
                        this.staticImports.add(className);
                    } else {
                        this.imports.add(className);
                    }
                }
            } else if (this.state == State.PACKAGE_ANN) {
                this.packageAnnotationIdents.add(name);
                if (sym != null) {
                    String className;
                    Symbol owner;
                    if (sym.kind == 31 && ((owner = sym.getEnclosingElement()).getKind().isClass() || owner.getKind().isInterface()) && (className = UsagesVisitor.encodeClassName(owner)) != null) {
                        this.packageAnnotations.add(Pair.of(className, ClassIndexImpl.UsageType.TYPE_REFERENCE));
                    }
                    if (sym.getKind().isClass() || sym.getKind().isInterface()) {
                        String className3 = UsagesVisitor.encodeClassName(sym);
                        if (className3 != null) {
                            this.packageAnnotations.add(Pair.of(className3, ClassIndexImpl.UsageType.TYPE_REFERENCE));
                        }
                    } else if (sym.getKind().isField()) {
                        owner = sym.getEnclosingElement();
                        if ((owner.getKind().isClass() || owner.getKind().isInterface()) && (className = UsagesVisitor.encodeClassName(owner)) != null) {
                            this.packageAnnotations.add(Pair.of(className, ClassIndexImpl.UsageType.FIELD_REFERENCE));
                        }
                    } else if ((sym.getKind() == ElementKind.CONSTRUCTOR || sym.getKind() == ElementKind.METHOD) && ((owner = sym.getEnclosingElement()).getKind().isClass() || owner.getKind().isInterface()) && (className = UsagesVisitor.encodeClassName(owner)) != null) {
                        this.packageAnnotations.add(Pair.of(className, ClassIndexImpl.UsageType.METHOD_REFERENCE));
                    }
                }
            }
        }

        @Override
        public Void visitParameterizedType(ParameterizedTypeTree node, Map<Pair<String, String>, Data> p) {
            this.scan(node.getType(), p);
            State currState = this.state;
            this.state = State.GT;
            this.scan(node.getTypeArguments(), p);
            this.state = currState;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public Void visitClass(ClassTree node, Map<Pair<String, String>, Data> p) {
            Symbol.ClassSymbol sym = ((JCTree.JCClassDecl)node).sym;
            boolean errorInDecl = false;
            boolean errorIgnorSubtree = true;
            String className = null;
            if (sym != null) {
                errorInDecl = this.hasErrorName(sym);
                if (errorInDecl) {
                    if (this.activeClass.size() > 0) {
                        this.activeClass.push((Pair<String, String>)this.activeClass.get(0));
                        errorIgnorSubtree = false;
                    } else {
                        className = UsagesVisitor.getResourceName(this.cu);
                        if (className != null) {
                            String classNameType = className + DocumentUtil.encodeKind(ElementKind.CLASS);
                            Pair<String, Object> name = Pair.of(classNameType, null);
                            if (this.activeClass.isEmpty()) {
                                if (this.topLevels != null) {
                                    this.topLevels.add(Pair.of(className, null));
                                }
                                for (String string : this.imports) {
                                    this.addUsage(name, string, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                                }
                                this.imports.clear();
                                for (String string : this.staticImports) {
                                    this.addUsage(name, string, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                                    this.addUsage(name, string, p, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                                    this.addUsage(name, string, p, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                                }
                                this.staticImports.clear();
                                for (CharSequence charSequence : this.importIdents) {
                                    this.addIdent(name, charSequence, p, false);
                                }
                                this.importIdents.clear();
                            }
                            this.activeClass.push(name);
                            errorIgnorSubtree = false;
                            this.addUsage(name, className, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                            this.addIdent(name, className, p, true);
                            if (this.newTypes != null) {
                                this.newTypes.add(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, className));
                            }
                        } else {
                            Logger.getLogger(SourceAnalyser.class.getName()).warning(String.format("Cannot resolve %s, ignoring whole subtree.\n", sym.toString()));
                        }
                    }
                } else {
                    void var10_20;
                    StringBuilder classNameBuilder = new StringBuilder();
                    ClassFileUtil.encodeClassName(sym, classNameBuilder, '.');
                    className = classNameBuilder.toString();
                    ElementKind kind = sym.getKind();
                    classNameBuilder.append(DocumentUtil.encodeKind(kind));
                    String classNameType = classNameBuilder.toString();
                    Object var10_17 = null;
                    if (this.activeClass.isEmpty()) {
                        if (this.virtual || !className.equals(this.sourceName)) {
                            if (this.signatureFiles && this.rsList == null) {
                                this.rsList = new HashSet<String>();
                                if (this.crossedTopLevel) {
                                    this.rsList.add(this.sourceName);
                                }
                            }
                            StringBuilder rnBuilder = new StringBuilder(FileObjects.convertPackage2Folder(this.sourceName));
                            rnBuilder.append('.');
                            rnBuilder.append(FileObjects.getExtension(this.siblingUrl.getPath()));
                            String string = rnBuilder.toString();
                        } else {
                            this.crossedTopLevel = true;
                        }
                    } else {
                        String string = (String)this.activeClass.peek().second;
                    }
                    Pair<String, void> name = Pair.of(classNameType, var10_20);
                    if (this.activeClass.isEmpty()) {
                        if (this.topLevels != null) {
                            this.topLevels.add(Pair.of(className, var10_20));
                        }
                        for (String string : this.imports) {
                            this.addUsage(name, string, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                        }
                        this.imports.clear();
                        for (String string : this.staticImports) {
                            this.addUsage(name, string, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                            this.addUsage(name, string, p, ClassIndexImpl.UsageType.METHOD_REFERENCE);
                            this.addUsage(name, string, p, ClassIndexImpl.UsageType.FIELD_REFERENCE);
                        }
                        this.staticImports.clear();
                        for (CharSequence charSequence : this.importIdents) {
                            this.addIdent(name, charSequence, p, false);
                        }
                        this.importIdents.clear();
                    }
                    this.activeClass.push(name);
                    errorIgnorSubtree = false;
                    this.addUsage(name, className, p, ClassIndexImpl.UsageType.TYPE_REFERENCE);
                    this.addIdent(name, node.getSimpleName(), p, true);
                    if (this.newTypes != null) {
                        this.newTypes.add(ElementHandleAccessor.INSTANCE.create(kind, className));
                    }
                }
            }
            if (!errorIgnorSubtree) {
                Element old = this.enclosingElement;
                try {
                    this.enclosingElement = sym;
                    this.scan((Tree)node.getModifiers(), p);
                    this.scan(node.getTypeParameters(), p);
                    this.state = errorInDecl ? State.OTHER : State.EXTENDS;
                    this.scan(node.getExtendsClause(), p);
                    this.state = errorInDecl ? State.OTHER : State.IMPLEMENTS;
                    this.scan(node.getImplementsClause(), p);
                    this.state = State.OTHER;
                    this.scan(node.getMembers(), p);
                    this.activeClass.pop();
                }
                finally {
                    this.enclosingElement = old;
                }
            }
            if (!errorInDecl && this.rsList != null) {
                this.rsList.add(className);
            }
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree node, Map<Pair<String, String>, Data> p) {
            String className;
            Symbol owner;
            Symbol sym = ((JCTree.JCNewClass)node).constructor;
            if (sym != null && (owner = sym.getEnclosingElement()) != null && owner.getKind().isClass() && (className = UsagesVisitor.encodeClassName(owner)) != null) {
                this.addUsage(this.activeClass.peek(), className, p, ClassIndexImpl.UsageType.METHOD_REFERENCE);
            }
            return (Void)super.visitNewClass(node, p);
        }

        @Override
        public Void visitErroneous(ErroneousTree tree, Map<Pair<String, String>, Data> p) {
            List<? extends Tree> trees = tree.getErrorTrees();
            for (Tree tree2 : trees) {
                this.scan(tree2, p);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitMethod(MethodTree node, Map<Pair<String, String>, Data> p) {
            Element old = this.enclosingElement;
            try {
                this.enclosingElement = ((JCTree.JCMethodDecl)node).sym;
                if (this.enclosingElement != null && this.enclosingElement.getKind() == ElementKind.METHOD) {
                    this.mainMethod |= SourceUtils.isMainMethod((ExecutableElement)this.enclosingElement);
                }
                this.addIdent(this.activeClass.peek(), node.getName(), p, true);
                Void void_ = (Void)super.visitMethod(node, p);
                return void_;
            }
            finally {
                this.enclosingElement = old;
            }
        }

        @Override
        public Void visitVariable(VariableTree node, Map<Pair<String, String>, Data> p) {
            Symbol.VarSymbol s = ((JCTree.JCVariableDecl)node).sym;
            if (s != null && s.owner != null && (s.owner.getKind().isClass() || s.owner.getKind().isInterface())) {
                this.addIdent(this.activeClass.peek(), node.getName(), p, true);
            }
            return (Void)super.visitVariable(node, p);
        }

        private String inferBinaryName(JavaFileManager jfm, JavaFileObject jfo) {
            String result = jfm.inferBinaryName(StandardLocation.SOURCE_PATH, jfo);
            if (result == null) {
                try {
                    org.openide.filesystems.FileObject owner;
                    ClassPath scp;
                    org.openide.filesystems.FileObject fo = URLMapper.findFileObject((URL)jfo.toUri().toURL());
                    if (fo != null && (scp = ClassPath.getClassPath((org.openide.filesystems.FileObject)fo, (String)"classpath/source")) != null && (owner = scp.findOwnerRoot(fo)) != null) {
                        result = scp.getResourceName(fo, '.', false);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }

        private void addUsage(Pair<String, String> owner, String className, Map<Pair<String, String>, Data> map, ClassIndexImpl.UsageType type) {
            assert (className != null);
            assert (map != null);
            assert (type != null);
            Data data = this.getData(owner, map);
            Set<ClassIndexImpl.UsageType> usageType = data.usages.get(className);
            if (usageType == null) {
                usageType = EnumSet.noneOf(ClassIndexImpl.UsageType.class);
                data.usages.put(className, usageType);
            }
            usageType.add(type);
        }

        private void addIdent(Pair<String, String> owner, CharSequence ident, Map<Pair<String, String>, Data> map, boolean feature) {
            assert (owner != null);
            assert (ident != null);
            assert (map != null);
            if (feature || fullIndex) {
                Data data = this.getData(owner, map);
                if (fullIndex) {
                    data.idents.add(ident);
                }
                if (feature) {
                    data.featuresIdents.add(ident);
                }
            }
        }

        private Data getData(Pair<String, String> owner, Map<Pair<String, String>, Data> map) {
            Data data = map.get(owner);
            if (data == null) {
                data = new Data();
                map.put(owner, data);
            }
            return data;
        }

        private boolean hasErrorName(Symbol cs) {
            while (cs != null) {
                if (cs.name == this.errorName) {
                    return true;
                }
                cs = cs.getEnclosingElement();
            }
            return false;
        }

        private static String encodeClassName(Symbol sym) {
            assert (sym instanceof Symbol.ClassSymbol);
            TypeElement toEncode = null;
            TypeMirror type = ((Symbol.ClassSymbol)sym).asType();
            if (sym.getEnclosingElement().getKind() == ElementKind.TYPE_PARAMETER) {
                TypeMirror ctype;
                if (type.getKind() == TypeKind.ARRAY && (ctype = ((ArrayType)type).getComponentType()).getKind() == TypeKind.DECLARED) {
                    toEncode = (TypeElement)((DeclaredType)ctype).asElement();
                }
            } else {
                toEncode = (TypeElement)((Object)sym);
            }
            return toEncode == null ? null : ClassFileUtil.encodeClassName(toEncode);
        }

        private static String getResourceName(CompilationUnitTree cu) {
            URI uri;
            JavaFileObject jfo;
            if (cu instanceof JCTree.JCCompilationUnit && (jfo = ((JCTree.JCCompilationUnit)cu).sourcefile) != null && (uri = jfo.toUri()) != null && uri.isAbsolute()) {
                try {
                    ClassPath cp;
                    org.openide.filesystems.FileObject fo = URLMapper.findFileObject((URL)uri.toURL());
                    if (fo != null && (cp = ClassPath.getClassPath((org.openide.filesystems.FileObject)fo, (String)"classpath/source")) != null) {
                        return cp.getResourceName(fo, '.', false);
                    }
                }
                catch (MalformedURLException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            return null;
        }

        static enum State {
            EXTENDS,
            IMPLEMENTS,
            GT,
            OTHER,
            IMPORT,
            PACKAGE_ANN;

        }
    }

    static class Data {
        final Map<String, Set<ClassIndexImpl.UsageType>> usages = new HashMap<String, Set<ClassIndexImpl.UsageType>>();
        final Set<CharSequence> featuresIdents = new HashSet<CharSequence>();
        final Set<CharSequence> idents = new HashSet<CharSequence>();

        Data() {
        }
    }
}

