/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.nb.javascript.FunctionNode;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsParser;
import org.netbeans.modules.javascript.editing.ParseTreeWalker;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.parsing.api.Snapshot;

public class JsParseResult
extends ParserResult {
    private final JsParser parser;
    private final Node rootNode;
    private String source;
    private List<Error> errors = new ArrayList<Error>();
    private OffsetRange sanitizedRange = OffsetRange.NONE;
    private String sanitizedContents;
    private JsParser.Sanitize sanitized;
    private JsAnalyzer.AnalysisResult analysisResult;
    private boolean commentsAdded;
    private IncrementalParse incrementalParse;
    private VariableVisitor variableVisitor;

    protected void invalidate() {
    }

    public JsParseResult(JsParser jsParser, Snapshot snapshot, Node node) {
        super(snapshot);
        this.parser = jsParser;
        this.rootNode = node;
    }

    public List<? extends Error> getDiagnostics() {
        return this.errors;
    }

    public void setErrors(List<? extends Error> list) {
        this.errors = new ArrayList<Error>(list);
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public OffsetRange getSanitizedRange() {
        return this.sanitizedRange;
    }

    public String getSanitizedContents() {
        return this.sanitizedContents;
    }

    void setSanitized(JsParser.Sanitize sanitize, OffsetRange offsetRange, String string) {
        this.sanitized = sanitize;
        this.sanitizedRange = offsetRange;
        this.sanitizedContents = string;
    }

    public JsParser.Sanitize getSanitized() {
        return this.sanitized;
    }

    public void setStructure(@NonNull JsAnalyzer.AnalysisResult analysisResult) {
        this.analysisResult = analysisResult;
    }

    @NonNull
    public JsAnalyzer.AnalysisResult getStructure() {
        if (this.analysisResult == null) {
            this.analysisResult = JsAnalyzer.analyze(this);
        }
        return this.analysisResult;
    }

    public boolean isCommentsAdded() {
        return this.commentsAdded;
    }

    public void setCommentsAdded(boolean bl) {
        this.commentsAdded = bl;
    }

    public VariableVisitor getVariableVisitor() {
        if (this.variableVisitor == null) {
            if (this.incrementalParse != null && this.incrementalParse.previousResult.variableVisitor != null) {
                this.variableVisitor = this.incrementalParse.previousResult.variableVisitor;
                this.variableVisitor.incrementalEdits(this.incrementalParse);
            } else {
                Node node = this.getRootNode();
                assert (node != null) : "Attempted to get variable visitor for broken source";
                this.variableVisitor = new VariableVisitor();
                new ParseTreeWalker(this.variableVisitor).walk(node);
            }
        }
        return this.variableVisitor;
    }

    public String toString() {
        return "JsParseResult(file=" + this.getSnapshot().getSource().getFileObject() + ",rootnode=" + this.rootNode + ")";
    }

    public void setIncrementalParse(IncrementalParse incrementalParse) {
        this.incrementalParse = incrementalParse;
    }

    public IncrementalParse getIncrementalParse() {
        return this.incrementalParse;
    }

    public static class IncrementalParse {
        public FunctionNode oldFunction;
        public FunctionNode newFunction;
        public int incrementalOffset;
        public int incrementalOffsetLimit;
        public int incrementalOffsetDelta;
        public JsParseResult previousResult;

        public IncrementalParse(FunctionNode functionNode, FunctionNode functionNode2, int n, int n2, int n3, JsParseResult jsParseResult) {
            this.oldFunction = functionNode;
            this.newFunction = functionNode2;
            this.incrementalOffset = n;
            this.incrementalOffsetLimit = n2;
            this.incrementalOffsetDelta = n3;
            this.previousResult = jsParseResult;
        }
    }
}

