/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.api.tool.ToolsConfiguration;
import org.netbeans.modules.dlight.api.tool.impl.DLightConfigurationManagerAccessor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class DLightConfigurationManager {
    private static DLightConfigurationManager instance;
    private String selectedConfigurationName = null;

    private DLightConfigurationManager() {
    }

    private final FileObject getToolsFSRoot() {
        FileObject fsRoot = FileUtil.getConfigRoot();
        return fsRoot.getFileObject(this.getToolsFSRootPath());
    }

    private final String getToolsFSRootPath() {
        return "DLight/Configurations";
    }

    void selectConfiguration(String configurationName) {
        this.selectedConfigurationName = configurationName;
    }

    boolean canDelete(String configurationName) {
        DLightConfiguration configuration = this.getConfigurationByName(configurationName);
        return configuration != null && !configuration.isSystem();
    }

    boolean removeConfiguration(String configurationName) {
        FileObject configurationsFolder = this.getToolsFSRoot();
        if (configurationsFolder == null) {
            System.err.println("Configurations folder is NULL which should not be");
            return false;
        }
        FileObject[] configurations = configurationsFolder.getChildren();
        if (configurations == null || configurations.length == 0) {
            return false;
        }
        Object toDelete = null;
        for (FileObject configuration : configurations) {
            if (!configuration.getName().equals(configurationName)) continue;
            try {
                configuration.delete();
            }
            catch (IOException ex) {
                return false;
            }
        }
        return true;
    }

    private String commaSeparatedList(List<String> list) {
        StringBuffer res = new StringBuffer();
        for (String s : list) {
            if (res.length() > 0) {
                res.append(",");
            }
            res.append(s);
        }
        return res.toString();
    }

    DLightConfiguration registerConfigurationAsACopy(DLightConfiguration configuration, String configurationName, String displayedName, String category, List<String> platforms, String collector, List<String> indicators) {
        FileObject configurationsFolder = this.getToolsFSRoot();
        try {
            FileObject configurationFolder = configurationsFolder.createFolder(configurationName);
            configurationFolder.setAttribute("displayedName", (Object)displayedName);
            configurationFolder.setAttribute("category", (Object)category);
            configurationFolder.setAttribute("platforms", (Object)this.commaSeparatedList(platforms));
            configurationFolder.setAttribute("collector.providers", (Object)collector);
            configurationFolder.setAttribute("indicator.providers", (Object)this.commaSeparatedList(indicators));
            configurationFolder.createFolder("KnownToolsConfigurationProviders");
            FileObject rootFolder = configuration.getRootFolder();
            FileObject configurationOptionsFolder = rootFolder.getFileObject("ConfigurationOptions");
            if (configurationOptionsFolder != null) {
                FileObject[] children = configurationOptionsFolder.getChildren();
                FileObject folderForCOnfigurationOptions = null;
                if (children != null && children.length > 0) {
                    folderForCOnfigurationOptions = configurationFolder.createFolder(configurationOptionsFolder.getName());
                    for (FileObject fo : children) {
                        if (fo.isFolder()) continue;
                        FileUtil.copyFile((FileObject)fo, (FileObject)folderForCOnfigurationOptions, (String)fo.getName());
                    }
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return this.getConfigurationByName(configurationName);
    }

    DLightConfiguration registerConfiguration(String configurationName, String displayedName, String category, List<String> platforms, String collector, List<String> indicators) {
        FileObject configurationsFolder = this.getToolsFSRoot();
        try {
            FileObject configurationFolder = configurationsFolder.createFolder(configurationName);
            configurationFolder.setAttribute("displayedName", (Object)displayedName);
            configurationFolder.setAttribute("category", (Object)category);
            configurationFolder.setAttribute("platforms", (Object)this.commaSeparatedList(platforms));
            configurationFolder.setAttribute("collector.providers", (Object)collector);
            configurationFolder.setAttribute("indicator.providers", (Object)this.commaSeparatedList(indicators));
            configurationFolder.createFolder("KnownToolsConfigurationProviders");
        }
        catch (IOException ex) {
            return null;
        }
        return this.getConfigurationByName(configurationName);
    }

    public Collection<DLightConfiguration> getConfigurationsByCategoryName(String categoryName) {
        ArrayList<DLightConfiguration> toolConfigurations = new ArrayList<DLightConfiguration>(this.getDLightConfigurations());
        ArrayList<DLightConfiguration> result = new ArrayList<DLightConfiguration>();
        for (DLightConfiguration conf : toolConfigurations) {
            if (categoryName == null || conf.getCategoryName() == null || !conf.getCategoryName().equals(categoryName)) continue;
            result.add(conf);
        }
        return result;
    }

    public DLightConfiguration getConfigurationByName(String configurationName) {
        List<DLightConfiguration> toolConfigurations = this.getDLightConfigurations();
        for (DLightConfiguration conf : toolConfigurations) {
            if (!conf.getConfigurationName().equals(configurationName)) continue;
            return conf;
        }
        return null;
    }

    List<DLightConfiguration> getDLightConfigurations() {
        ArrayList<DLightConfiguration> result = new ArrayList<DLightConfiguration>();
        FileObject configurationsFolder = this.getToolsFSRoot();
        if (configurationsFolder == null) {
            System.err.println("Configurations folder is NULL which should not be");
            return result;
        }
        List configurations = Arrays.asList(configurationsFolder.getChildren());
        if (configurations.isEmpty()) {
            return result;
        }
        configurations = FileUtil.getOrder(configurations, (boolean)false);
        for (FileObject conf : configurations) {
            result.add(DLightConfiguration.create(conf));
        }
        return result;
    }

    DLightConfiguration getSelectedDLightConfiguration() {
        if (this.selectedConfigurationName != null) {
            return this.getConfigurationByName(this.selectedConfigurationName);
        }
        List<DLightConfiguration> tools = this.getDLightConfigurations();
        if (tools == null || tools.size() == 0) {
            return DLightConfiguration.createDefault();
        }
        return tools.get(0);
    }

    public final DLightConfiguration getDefaultConfiguration() {
        return DLightConfiguration.createDefault();
    }

    public static final synchronized DLightConfigurationManager getInstance() {
        if (instance == null) {
            instance = new DLightConfigurationManager();
        }
        return instance;
    }

    final boolean registerTool(String configurationName, String toolID, boolean isOnByDefault) {
        DLightConfiguration configurationToRegister = this.getConfigurationByName(configurationName);
        DLightConfiguration defaultConfiguration = this.getDefaultConfiguration();
        ToolsConfiguration toolsConfiguration = configurationToRegister.getToolsConfiguration();
        return toolsConfiguration.register(defaultConfiguration.getToolsConfiguration().getFileObject(toolID), isOnByDefault);
    }

    final boolean registerTool(String configurationName, DLightTool tool) {
        DLightConfiguration configurationToRegister = this.getConfigurationByName(configurationName);
        DLightConfiguration defaultConfiguration = this.getDefaultConfiguration();
        ToolsConfiguration toolsConfiguration = configurationToRegister.getToolsConfiguration();
        return toolsConfiguration.register(defaultConfiguration.getToolsConfiguration().getFileObject(tool.getID()), tool.isEnabled());
    }

    final boolean deleteTool(String configurationName, DLightTool tool) {
        return this.getConfigurationByName(configurationName).getToolsConfiguration().remove(tool.getID());
    }

    static {
        DLightConfigurationManagerAccessor.setDefault(new DLightConfigurationManagerAccessorImpl());
        instance = null;
    }

    private static class DLightConfigurationManagerAccessorImpl
    extends DLightConfigurationManagerAccessor {
        private DLightConfigurationManagerAccessorImpl() {
        }

        @Override
        public DLightConfiguration getDefaultConfiguration(DLightConfigurationManager manager) {
            return manager.getDefaultConfiguration();
        }

        @Override
        public List<DLightConfiguration> getDLightConfigurations(DLightConfigurationManager manager) {
            return manager.getDLightConfigurations();
        }

        @Override
        public boolean registerTool(DLightConfigurationManager manager, String configurationName, DLightTool tool) {
            return manager.registerTool(configurationName, tool);
        }

        @Override
        public boolean deleteTool(DLightConfigurationManager manager, String configurationName, DLightTool tool) {
            return manager.deleteTool(configurationName, tool);
        }

        @Override
        public DLightConfiguration registerConfiguration(DLightConfigurationManager manager, String configurationName, String displayedName, String category, List<String> platforms, String collector, List<String> indicators) {
            return manager.registerConfiguration(configurationName, displayedName, category, platforms, collector, indicators);
        }

        @Override
        public DLightConfiguration registerConfigurationAsACopy(DLightConfigurationManager manager, DLightConfiguration configuration, String configurationName, String displayedName, String category, List<String> platforms, String collector, List<String> indicators) {
            return manager.registerConfigurationAsACopy(configuration, configurationName, displayedName, category, platforms, collector, indicators);
        }

        @Override
        public boolean removeConfiguration(String configurationName) {
            return DLightConfigurationManager.getInstance().removeConfiguration(configurationName);
        }

        @Override
        public boolean canRemoveConfiguration(String configurationName) {
            return DLightConfigurationManager.getInstance().canDelete(configurationName);
        }

        @Override
        public boolean registerTool(String configurationName, String toolID, boolean isOneByDefault) {
            return DLightConfigurationManager.getInstance().registerTool(configurationName, toolID, isOneByDefault);
        }
    }
}

