/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public class J2SELibrarySourceForBinaryQuery
implements SourceForBinaryQueryImplementation2 {
    private static final Logger LOG = Logger.getLogger(J2SELibrarySourceForBinaryQuery.class.getName());
    private final Map<URL, SourceForBinaryQueryImplementation2.Result> cache = new ConcurrentHashMap<URL, SourceForBinaryQueryImplementation2.Result>();
    private final Map<URL, URL> normalizedURLCache = new ConcurrentHashMap<URL, URL>();

    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL binaryRoot) {
        SourceForBinaryQueryImplementation2.Result res = this.cache.get(binaryRoot);
        if (res != null) {
            return res;
        }
        try {
            boolean isNormalizedURL = J2SELibrarySourceForBinaryQuery.isNormalizedURL(binaryRoot);
            for (LibraryManager mgr : LibraryManager.getOpenManagers()) {
                for (Library lib : mgr.getLibraries()) {
                    if (!lib.getType().equals("j2se")) continue;
                    Iterator i$ = lib.getContent("classpath").iterator();
                    while (i$.hasNext()) {
                        URL entry;
                        URL normalizedEntry = entry = (URL)i$.next();
                        if (isNormalizedURL) {
                            try {
                                normalizedEntry = this.getNormalizedURL(normalizedEntry);
                            }
                            catch (MalformedURLException ex) {
                                LOG.log(Level.INFO, "Invalid URL: " + normalizedEntry, ex);
                                return null;
                            }
                        }
                        if (!binaryRoot.equals(normalizedEntry)) continue;
                        res = new Result(entry, lib);
                        this.cache.put(binaryRoot, res);
                        return res;
                    }
                }
            }
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.INFO, "Invalid URL: " + binaryRoot, ex);
        }
        return null;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    private URL getNormalizedURL(URL url) throws MalformedURLException {
        FileObject fo;
        if (J2SELibrarySourceForBinaryQuery.isNormalizedURL(url)) {
            return url;
        }
        URL normalizedURL = this.normalizedURLCache.get(url);
        if (normalizedURL == null && (fo = URLMapper.findFileObject((URL)url)) != null) {
            try {
                normalizedURL = fo.getURL();
                this.normalizedURLCache.put(url, normalizedURL);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return normalizedURL;
    }

    private static boolean isNormalizedURL(URL url) throws MalformedURLException {
        if ("jar".equals(url.getProtocol())) {
            String path = url.getPath();
            int index = path.indexOf("!/");
            if (index < 0) {
                throw new MalformedURLException();
            }
            String jarPath = path.substring(0, index);
            if (jarPath.indexOf("file://") > -1 && jarPath.indexOf("file:////") == -1) {
                jarPath = jarPath.replaceFirst("file://", "file:////");
            }
            url = new URL(jarPath);
        }
        return "file".equals(url.getProtocol());
    }

    private static class Result
    implements SourceForBinaryQueryImplementation2.Result,
    PropertyChangeListener {
        private Library lib;
        private URL entry;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private FileObject[] cache;

        public Result(URL queryFor, Library lib) {
            this.entry = queryFor;
            this.lib = lib;
            this.lib.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.lib));
        }

        public synchronized FileObject[] getRoots() {
            if (this.cache == null) {
                if (this.lib.getContent("classpath").contains(this.entry)) {
                    ArrayList<FileObject> result = new ArrayList<FileObject>();
                    for (URL u : this.lib.getContent("src")) {
                        FileObject sourceRoot = URLMapper.findFileObject((URL)u);
                        if (sourceRoot == null) continue;
                        result.add(sourceRoot);
                    }
                    this.cache = result.toArray(new FileObject[result.size()]);
                } else {
                    this.cache = new FileObject[0];
                }
            }
            return this.cache;
        }

        public synchronized void addChangeListener(ChangeListener l) {
            assert (l != null) : "Listener cannot be null";
            this.cs.addChangeListener(l);
        }

        public synchronized void removeChangeListener(ChangeListener l) {
            assert (l != null) : "Listener cannot be null";
            this.cs.removeChangeListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("content".equals(event.getPropertyName())) {
                Result result = this;
                synchronized (result) {
                    this.cache = null;
                }
                this.cs.fireChange();
            }
        }

        public boolean preferSources() {
            return false;
        }
    }
}

