/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.api;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.support.DataModelSchemeProvider;
import org.netbeans.modules.dlight.api.visualizer.TableBasedVisualizerConfiguration;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.SourceSupportProvider;
import org.netbeans.modules.dlight.util.ui.Renderer;
import org.netbeans.modules.dlight.visualizers.api.impl.AdvancedTableViewVisualizerConfigurationAccessor;
import org.netbeans.modules.dlight.visualizers.api.impl.OpenFunctionInEditorActionProvider;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class AdvancedTableViewVisualizerConfiguration
implements TableBasedVisualizerConfiguration {
    private final SourceSupportProvider sourceSupportProvider = (SourceSupportProvider)Lookup.getDefault().lookup(SourceSupportProvider.class);
    private final String nodeColumnName;
    private final String nodeRowColumnID;
    private String iconColumnID;
    private String iconPath;
    private final DataTableMetadata dataTableMetadata;
    private NodeActionsProvider nodeActionProvider;
    private TableModel tableModelImpl;
    private String emptyRuntimeMessage;
    private String emptyAnalyzeMessage;
    private List<String> hiddenColumns;
    private boolean dualPaneMode;
    private Renderer<DataRow> dataRowRenderer;

    public AdvancedTableViewVisualizerConfiguration(DataTableMetadata dataTableMetadata, String nodeColumnName, String nodeRowColumnID) {
        this.dataTableMetadata = dataTableMetadata;
        this.nodeColumnName = nodeColumnName;
        this.nodeRowColumnID = nodeRowColumnID;
        this.hiddenColumns = Collections.emptyList();
    }

    public void setEmptyRunningMessage(String emptyRuntimeMessage) {
        this.emptyRuntimeMessage = emptyRuntimeMessage;
    }

    public void setEmptyAnalyzeMessage(String emptyAnalyzeMessage) {
        this.emptyAnalyzeMessage = emptyAnalyzeMessage;
    }

    public void setNodeColumnIcon(String iconColumnID, String resourceID) {
        this.iconColumnID = iconColumnID;
        this.iconPath = resourceID;
    }

    private String getIconColumnID() {
        return this.iconColumnID;
    }

    private String getIconPath() {
        return this.iconPath;
    }

    String getEmptyRunningMessage() {
        return this.emptyRuntimeMessage;
    }

    String getEmptyAnalyzeMessage() {
        return this.emptyAnalyzeMessage;
    }

    public final void setDefaultActionProvider() {
        this.nodeActionProvider = new DefaultGoToSourceActionProvider();
    }

    public final void setNodesActionProvider(NodeActionsProvider nodeActionProvider) {
        this.nodeActionProvider = nodeActionProvider;
    }

    public final void setTableModel(TableModel tableModelImpl) {
        this.tableModelImpl = tableModelImpl;
    }

    public final void setHiddenColumnNames(List<String> hiddenColumns) {
        this.hiddenColumns = Collections.unmodifiableList(new ArrayList<String>(hiddenColumns));
    }

    public void setDualPaneMode(boolean dualPaneMode) {
        this.dualPaneMode = dualPaneMode;
    }

    public void setDataRowRenderer(Renderer<DataRow> dataRowRenderer) {
        this.dataRowRenderer = dataRowRenderer;
    }

    NodeActionsProvider getNodeActionProvider() {
        return this.nodeActionProvider;
    }

    String getNodeColumnName() {
        return this.nodeColumnName;
    }

    String getRowColumnID() {
        return this.nodeRowColumnID;
    }

    TableModel getTableModel() {
        return this.tableModelImpl;
    }

    List<String> getHiddenColumnNames() {
        return this.hiddenColumns;
    }

    public DataModelScheme getSupportedDataScheme() {
        return DataModelSchemeProvider.getInstance().getScheme("model:table");
    }

    public DataTableMetadata getMetadata() {
        return this.dataTableMetadata;
    }

    public String getID() {
        return "advancedTableVisualizer";
    }

    private Renderer<DataRow> getDataRowRenderer() {
        return this.dataRowRenderer;
    }

    private boolean isDualPaneMode() {
        return this.dualPaneMode;
    }

    private void goToSource(DataRow dataRow) {
        String functionName = dataRow.getStringValue(this.nodeColumnName);
        OpenFunctionInEditorActionProvider.getInstance().openFunction(functionName);
    }

    static {
        AdvancedTableViewVisualizerConfigurationAccessor.setDefault(new AdvancedTableViewVisualizerConfigurationAccessorImpl());
    }

    private static final class AdvancedTableViewVisualizerConfigurationAccessorImpl
    extends AdvancedTableViewVisualizerConfigurationAccessor {
        private AdvancedTableViewVisualizerConfigurationAccessorImpl() {
        }

        @Override
        public NodeActionsProvider getNodeActionProvider(AdvancedTableViewVisualizerConfiguration configuration) {
            return configuration.getNodeActionProvider();
        }

        @Override
        public String getNodeColumnName(AdvancedTableViewVisualizerConfiguration configuration) {
            return configuration.getNodeColumnName();
        }

        @Override
        public String getRowNodeColumnName(AdvancedTableViewVisualizerConfiguration configuration) {
            return configuration.getRowColumnID();
        }

        @Override
        public TableModel getTableModel(AdvancedTableViewVisualizerConfiguration configuration) {
            return configuration.getTableModel();
        }

        @Override
        public String getEmptyRunningMessage(AdvancedTableViewVisualizerConfiguration configuration) {
            return configuration.getEmptyRunningMessage();
        }

        @Override
        public String getEmptyAnalyzeMessage(AdvancedTableViewVisualizerConfiguration configuration) {
            return configuration.getEmptyAnalyzeMessage();
        }

        @Override
        public List<String> getHiddenColumnNames(AdvancedTableViewVisualizerConfiguration configuration) {
            return configuration.getHiddenColumnNames();
        }

        @Override
        public boolean isDualPaneMode(AdvancedTableViewVisualizerConfiguration configuration) {
            return configuration.isDualPaneMode();
        }

        @Override
        public Renderer<DataRow> getDetailsRenderer(AdvancedTableViewVisualizerConfiguration configuration) {
            return configuration.getDataRowRenderer();
        }

        @Override
        public String getIconColumnID(AdvancedTableViewVisualizerConfiguration configuration) {
            return configuration.getIconColumnID();
        }

        @Override
        public String getIconPath(AdvancedTableViewVisualizerConfiguration configuration) {
            return configuration.getIconPath();
        }
    }

    final class GoToSourceAction
    extends AbstractAction {
        private DataRow row;

        GoToSourceAction(DataRow row) {
            super(NbBundle.getMessage(AdvancedTableViewVisualizerConfiguration.class, (String)"GoToSourceActionName"));
            this.row = row;
        }

        @Override
        public boolean isEnabled() {
            return AdvancedTableViewVisualizerConfiguration.this.sourceSupportProvider != null && Lookup.getDefault().lookup(SourceFileInfoProvider.class) != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedTableViewVisualizerConfiguration.this.goToSource(this.row);
        }
    }

    private final class DefaultGoToSourceActionProvider
    implements NodeActionsProvider {
        private DefaultGoToSourceActionProvider() {
        }

        public void performDefaultAction(Object node) throws UnknownTypeException {
            if (!(node instanceof DefaultMutableTreeNode)) {
                throw new UnknownTypeException(node);
            }
            if (!(((DefaultMutableTreeNode)node).getUserObject() instanceof DataRow)) {
                throw new UnknownTypeException(node);
            }
            DataRow dataRow = (DataRow)((DefaultMutableTreeNode)node).getUserObject();
            AdvancedTableViewVisualizerConfiguration.this.goToSource(dataRow);
        }

        public Action[] getActions(Object node) throws UnknownTypeException {
            if (!(node instanceof DefaultMutableTreeNode)) {
                throw new UnknownTypeException(node);
            }
            if (!(((DefaultMutableTreeNode)node).getUserObject() instanceof DataRow)) {
                throw new UnknownTypeException(node);
            }
            DataRow dataRow = (DataRow)((DefaultMutableTreeNode)node).getUserObject();
            return new Action[]{new GoToSourceAction(dataRow)};
        }
    }
}

