/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.impl.TableDataProvider;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.OnTimerRefreshVisualizerHandler;
import org.netbeans.modules.dlight.visualizers.OnTimerTask;
import org.netbeans.modules.dlight.visualizers.TableSorter;
import org.netbeans.modules.dlight.visualizers.VisualizerTopComponentTopComponent;
import org.netbeans.modules.dlight.visualizers.api.TableVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.TableVisualizerConfigurationAccessor;
import org.openide.util.NbBundle;

final class TableVisualizer
extends JPanel
implements Visualizer<TableVisualizerConfiguration>,
OnTimerTask,
ComponentListener {
    private static final long MIN_REFRESH_MILLIS = 500L;
    private final TableDataProvider provider;
    private final List<DataRow> data = new ArrayList<DataRow>();
    private final TableVisualizerConfiguration configuration;
    private final OnTimerRefreshVisualizerHandler timerHandler = null;
    private volatile boolean isShown = true;
    private JButton refresh;
    private JTable table;
    private AbstractTableModel tableModel;
    private TableSorter tableSorterModel = new TableSorter();
    private boolean isEmptyContent;
    private boolean isLoadingContent;
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private final Object queryLock = new Object();
    private final Object uiLock = new Object();
    private Future<Boolean> task;

    TableVisualizer(TableDataProvider provider, TableVisualizerConfiguration configuration) {
        super(new BorderLayout());
        this.provider = provider;
        this.configuration = configuration;
        this.setEmptyContent();
        this.addComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().addComponentListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.timerHandler != null) {
            this.timerHandler.stopTimer();
        }
        this.removeComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().removeComponentListener(this);
    }

    private JToolBar createToolbar() {
        JToolBar buttonsToolbar = new JToolBar();
        if (isMacLaf) {
            buttonsToolbar.setBackground(macBackground);
        }
        buttonsToolbar.setFloatable(false);
        buttonsToolbar.setOrientation(1);
        buttonsToolbar.setRollover(true);
        this.refresh = new JButton();
        this.refresh.setIcon(ImageLoader.loadIcon("refresh.png"));
        this.refresh.setToolTipText(TableVisualizer.getMessage("Refresh.Tooltip"));
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableVisualizer.this.asyncFillModel(false);
            }
        });
        buttonsToolbar.add(this.refresh);
        return buttonsToolbar;
    }

    private void setEmptyContent() {
        this.isEmptyContent = true;
        this.removeAll();
        this.table = null;
        if (this.tableSorterModel != null) {
            this.tableSorterModel = null;
        }
        JLabel label = new JLabel(this.timerHandler != null && this.timerHandler.isSessionAnalyzed() ? TableVisualizerConfigurationAccessor.getDefault().getEmptyAnalyzeMessage(this.configuration) : TableVisualizerConfigurationAccessor.getDefault().getEmptyRunningMessage(this.configuration), 0);
        this.add((Component)label, "Center");
        this.add((Component)this.createToolbar(), "West");
        this.repaint();
        this.revalidate();
    }

    private void setLoadingContent() {
        this.isEmptyContent = false;
        this.isLoadingContent = true;
        this.removeAll();
        JLabel label = new JLabel(TableVisualizer.getMessage("Loading"), 0);
        this.add((Component)label, "Center");
        this.repaint();
        this.revalidate();
    }

    private void setContent(boolean isEmpty) {
        if (this.isLoadingContent && isEmpty) {
            this.isLoadingContent = false;
            this.setEmptyContent();
            return;
        }
        if (this.isLoadingContent && !isEmpty) {
            this.isLoadingContent = false;
            this.setNonEmptyContent();
            return;
        }
        if (this.isEmptyContent && !isEmpty) {
            this.setNonEmptyContent();
            return;
        }
        if (isEmpty) {
            this.setEmptyContent();
            return;
        }
    }

    protected void updateList(final List<DataRow> list) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        final boolean isEmptyConent = list == null || list.isEmpty();
        UIThread.invoke((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TableVisualizer.this.uiLock;
                synchronized (object) {
                    TableVisualizer.this.setContent(isEmptyConent);
                    TableVisualizer.this.data.clear();
                    TableVisualizer.this.data.addAll(list);
                    if (!isEmptyConent) {
                        if (TableVisualizer.this.tableModel != null) {
                            TableVisualizer.this.tableModel.fireTableDataChanged();
                        }
                        TableVisualizer.this.setNonEmptyContent();
                    }
                }
            }
        });
    }

    private void setNonEmptyContent() {
        this.isEmptyContent = false;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.tableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return TableVisualizer.this.data.size();
            }

            @Override
            public int getColumnCount() {
                return TableVisualizer.this.configuration.getMetadata().getColumnsCount();
            }

            public Class getColumnClass(int columnIndex) {
                return ((DataTableMetadata.Column)TableVisualizer.this.configuration.getMetadata().getColumns().get(columnIndex)).getColumnClass();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Object x = ((DataRow)TableVisualizer.this.data.get(rowIndex)).getData().get(columnIndex);
                return x;
            }

            @Override
            public String getColumnName(int column) {
                return ((DataTableMetadata.Column)TableVisualizer.this.configuration.getMetadata().getColumns().get(column)).getColumnUName();
            }
        };
        this.tableSorterModel = new TableSorter(this.tableModel);
        this.table = new JTable(this.tableSorterModel);
        this.tableSorterModel.addMouseListenerToHeaderInTable(this.table);
        int columnCount = this.configuration.getMetadata().getColumnsCount();
        int firstKey = 49;
        for (int i = 1; i <= columnCount; ++i) {
            final int columnNumber = i - 1;
            KeyStroke columnKey = KeyStroke.getKeyStroke(firstKey++, 8, true);
            this.table.getInputMap(1).put(columnKey, "ascSortFor" + i);
            this.table.getActionMap().put("ascSortFor" + i, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int column = columnNumber;
                    TableVisualizer.this.tableSorterModel.clickOnColumn(column);
                    TableVisualizer.this.table.getTableHeader().repaint();
                }
            });
        }
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)this.createToolbar(), "West");
        this.repaint();
        this.validate();
    }

    public VisualizerContainer getDefaultContainer() {
        return VisualizerTopComponentTopComponent.findInstance();
    }

    @Override
    public int onTimer() {
        if (!this.isShown || !this.isShowing()) {
            return 0;
        }
        return 0;
    }

    public void refresh() {
        this.asyncFillModel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void asyncFillModel(boolean cancelIfNotDone) {
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null && !this.task.isDone()) {
                if (cancelIfNotDone) {
                    this.task.cancel(true);
                } else {
                    return;
                }
            }
            UIThread.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    TableVisualizer.this.setLoadingContent();
                }
            });
            this.task = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    TableVisualizer.this.syncFillModel(true);
                    return Boolean.FALSE;
                }
            }, (String)("Async TableVisualizer Async data load for " + this.configuration.getID()));
        }
    }

    private void syncFillModel(boolean wait) {
        long startTime = System.currentTimeMillis();
        Future queryDataTask = DLightExecutorService.submit((Callable)new Callable<List<DataRow>>(){

            @Override
            public List<DataRow> call() throws Exception {
                return TableVisualizer.this.provider.queryData(TableVisualizer.this.configuration.getMetadata());
            }
        }, (String)("TableVisualizer Async data from provider  load for " + this.configuration.getID()));
        try {
            final List list = (List)queryDataTask.get();
            this.data.clear();
            this.data.addAll(list);
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            if (wait && duration < 500L) {
                Thread.sleep(500L - duration);
            }
            final boolean isEmptyConent = list == null || list.isEmpty();
            UIThread.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    TableVisualizer.this.setContent(isEmptyConent);
                    if (isEmptyConent) {
                        return;
                    }
                    TableVisualizer.this.updateList(list);
                }
            });
        }
        catch (ExecutionException ex) {
            Thread.currentThread().interrupt();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public TableVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void timerStopped() {
        if (this.isEmptyContent) {
            this.setEmptyContent();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.isShown) {
            return;
        }
        this.isShown = this.isShowing();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.isShown = false;
    }

    public void updateVisualizerConfiguration(TableVisualizerConfiguration configuration) {
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(TableVisualizer.class, (String)key);
    }
}

