/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.parser;

import org.jruby.nb.ast.AssignableNode;
import org.jruby.nb.ast.LocalAsgnNode;
import org.jruby.nb.ast.LocalVarNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.VCallNode;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.parser.BlockStaticScope;
import org.jruby.nb.parser.StaticScope;

public class LocalStaticScope
extends StaticScope {
    private static final long serialVersionUID = 2204064248888411628L;
    private static final String[] NO_NAMES = new String[0];

    public LocalStaticScope(StaticScope enclosingScope) {
        this(enclosingScope, NO_NAMES);
    }

    public LocalStaticScope(StaticScope enclosingScope, String[] names) {
        super(enclosingScope, names);
        this.setArgumentScope(true);
    }

    @Override
    public StaticScope getLocalScope() {
        return this;
    }

    @Override
    public int isDefined(String name, int depth) {
        return depth << 16 | this.exists(name);
    }

    @Override
    public String[] getAllNamesInScope() {
        return this.getVariables();
    }

    @Override
    public AssignableNode assign(ISourcePosition position, String name, Node value, StaticScope topScope, int depth) {
        int slot = this.exists(name);
        if (slot >= 0) {
            if (depth > 0) {
                this.capture(slot);
            }
            return new LocalAsgnNode(position, name, depth << 16 | slot, value);
        }
        if (topScope == this) {
            slot = this.addVariable(name);
            return new LocalAsgnNode(position, name, slot, value);
        }
        return ((BlockStaticScope)topScope).addAssign(position, name, value);
    }

    @Override
    public Node declare(ISourcePosition position, String name, int depth) {
        int slot = this.exists(name);
        if (slot >= 0) {
            if (depth > 0) {
                this.capture(slot);
            }
            return new LocalVarNode(position, depth << 16 | slot, name);
        }
        return new VCallNode(position, name);
    }

    @Override
    public String toString() {
        return "LocalScope: " + super.toString();
    }
}

