/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.lexer.yacc;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import org.jruby.nb.ast.BackRefNode;
import org.jruby.nb.ast.BignumNode;
import org.jruby.nb.ast.CommentNode;
import org.jruby.nb.ast.FixnumNode;
import org.jruby.nb.ast.FloatNode;
import org.jruby.nb.ast.NthRefNode;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.lexer.yacc.HeredocTerm;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.lexer.yacc.ISourcePositionFactory;
import org.jruby.nb.lexer.yacc.LexerSource;
import org.jruby.nb.lexer.yacc.StackState;
import org.jruby.nb.lexer.yacc.StrTerm;
import org.jruby.nb.lexer.yacc.StringTerm;
import org.jruby.nb.lexer.yacc.SyntaxException;
import org.jruby.nb.lexer.yacc.Token;
import org.jruby.nb.parser.ParserSupport;
import org.jruby.util.ByteList;

public class RubyYaccLexer {
    private static ByteList END_MARKER = new ByteList(new byte[]{95, 69, 78, 68, 95, 95});
    private static ByteList BEGIN_DOC_MARKER = new ByteList(new byte[]{98, 101, 103, 105, 110});
    private static ByteList END_DOC_MARKER = new ByteList(new byte[]{101, 110, 100});
    private static HashMap<String, Keyword> map = new HashMap();
    private int token;
    Object yaccValue;
    private LexerSource src;
    private ParserSupport parserSupport = null;
    private IRubyWarnings warnings;
    private LexState lex_state;
    private boolean preserveSpaces;
    public HeredocContext heredocContext;
    private StringBuilder tokenBuffer = new StringBuilder(60);
    private StackState conditionState = new StackState();
    private StackState cmdArgumentState = new StackState();
    private StrTerm lex_strterm;
    private boolean commandStart;
    private boolean doComments;
    static final int EOF = -1;
    static final int STR_FUNC_ESCAPE = 1;
    static final int STR_FUNC_EXPAND = 2;
    static final int STR_FUNC_REGEXP = 4;
    static final int STR_FUNC_QWORDS = 8;
    static final int STR_FUNC_SYMBOL = 16;
    static final int STR_FUNC_INDENT = 32;
    private static final int str_squote = 0;
    private static final int str_dquote = 2;
    private static final int str_xquote = 2;
    private static final int str_regexp = 7;
    private static final int str_ssym = 16;
    private static final int str_dsym = 18;
    private boolean setSpaceSeen;

    private int getFloatToken(String number) {
        double d;
        try {
            d = Double.parseDouble(number);
        }
        catch (NumberFormatException e) {
            this.warnings.warn(IRubyWarnings.ID.FLOAT_OUT_OF_RANGE, this.getPosition(), "Float " + number + " out of range.", number);
            d = number.startsWith("-") ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        this.yaccValue = new FloatNode(this.getPosition(), d);
        return 314;
    }

    private Object newBignumNode(String value, int radix) {
        return new BignumNode(this.getPosition(), new BigInteger(value, radix));
    }

    private Object newFixnumNode(String value, int radix) throws NumberFormatException {
        return new FixnumNode(this.getPosition(), Long.parseLong(value, radix));
    }

    public static Keyword getKeyword(String str) {
        return map.get(str);
    }

    public RubyYaccLexer() {
        this.reset();
    }

    public void reset() {
        this.token = 0;
        this.yaccValue = null;
        this.src = null;
        this.lex_state = null;
        this.lex_state = LexState.EXPR_BEG;
        this.resetStacks();
        this.lex_strterm = null;
        this.commandStart = true;
    }

    public boolean advance() throws IOException {
        this.token = this.yylex();
        return this.token != -1;
    }

    public int token() {
        return this.token;
    }

    public StringBuilder getTokenBuffer() {
        return this.tokenBuffer;
    }

    public Object value() {
        return this.yaccValue;
    }

    public ISourcePositionFactory getPositionFactory() {
        return this.src.getPositionFactory();
    }

    public ISourcePosition getPosition(ISourcePosition startPosition, boolean inclusive) {
        return this.src.getPosition(startPosition, inclusive);
    }

    public ISourcePosition getPosition() {
        return this.src.getPosition(null, false);
    }

    public void setParserSupport(ParserSupport parserSupport) {
        this.parserSupport = parserSupport;
        if (parserSupport.getConfiguration() != null) {
            this.doComments = parserSupport.getConfiguration().hasExtraPositionInformation();
        }
    }

    public void setSource(LexerSource source) {
        this.src = source;
    }

    public StrTerm getStrTerm() {
        return this.lex_strterm;
    }

    public void setStrTerm(StrTerm strterm) {
        this.lex_strterm = strterm;
    }

    public void resetStacks() {
        this.conditionState.reset();
        this.cmdArgumentState.reset();
    }

    public void setWarnings(IRubyWarnings warnings) {
        this.warnings = warnings;
    }

    public void setState(LexState state) {
        this.lex_state = state;
    }

    public StackState getCmdArgumentState() {
        return this.cmdArgumentState;
    }

    public StackState getConditionState() {
        return this.conditionState;
    }

    public void setValue(Object yaccValue) {
        this.yaccValue = yaccValue;
    }

    private boolean isNext_identchar() throws IOException {
        int c = this.src.read();
        this.src.unread(c);
        return c != -1 && (Character.isLetterOrDigit(c) || c == 95);
    }

    private void determineExpressionState() {
        switch (this.lex_state) {
            case EXPR_FNAME: 
            case EXPR_DOT: {
                this.lex_state = LexState.EXPR_ARG;
                break;
            }
            default: {
                this.lex_state = LexState.EXPR_BEG;
            }
        }
    }

    private Object getInteger(String value, int radix) {
        try {
            return this.newFixnumNode(value, radix);
        }
        catch (NumberFormatException e) {
            return this.newBignumNode(value, radix);
        }
    }

    static final boolean isHexChar(int c) {
        return Character.isDigit(c) || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    static final boolean isOctChar(int c) {
        return 48 <= c && c <= 55;
    }

    public static final boolean isIdentifierChar(int c) {
        return Character.isLetterOrDigit(c) || c == 95;
    }

    private int parseQuote(int c) throws IOException {
        int end;
        boolean shortHand;
        int begin;
        if (!Character.isLetterOrDigit(c)) {
            begin = c;
            c = 81;
            shortHand = true;
        } else {
            shortHand = false;
            begin = this.src.read();
            if (Character.isLetterOrDigit(begin)) {
                throw new SyntaxException(SyntaxException.PID.STRING_UNKNOWN_TYPE, this.getPosition(), "unknown type of %string", new Object[0]);
            }
        }
        if (c == -1 || begin == -1) {
            throw new SyntaxException(SyntaxException.PID.STRING_HITS_EOF, this.getPosition(), "unterminated quoted string meets end of file", new Object[0]);
        }
        switch (begin) {
            case 40: {
                end = 41;
                break;
            }
            case 91: {
                end = 93;
                break;
            }
            case 123: {
                end = 125;
                break;
            }
            case 60: {
                end = 62;
                break;
            }
            default: {
                end = begin;
                begin = 0;
            }
        }
        switch (c) {
            case 81: {
                this.lex_strterm = new StringTerm(2, begin, end);
                this.yaccValue = new Token("%" + (shortHand ? "" + end : "" + c + begin), this.getPosition());
                return 367;
            }
            case 113: {
                this.lex_strterm = new StringTerm(0, begin, end);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 367;
            }
            case 87: {
                this.lex_strterm = new StringTerm(10, begin, end);
                while (Character.isWhitespace(c = this.src.read())) {
                }
                this.src.unread(c);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 370;
            }
            case 119: {
                this.lex_strterm = new StringTerm(8, begin, end);
                while (Character.isWhitespace(c = this.src.read())) {
                }
                this.src.unread(c);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 371;
            }
            case 120: {
                this.lex_strterm = new StringTerm(2, begin, end);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 368;
            }
            case 114: {
                this.lex_strterm = new StringTerm(7, begin, end);
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 369;
            }
            case 115: {
                this.lex_strterm = new StringTerm(16, begin, end);
                this.lex_state = LexState.EXPR_FNAME;
                this.yaccValue = new Token("%" + c + begin, this.getPosition());
                return 366;
            }
        }
        throw new SyntaxException(SyntaxException.PID.STRING_UNKNOWN_TYPE, this.getPosition(), "Unknown type of %string. Expected 'Q', 'q', 'w', 'x', 'r' or any non letter character, but found '" + c + "'.", new Object[0]);
    }

    private int hereDocumentIdentifier() throws IOException {
        int term;
        ByteList markerValue;
        int c = this.src.read();
        int func = 0;
        if (c == 45) {
            c = this.src.read();
            func = 32;
        }
        if (c == 39 || c == 34 || c == 96) {
            func = c == 39 ? (func |= 0) : (c == 34 ? (func |= 2) : (func |= 2));
            markerValue = new ByteList();
            term = c;
            while ((c = this.src.read()) != -1 && c != term) {
                markerValue.append(c);
            }
            if (c == -1) {
                throw new SyntaxException(SyntaxException.PID.STRING_MARKER_MISSING, this.getPosition(), "unterminated here document identifier", new Object[0]);
            }
        } else {
            if (!RubyYaccLexer.isIdentifierChar(c)) {
                this.src.unread(c);
                if ((func & 0x20) != 0) {
                    this.src.unread(45);
                }
                return 0;
            }
            markerValue = new ByteList();
            term = 34;
            func |= 2;
            do {
                markerValue.append(c);
            } while ((c = this.src.read()) != -1 && RubyYaccLexer.isIdentifierChar(c));
            this.src.unread(c);
        }
        if (this.preserveSpaces) {
            HeredocTerm h = new HeredocTerm(markerValue, func, null);
            if (term == 96) {
                this.yaccValue = new Token("`", this.getPosition());
                return 368;
            }
            this.yaccValue = new Token("\"", this.getPosition());
            this.heredocContext = this.heredocContext == null ? new HeredocContext(h) : this.heredocContext.add(h);
            return 367;
        }
        ByteList lastLine = this.src.readLineBytes();
        lastLine.append(10);
        this.lex_strterm = new HeredocTerm(markerValue, func, lastLine);
        if (term == 96) {
            this.yaccValue = new Token("`", this.getPosition());
            return 368;
        }
        this.yaccValue = new Token("\"", this.getPosition());
        this.getPosition();
        return 367;
    }

    private void arg_ambiguous() {
        this.warnings.warning(IRubyWarnings.ID.AMBIGUOUS_ARGUMENT, this.getPosition(), "Ambiguous first argument; make sure.", new Object[0]);
    }

    protected int readComment(int c) throws IOException {
        if (this.doComments) {
            return this.readCommentLong(c);
        }
        return this.src.skipUntil(10);
    }

    private int readCommentLong(int c) throws IOException {
        ISourcePosition startPosition = this.src.getPosition();
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append((char)c);
        while ((c = this.src.read()) != 10 && c != -1) {
            this.tokenBuffer.append((char)c);
        }
        this.src.unread(c);
        if (this.parserSupport != null) {
            ISourcePosition position = startPosition.union(this.getPosition());
            this.parserSupport.getResult().addComment(new CommentNode(position, this.tokenBuffer.toString()));
        } else {
            this.getPosition();
        }
        return c;
    }

    private int yylex() throws IOException {
        int c;
        boolean spaceSeen = false;
        if (this.setSpaceSeen) {
            spaceSeen = true;
            this.setSpaceSeen = false;
        }
        if (this.heredocContext != null) {
            HeredocTerm ht;
            if (this.heredocContext.isLookingForEnd()) {
                ht = this.heredocContext.getTerm();
                this.lex_strterm = ht;
            } else if (this.src.isANewLine()) {
                ht = this.heredocContext.getTerm();
                this.lex_strterm = ht;
                this.heredocContext = this.heredocContext.pop();
            }
        }
        if (this.lex_strterm != null) {
            try {
                int tok = this.lex_strterm.parseString(this, this.src);
                if (tok == 374 || tok == 315) {
                    this.lex_strterm = null;
                    this.lex_state = LexState.EXPR_END;
                    if (this.heredocContext != null && this.heredocContext.isLookingForEnd()) {
                        this.heredocContext = this.heredocContext.pop();
                    }
                }
                return tok;
            }
            catch (SyntaxException se) {
                this.lex_strterm = null;
                this.lex_state = LexState.EXPR_END;
                throw se;
            }
        }
        boolean commandState = this.commandStart;
        this.commandStart = false;
        block43: while (true) {
            c = this.src.read();
            switch (c) {
                case -1: 
                case 4: 
                case 26: {
                    return -1;
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    if (this.preserveSpaces) {
                        while ((c = this.src.read()) == 32 || c == 9 || c == 12 || c == 13 || c == 11) {
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("whitespace", this.getPosition());
                        this.setSpaceSeen = true;
                        return 50001;
                    }
                    this.getPosition();
                    spaceSeen = true;
                    continue block43;
                }
                case 35: {
                    if (this.preserveSpaces) {
                        while ((c = this.src.read()) != 10 && c != -1) {
                        }
                        this.yaccValue = new Token("line-comment", this.getPosition());
                        this.setSpaceSeen = spaceSeen;
                        if (this.lex_state != LexState.EXPR_BEG && this.lex_state != LexState.EXPR_FNAME && this.lex_state != LexState.EXPR_DOT && this.lex_state != LexState.EXPR_CLASS) {
                            this.commandStart = true;
                            this.lex_state = LexState.EXPR_BEG;
                        }
                        return 50000;
                    }
                    if (this.readComment(c) == -1) {
                        return -1;
                    }
                }
                case 10: {
                    while ((c = this.src.read()) == 10) {
                    }
                    this.src.unread(c);
                    this.getPosition();
                    if (this.preserveSpaces) {
                        this.src.setIsANewLine(true);
                        this.yaccValue = new Token("whitespace", this.getPosition());
                        if (this.lex_state != LexState.EXPR_BEG && this.lex_state != LexState.EXPR_FNAME && this.lex_state != LexState.EXPR_DOT && this.lex_state != LexState.EXPR_CLASS) {
                            this.commandStart = true;
                            this.lex_state = LexState.EXPR_BEG;
                        }
                        return 50001;
                    }
                    switch (this.lex_state) {
                        case EXPR_FNAME: 
                        case EXPR_DOT: 
                        case EXPR_BEG: 
                        case EXPR_CLASS: {
                            continue block43;
                        }
                    }
                    this.commandStart = true;
                    this.lex_state = LexState.EXPR_BEG;
                    return 10;
                }
                case 42: {
                    return this.star(spaceSeen);
                }
                case 33: {
                    return this.bang();
                }
                case 61: {
                    if (this.src.wasBeginOfLine()) {
                        boolean doComments = this.preserveSpaces;
                        if (this.src.matchMarker(BEGIN_DOC_MARKER, false, false)) {
                            if (doComments) {
                                this.tokenBuffer.setLength(0);
                                this.tokenBuffer.append((CharSequence)BEGIN_DOC_MARKER);
                            }
                            if (Character.isWhitespace(c = this.src.read())) {
                                this.src.unread(c);
                                do {
                                    c = this.src.read();
                                    if (doComments) {
                                        this.tokenBuffer.append((char)c);
                                    }
                                    while (c == 10) {
                                        c = this.src.read();
                                        if (!doComments) continue;
                                        this.tokenBuffer.append((char)c);
                                    }
                                    if (c != -1) continue;
                                    throw new SyntaxException(SyntaxException.PID.STRING_HITS_EOF, this.getPosition(), "embedded document meets end of file", new Object[0]);
                                } while (c != 61 || !this.src.wasBeginOfLine() || !this.src.matchMarker(END_DOC_MARKER, false, false));
                                if (doComments) {
                                    this.tokenBuffer.append((CharSequence)END_DOC_MARKER);
                                }
                                ByteList list = this.src.readLineBytes();
                                if (doComments) {
                                    this.tokenBuffer.append((CharSequence)list);
                                }
                                this.src.unread(10);
                                if (!doComments) continue block43;
                                this.yaccValue = new Token("here-doc", this.getPosition());
                                return 50002;
                            }
                            this.src.unread(c);
                        }
                    }
                    this.determineExpressionState();
                    c = this.src.read();
                    if (c == 61) {
                        c = this.src.read();
                        if (c == 61) {
                            this.yaccValue = new Token("===", this.getPosition());
                            return 322;
                        }
                        this.src.unread(c);
                        this.yaccValue = new Token("==", this.getPosition());
                        return 321;
                    }
                    if (c == 126) {
                        this.yaccValue = new Token("=~", this.getPosition());
                        return 328;
                    }
                    if (c == 62) {
                        this.yaccValue = new Token("=>", this.getPosition());
                        return 340;
                    }
                    this.src.unread(c);
                    this.yaccValue = new Token("=", this.getPosition());
                    return 61;
                }
                case 60: {
                    return this.lessThan(spaceSeen);
                }
                case 62: {
                    return this.greaterThan();
                }
                case 34: {
                    return this.doubleQuote();
                }
                case 96: {
                    return this.backtick(commandState);
                }
                case 39: {
                    return this.singleQuote();
                }
                case 63: {
                    return this.questionMark();
                }
                case 38: {
                    return this.ampersand(spaceSeen);
                }
                case 124: {
                    return this.pipe();
                }
                case 43: {
                    return this.plus(spaceSeen);
                }
                case 45: {
                    return this.minus(spaceSeen);
                }
                case 46: {
                    return this.dot();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumber(c);
                }
                case 41: {
                    return this.rightParen();
                }
                case 93: {
                    return this.rightBracket();
                }
                case 125: {
                    return this.rightCurly();
                }
                case 58: {
                    return this.colon(spaceSeen);
                }
                case 47: {
                    return this.slash(spaceSeen);
                }
                case 94: {
                    return this.caret();
                }
                case 59: {
                    this.commandStart = true;
                }
                case 44: {
                    return this.comma(c);
                }
                case 126: {
                    return this.tilde();
                }
                case 40: {
                    return this.leftParen(spaceSeen);
                }
                case 91: {
                    return this.leftBracket(spaceSeen);
                }
                case 123: {
                    return this.leftCurly();
                }
                case 92: {
                    c = this.src.read();
                    if (c == 10) {
                        spaceSeen = true;
                        continue block43;
                    }
                    this.src.unread(c);
                    this.yaccValue = new Token("\\", this.getPosition());
                    return 92;
                }
                case 37: {
                    return this.percent(spaceSeen);
                }
                case 36: {
                    return this.dollar();
                }
                case 64: {
                    return this.at();
                }
                case 95: {
                    if (this.src.wasBeginOfLine() && this.src.matchMarker(END_MARKER, false, true)) {
                        if (this.parserSupport != null) {
                            this.parserSupport.getResult().setEndOffset(this.src.getOffset());
                        }
                        return -1;
                    }
                    return this.identifier(c, commandState);
                }
            }
            break;
        }
        return this.identifier(c, commandState);
    }

    private int identifierToken(LexState last_state, int result, String value) {
        if (result == 304 && last_state != LexState.EXPR_DOT && this.parserSupport != null && this.parserSupport.getCurrentScope().isDefined(value) >= 0) {
            this.lex_state = LexState.EXPR_END;
        }
        this.yaccValue = new Token(value, result, this.getPosition());
        return result;
    }

    private int getIdentifier(int c) throws IOException {
        do {
            this.tokenBuffer.append((char)c);
        } while (RubyYaccLexer.isIdentifierChar(c = this.src.read()));
        return c;
    }

    private int ampersand(boolean spaceSeen) throws IOException {
        int c = this.src.read();
        switch (c) {
            case 38: {
                this.lex_state = LexState.EXPR_BEG;
                c = this.src.read();
                if (c == 61) {
                    this.yaccValue = new Token("&&", this.getPosition());
                    this.lex_state = LexState.EXPR_BEG;
                    return 339;
                }
                this.src.unread(c);
                this.yaccValue = new Token("&&", this.getPosition());
                return 326;
            }
            case 61: {
                this.yaccValue = new Token("&", this.getPosition());
                this.lex_state = LexState.EXPR_BEG;
                return 339;
            }
        }
        this.src.unread(c);
        ISourcePosition tmpPosition = this.getPosition();
        if ((this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen && !Character.isWhitespace(c)) {
            this.warnings.warning(IRubyWarnings.ID.ARGUMENT_AS_PREFIX, tmpPosition, "`&' interpreted as argument prefix", "&");
            c = 351;
        } else {
            c = this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID ? 351 : 352;
        }
        this.determineExpressionState();
        this.yaccValue = new Token("&", tmpPosition);
        return c;
    }

    private int at() throws IOException {
        int result;
        int c = this.src.read();
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append('@');
        if (c == 64) {
            this.tokenBuffer.append('@');
            c = this.src.read();
            result = 309;
        } else {
            result = 307;
        }
        if (Character.isDigit(c)) {
            if (this.tokenBuffer.length() == 1) {
                throw new SyntaxException(SyntaxException.PID.IVAR_BAD_NAME, this.getPosition(), "`@" + c + "' is not allowed as an instance variable name", new Object[0]);
            }
            throw new SyntaxException(SyntaxException.PID.CVAR_BAD_NAME, this.getPosition(), "`@@" + c + "' is not allowed as a class variable name", new Object[0]);
        }
        if (!RubyYaccLexer.isIdentifierChar(c)) {
            this.src.unread(c);
            this.yaccValue = new Token("@", this.getPosition());
            return 64;
        }
        c = this.getIdentifier(c);
        this.src.unread(c);
        LexState last_state = this.lex_state;
        this.lex_state = LexState.EXPR_END;
        return this.identifierToken(last_state, result, this.tokenBuffer.toString().intern());
    }

    private int backtick(boolean commandState) throws IOException {
        this.yaccValue = new Token("`", this.getPosition());
        switch (this.lex_state) {
            case EXPR_FNAME: {
                this.lex_state = LexState.EXPR_END;
                return 365;
            }
            case EXPR_DOT: {
                this.lex_state = commandState ? LexState.EXPR_CMDARG : LexState.EXPR_ARG;
                return 365;
            }
        }
        this.lex_strterm = new StringTerm(2, 0, 96);
        return 368;
    }

    private int bang() throws IOException {
        int c = this.src.read();
        this.lex_state = LexState.EXPR_BEG;
        switch (c) {
            case 61: {
                this.yaccValue = new Token("!=", this.getPosition());
                return 323;
            }
            case 126: {
                this.yaccValue = new Token("!~", this.getPosition());
                return 329;
            }
        }
        this.src.unread(c);
        this.yaccValue = new Token("!", this.getPosition());
        return 361;
    }

    private int caret() throws IOException {
        int c = this.src.read();
        if (c == 61) {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("^", this.getPosition());
            return 339;
        }
        this.determineExpressionState();
        this.src.unread(c);
        this.yaccValue = new Token("^", this.getPosition());
        return 362;
    }

    private int colon(boolean spaceSeen) throws IOException {
        int c = this.src.read();
        if (c == 58) {
            if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || this.lex_state == LexState.EXPR_CLASS || (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen) {
                this.lex_state = LexState.EXPR_BEG;
                this.yaccValue = new Token("::", this.getPosition());
                return 338;
            }
            this.lex_state = LexState.EXPR_DOT;
            this.yaccValue = new Token(":", this.getPosition());
            return 337;
        }
        if (this.lex_state == LexState.EXPR_END || this.lex_state == LexState.EXPR_ENDARG || Character.isWhitespace(c)) {
            this.src.unread(c);
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token(":", this.getPosition());
            return 58;
        }
        switch (c) {
            case 39: {
                this.lex_strterm = new StringTerm(16, 0, c);
                break;
            }
            case 34: {
                this.lex_strterm = new StringTerm(18, 0, c);
                break;
            }
            default: {
                this.src.unread(c);
            }
        }
        this.lex_state = LexState.EXPR_FNAME;
        this.yaccValue = new Token(":", this.getPosition());
        return 366;
    }

    private int comma(int c) throws IOException {
        this.lex_state = LexState.EXPR_BEG;
        this.yaccValue = new Token(",", this.getPosition());
        return c;
    }

    private int dollar() throws IOException {
        LexState last_state = this.lex_state;
        this.lex_state = LexState.EXPR_END;
        int c = this.src.read();
        switch (c) {
            case 95: {
                c = this.src.read();
                if (RubyYaccLexer.isIdentifierChar(c)) {
                    this.tokenBuffer.setLength(0);
                    this.tokenBuffer.append("$_");
                    c = this.getIdentifier(c);
                    this.src.unread(c);
                    last_state = this.lex_state;
                    this.lex_state = LexState.EXPR_END;
                    return this.identifierToken(last_state, 306, this.tokenBuffer.toString().intern());
                }
                this.src.unread(c);
                c = 95;
            }
            case 33: 
            case 34: 
            case 36: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 126: {
                this.yaccValue = new Token("$" + (char)c, 306, this.getPosition());
                return 306;
            }
            case 45: {
                this.tokenBuffer.setLength(0);
                this.tokenBuffer.append('$');
                this.tokenBuffer.append((char)c);
                c = this.src.read();
                if (RubyYaccLexer.isIdentifierChar(c)) {
                    this.tokenBuffer.append((char)c);
                } else {
                    this.src.unread(c);
                }
                this.yaccValue = new Token(this.tokenBuffer.toString(), 306, this.getPosition());
                return 306;
            }
            case 38: 
            case 39: 
            case 43: 
            case 96: {
                if (last_state == LexState.EXPR_FNAME) {
                    this.yaccValue = new Token("$" + (char)c, 306, this.getPosition());
                    return 306;
                }
                this.yaccValue = new BackRefNode(this.getPosition(), c);
                return 311;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.tokenBuffer.setLength(0);
                this.tokenBuffer.append('$');
                do {
                    this.tokenBuffer.append((char)c);
                } while (Character.isDigit(c = this.src.read()));
                this.src.unread(c);
                if (last_state == LexState.EXPR_FNAME) {
                    this.yaccValue = new Token(this.tokenBuffer.toString(), 306, this.getPosition());
                    return 306;
                }
                this.yaccValue = new NthRefNode(this.getPosition(), Integer.parseInt(this.tokenBuffer.substring(1)));
                return 310;
            }
            case 48: {
                this.lex_state = LexState.EXPR_END;
                return this.identifierToken(last_state, 306, ("$" + (char)c).intern());
            }
        }
        if (!RubyYaccLexer.isIdentifierChar(c)) {
            this.src.unread(c);
            this.yaccValue = new Token("$", this.getPosition());
            return 36;
        }
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append('$');
        int d = this.getIdentifier(c);
        this.src.unread(d);
        last_state = this.lex_state;
        this.lex_state = LexState.EXPR_END;
        return this.identifierToken(last_state, 306, this.tokenBuffer.toString().intern());
    }

    private int dot() throws IOException {
        this.lex_state = LexState.EXPR_BEG;
        int c = this.src.read();
        if (c == 46) {
            c = this.src.read();
            if (c == 46) {
                this.yaccValue = new Token("...", this.getPosition());
                return 332;
            }
            this.src.unread(c);
            this.yaccValue = new Token("..", this.getPosition());
            return 331;
        }
        this.src.unread(c);
        if (Character.isDigit(c)) {
            throw new SyntaxException(SyntaxException.PID.FLOAT_MISSING_ZERO, this.getPosition(), "no .<digit> floating literal anymore; put 0 before dot", new Object[0]);
        }
        this.lex_state = LexState.EXPR_DOT;
        this.yaccValue = new Token(".", this.getPosition());
        return 330;
    }

    private int doubleQuote() throws IOException {
        this.lex_strterm = new StringTerm(2, 0, 34);
        this.yaccValue = new Token("\"", this.getPosition());
        return 367;
    }

    private int greaterThan() throws IOException {
        this.determineExpressionState();
        int c = this.src.read();
        switch (c) {
            case 61: {
                this.yaccValue = new Token(">=", this.getPosition());
                return 324;
            }
            case 62: {
                c = this.src.read();
                if (c == 61) {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token(">>", this.getPosition());
                    return 339;
                }
                this.src.unread(c);
                this.yaccValue = new Token(">>", this.getPosition());
                return 336;
            }
        }
        this.src.unread(c);
        this.yaccValue = new Token(">", this.getPosition());
        return 359;
    }

    private int identifier(int c, boolean commandState) throws IOException {
        Keyword keyword;
        if (!RubyYaccLexer.isIdentifierChar(c)) {
            String badChar = "\\" + Integer.toOctalString(c & 0xFF);
            throw new SyntaxException(SyntaxException.PID.CHARACTER_BAD, this.getPosition(), "Invalid char `" + badChar + "' ('" + (char)c + "') in expression", badChar);
        }
        this.tokenBuffer.setLength(0);
        int first = c;
        boolean wasNewline = this.src.wasBeginOfLine();
        c = this.getIdentifier(c);
        boolean lastBangOrPredicate = false;
        if (c == 33 || c == 63) {
            if (!this.src.peek(61)) {
                lastBangOrPredicate = true;
                this.tokenBuffer.append((char)c);
            } else {
                this.src.unread(c);
            }
        } else {
            this.src.unread(c);
        }
        this.src.setIsANewLine(wasNewline);
        int result = 0;
        LexState last_state = this.lex_state;
        if (lastBangOrPredicate) {
            result = 305;
        } else {
            if (this.lex_state == LexState.EXPR_FNAME) {
                c = this.src.read();
                if (c == 61) {
                    int c2 = this.src.read();
                    if (c2 != 126 && c2 != 62 && (c2 != 61 || c2 == 10 && this.src.peek(62))) {
                        result = 304;
                        this.tokenBuffer.append((char)c);
                        this.src.unread(c2);
                    } else {
                        this.src.unread(c2);
                        this.src.unread(c);
                    }
                } else {
                    this.src.unread(c);
                }
            }
            result = result == 0 && Character.isUpperCase(first) ? 308 : 304;
        }
        String tempVal = this.tokenBuffer.toString().intern();
        if (this.lex_state != LexState.EXPR_DOT && (keyword = RubyYaccLexer.getKeyword(tempVal)) != null) {
            LexState state = this.lex_state;
            this.lex_state = keyword.state;
            if (state == LexState.EXPR_FNAME) {
                this.yaccValue = new Token(keyword.name, this.getPosition());
            } else {
                this.yaccValue = new Token(tempVal, this.getPosition());
                if (keyword.id0 == 280) {
                    if (this.conditionState.isInState()) {
                        return 281;
                    }
                    if (state != LexState.EXPR_CMDARG && this.cmdArgumentState.isInState()) {
                        return 282;
                    }
                    if (state == LexState.EXPR_ENDARG) {
                        return 282;
                    }
                    return 280;
                }
            }
            if (state == LexState.EXPR_BEG) {
                return keyword.id0;
            }
            if (keyword.id0 != keyword.id1) {
                this.lex_state = LexState.EXPR_BEG;
            }
            return keyword.id1;
        }
        switch (this.lex_state) {
            case EXPR_DOT: 
            case EXPR_BEG: 
            case EXPR_MID: 
            case EXPR_ARG: 
            case EXPR_CMDARG: {
                this.lex_state = commandState ? LexState.EXPR_CMDARG : LexState.EXPR_ARG;
                break;
            }
            default: {
                this.lex_state = LexState.EXPR_END;
            }
        }
        return this.identifierToken(last_state, result, tempVal);
    }

    private int leftBracket(boolean spaceSeen) throws IOException {
        int c = 91;
        switch (this.lex_state) {
            case EXPR_FNAME: 
            case EXPR_DOT: {
                this.lex_state = LexState.EXPR_ARG;
                c = this.src.read();
                if (c == 93) {
                    if (this.src.peek(61)) {
                        c = this.src.read();
                        this.yaccValue = new Token("[]=", this.getPosition());
                        return 334;
                    }
                    this.yaccValue = new Token("[]", this.getPosition());
                    return 333;
                }
                this.src.unread(c);
                this.yaccValue = new Token("[", this.getPosition());
                return 91;
            }
            case EXPR_BEG: 
            case EXPR_MID: {
                c = 345;
                break;
            }
            case EXPR_ARG: 
            case EXPR_CMDARG: {
                if (!spaceSeen) break;
                c = 345;
            }
        }
        this.lex_state = LexState.EXPR_BEG;
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.yaccValue = new Token("[", this.getPosition());
        return c;
    }

    private int leftCurly() {
        int c;
        switch (this.lex_state) {
            case EXPR_ARG: 
            case EXPR_CMDARG: 
            case EXPR_END: {
                c = 363;
                break;
            }
            case EXPR_ENDARG: {
                c = 348;
                break;
            }
            default: {
                c = 347;
            }
        }
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.lex_state = LexState.EXPR_BEG;
        this.yaccValue = new Token("{", this.getPosition());
        return c;
    }

    private int leftParen(boolean spaceSeen) throws IOException {
        int result;
        this.commandStart = true;
        switch (this.lex_state) {
            case EXPR_BEG: 
            case EXPR_MID: {
                result = 341;
                break;
            }
            case EXPR_CMDARG: {
                result = spaceSeen ? 344 : 342;
                break;
            }
            case EXPR_ARG: {
                if (spaceSeen) {
                    this.warnings.warn(IRubyWarnings.ID.ARGUMENT_EXTRA_SPACE, this.getPosition(), "don't put space before argument parentheses", new Object[0]);
                }
            }
            default: {
                result = 342;
            }
        }
        this.conditionState.stop();
        this.cmdArgumentState.stop();
        this.lex_state = LexState.EXPR_BEG;
        this.yaccValue = new Token("(", this.getPosition());
        return result;
    }

    private int lessThan(boolean spaceSeen) throws IOException {
        int tok;
        int c = this.src.read();
        if (c == 60 && this.lex_state != LexState.EXPR_END && this.lex_state != LexState.EXPR_DOT && this.lex_state != LexState.EXPR_ENDARG && this.lex_state != LexState.EXPR_CLASS && (this.lex_state != LexState.EXPR_ARG && this.lex_state != LexState.EXPR_CMDARG || spaceSeen) && (tok = this.hereDocumentIdentifier()) != 0) {
            return tok;
        }
        this.determineExpressionState();
        switch (c) {
            case 61: {
                c = this.src.read();
                if (c == 62) {
                    this.yaccValue = new Token("<=>", this.getPosition());
                    return 320;
                }
                this.src.unread(c);
                this.yaccValue = new Token("<=", this.getPosition());
                return 325;
            }
            case 60: {
                c = this.src.read();
                if (c == 61) {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token("<<", this.getPosition());
                    return 339;
                }
                this.src.unread(c);
                this.yaccValue = new Token("<<", this.getPosition());
                return 335;
            }
        }
        this.yaccValue = new Token("<", this.getPosition());
        this.src.unread(c);
        return 358;
    }

    private int minus(boolean spaceSeen) throws IOException {
        int c = this.src.read();
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.lex_state = LexState.EXPR_ARG;
            if (c == 64) {
                this.yaccValue = new Token("-@", this.getPosition());
                return 317;
            }
            this.src.unread(c);
            this.yaccValue = new Token("-", this.getPosition());
            return 357;
        }
        if (c == 61) {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("-", this.getPosition());
            return 339;
        }
        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen && !Character.isWhitespace(c)) {
            if (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) {
                this.arg_ambiguous();
            }
            this.lex_state = LexState.EXPR_BEG;
            this.src.unread(c);
            this.yaccValue = new Token("-", this.getPosition());
            if (Character.isDigit(c)) {
                return 318;
            }
            return 317;
        }
        this.lex_state = LexState.EXPR_BEG;
        this.src.unread(c);
        this.yaccValue = new Token("-", this.getPosition());
        return 357;
    }

    private int percent(boolean spaceSeen) throws IOException {
        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID) {
            return this.parseQuote(this.src.read());
        }
        int c = this.src.read();
        if (c == 61) {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("%", this.getPosition());
            return 339;
        }
        if ((this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen && !Character.isWhitespace(c)) {
            return this.parseQuote(c);
        }
        this.determineExpressionState();
        this.src.unread(c);
        this.yaccValue = new Token("%", this.getPosition());
        return 354;
    }

    private int pipe() throws IOException {
        int c = this.src.read();
        switch (c) {
            case 124: {
                this.lex_state = LexState.EXPR_BEG;
                c = this.src.read();
                if (c == 61) {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token("||", this.getPosition());
                    return 339;
                }
                this.src.unread(c);
                this.yaccValue = new Token("||", this.getPosition());
                return 327;
            }
            case 61: {
                this.lex_state = LexState.EXPR_BEG;
                this.yaccValue = new Token("|", this.getPosition());
                return 339;
            }
        }
        this.determineExpressionState();
        this.src.unread(c);
        this.yaccValue = new Token("|", this.getPosition());
        return 360;
    }

    private int plus(boolean spaceSeen) throws IOException {
        int c = this.src.read();
        if (this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) {
            this.lex_state = LexState.EXPR_ARG;
            if (c == 64) {
                this.yaccValue = new Token("+@", this.getPosition());
                return 316;
            }
            this.src.unread(c);
            this.yaccValue = new Token("+", this.getPosition());
            return 356;
        }
        if (c == 61) {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("+", this.getPosition());
            return 339;
        }
        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID || (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen && !Character.isWhitespace(c)) {
            if (this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) {
                this.arg_ambiguous();
            }
            this.lex_state = LexState.EXPR_BEG;
            this.src.unread(c);
            if (Character.isDigit(c)) {
                c = 43;
                return this.parseNumber(c);
            }
            this.yaccValue = new Token("+", this.getPosition());
            return 316;
        }
        this.lex_state = LexState.EXPR_BEG;
        this.src.unread(c);
        this.yaccValue = new Token("+", this.getPosition());
        return 356;
    }

    private int questionMark() throws IOException {
        if (this.lex_state == LexState.EXPR_END || this.lex_state == LexState.EXPR_ENDARG) {
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("?", this.getPosition());
            return 63;
        }
        int c = this.src.read();
        if (c == -1) {
            throw new SyntaxException(SyntaxException.PID.INCOMPLETE_CHAR_SYNTAX, this.getPosition(), "incomplete character syntax", new Object[0]);
        }
        if (Character.isWhitespace(c)) {
            if (this.lex_state != LexState.EXPR_ARG && this.lex_state != LexState.EXPR_CMDARG) {
                int c2 = 0;
                switch (c) {
                    case 32: {
                        c2 = 115;
                        break;
                    }
                    case 10: {
                        c2 = 110;
                        break;
                    }
                    case 9: {
                        c2 = 116;
                        break;
                    }
                    case 13: {
                        c2 = 114;
                        break;
                    }
                    case 12: {
                        c2 = 102;
                    }
                }
                if (c2 != 0) {
                    this.warnings.warn(IRubyWarnings.ID.INVALID_CHAR_SEQUENCE, this.getPosition(), "invalid character syntax; use ?\\" + c2, new Object[0]);
                }
            }
            this.src.unread(c);
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("?", this.getPosition());
            return 63;
        }
        if (RubyYaccLexer.isIdentifierChar(c) && !this.src.peek(10) && this.isNext_identchar()) {
            this.src.unread(c);
            this.lex_state = LexState.EXPR_BEG;
            this.yaccValue = new Token("?", this.getPosition());
            return 63;
        }
        if (c == 92) {
            c = this.readEscape();
        }
        this.lex_state = LexState.EXPR_END;
        this.yaccValue = new FixnumNode(this.getPosition(), c &= 0xFF);
        return 313;
    }

    private int rightBracket() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.lex_state = LexState.EXPR_END;
        this.yaccValue = new Token(")", this.getPosition());
        return 346;
    }

    private int rightCurly() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.lex_state = LexState.EXPR_END;
        this.yaccValue = new Token("}", this.getPosition());
        return 364;
    }

    private int rightParen() {
        this.conditionState.restart();
        this.cmdArgumentState.restart();
        this.lex_state = LexState.EXPR_END;
        this.yaccValue = new Token(")", this.getPosition());
        return 343;
    }

    private int singleQuote() throws IOException {
        this.lex_strterm = new StringTerm(0, 0, 39);
        this.yaccValue = new Token("'", this.getPosition());
        return 367;
    }

    private int slash(boolean spaceSeen) throws IOException {
        if (this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID) {
            this.lex_strterm = new StringTerm(7, 0, 47);
            this.yaccValue = new Token("/", this.getPosition());
            return 369;
        }
        int c = this.src.read();
        if (c == 61) {
            this.yaccValue = new Token("/", this.getPosition());
            this.lex_state = LexState.EXPR_BEG;
            return 339;
        }
        this.src.unread(c);
        if ((this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen && !Character.isWhitespace(c)) {
            this.arg_ambiguous();
            this.lex_strterm = new StringTerm(7, 0, 47);
            this.yaccValue = new Token("/", this.getPosition());
            return 369;
        }
        this.determineExpressionState();
        this.yaccValue = new Token("/", this.getPosition());
        return 355;
    }

    private int star(boolean spaceSeen) throws IOException {
        int c = this.src.read();
        switch (c) {
            case 42: {
                c = this.src.read();
                if (c == 61) {
                    this.lex_state = LexState.EXPR_BEG;
                    this.yaccValue = new Token("**", this.getPosition());
                    return 339;
                }
                this.src.unread(c);
                this.yaccValue = new Token("**", this.getPosition());
                c = 319;
                break;
            }
            case 61: {
                this.lex_state = LexState.EXPR_BEG;
                this.yaccValue = new Token("*", this.getPosition());
                return 339;
            }
            default: {
                this.src.unread(c);
                if ((this.lex_state == LexState.EXPR_ARG || this.lex_state == LexState.EXPR_CMDARG) && spaceSeen && !Character.isWhitespace(c)) {
                    this.warnings.warning(IRubyWarnings.ID.ARGUMENT_AS_PREFIX, this.getPosition(), "`*' interpreted as argument prefix", "*");
                    c = 349;
                } else {
                    c = this.lex_state == LexState.EXPR_BEG || this.lex_state == LexState.EXPR_MID ? 349 : 350;
                }
                this.yaccValue = new Token("*", this.getPosition());
            }
        }
        this.determineExpressionState();
        return c;
    }

    private int tilde() throws IOException {
        int c;
        if ((this.lex_state == LexState.EXPR_FNAME || this.lex_state == LexState.EXPR_DOT) && (c = this.src.read()) != 64) {
            this.src.unread(c);
        }
        this.determineExpressionState();
        this.yaccValue = new Token("~", this.getPosition());
        return 353;
    }

    private int parseNumber(int c) throws IOException {
        this.lex_state = LexState.EXPR_END;
        this.tokenBuffer.setLength(0);
        if (c == 45) {
            this.tokenBuffer.append((char)c);
            c = this.src.read();
        } else if (c == 43) {
            c = this.src.read();
        }
        int nondigit = 0;
        if (c == 48) {
            int startLen = this.tokenBuffer.length();
            c = this.src.read();
            switch (c) {
                case 88: 
                case 120: {
                    c = this.src.read();
                    if (RubyYaccLexer.isHexChar(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!RubyYaccLexer.isHexChar(c)) break;
                                nondigit = 0;
                                this.tokenBuffer.append((char)c);
                            }
                            c = this.src.read();
                        }
                    }
                    this.src.unread(c);
                    if (this.tokenBuffer.length() == startLen) {
                        throw new SyntaxException(SyntaxException.PID.BAD_HEX_NUMBER, this.getPosition(), "Hexadecimal number without hex-digits.", new Object[0]);
                    }
                    if (nondigit != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 16);
                    return 313;
                }
                case 66: 
                case 98: {
                    c = this.src.read();
                    if (c == 48 || c == 49) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (c != 48 && c != 49) break;
                                nondigit = 0;
                                this.tokenBuffer.append((char)c);
                            }
                            c = this.src.read();
                        }
                    }
                    this.src.unread(c);
                    if (this.tokenBuffer.length() == startLen) {
                        throw new SyntaxException(SyntaxException.PID.EMPTY_BINARY_NUMBER, this.getPosition(), "Binary number without digits.", new Object[0]);
                    }
                    if (nondigit != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 2);
                    return 313;
                }
                case 68: 
                case 100: {
                    c = this.src.read();
                    if (Character.isDigit(c)) {
                        while (true) {
                            if (c == 95) {
                                if (nondigit != 0) break;
                                nondigit = c;
                            } else {
                                if (!Character.isDigit(c)) break;
                                nondigit = 0;
                                this.tokenBuffer.append((char)c);
                            }
                            c = this.src.read();
                        }
                    }
                    this.src.unread(c);
                    if (this.tokenBuffer.length() == startLen) {
                        throw new SyntaxException(SyntaxException.PID.EMPTY_BINARY_NUMBER, this.getPosition(), "Binary number without digits.", new Object[0]);
                    }
                    if (nondigit != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                    }
                    this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 10);
                    return 313;
                }
                case 111: {
                    c = this.src.read();
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 95: {
                    while (true) {
                        if (c == 95) {
                            if (nondigit != 0) break;
                            nondigit = c;
                        } else {
                            if (c < 48 || c > 55) break;
                            nondigit = 0;
                            this.tokenBuffer.append((char)c);
                        }
                        c = this.src.read();
                    }
                    if (this.tokenBuffer.length() > startLen) {
                        this.src.unread(c);
                        if (nondigit != 0) {
                            throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                        }
                        this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 8);
                        return 313;
                    }
                }
                case 56: 
                case 57: {
                    throw new SyntaxException(SyntaxException.PID.BAD_OCTAL_DIGIT, this.getPosition(), "Illegal octal digit.", new Object[0]);
                }
                case 46: 
                case 69: 
                case 101: {
                    this.tokenBuffer.append('0');
                    break;
                }
                default: {
                    this.src.unread(c);
                    this.yaccValue = new FixnumNode(this.getPosition(), 0L);
                    return 313;
                }
            }
        }
        boolean seen_point = false;
        boolean seen_e = false;
        while (true) {
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    nondigit = 0;
                    this.tokenBuffer.append((char)c);
                    break;
                }
                case 46: {
                    if (nondigit != 0) {
                        this.src.unread(c);
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                    }
                    if (seen_point || seen_e) {
                        this.src.unread(c);
                        return this.getNumberToken(this.tokenBuffer.toString(), true, nondigit);
                    }
                    int c2 = this.src.read();
                    if (!Character.isDigit(c2)) {
                        this.src.unread(c2);
                        this.src.unread(46);
                        if (c == 95) break;
                        this.yaccValue = this.getInteger(this.tokenBuffer.toString(), 10);
                        return 313;
                    }
                    this.tokenBuffer.append('.');
                    this.tokenBuffer.append((char)c2);
                    seen_point = true;
                    nondigit = 0;
                    break;
                }
                case 69: 
                case 101: {
                    if (nondigit != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                    }
                    if (seen_e) {
                        this.src.unread(c);
                        return this.getNumberToken(this.tokenBuffer.toString(), true, nondigit);
                    }
                    this.tokenBuffer.append((char)c);
                    seen_e = true;
                    nondigit = c;
                    c = this.src.read();
                    if (c == 45 || c == 43) {
                        this.tokenBuffer.append((char)c);
                        nondigit = c;
                        break;
                    }
                    this.src.unread(c);
                    break;
                }
                case 95: {
                    if (nondigit != 0) {
                        throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
                    }
                    nondigit = c;
                    break;
                }
                default: {
                    this.src.unread(c);
                    return this.getNumberToken(this.tokenBuffer.toString(), seen_e || seen_point, nondigit);
                }
            }
            c = this.src.read();
        }
    }

    private int getNumberToken(String number, boolean isFloat, int nondigit) {
        if (nondigit != 0) {
            throw new SyntaxException(SyntaxException.PID.TRAILING_UNDERSCORE_IN_NUMBER, this.getPosition(), "Trailing '_' in number.", new Object[0]);
        }
        if (isFloat) {
            return this.getFloatToken(number);
        }
        this.yaccValue = this.getInteger(number, 10);
        return 313;
    }

    public int readEscape() throws IOException {
        int c = this.src.read();
        switch (c) {
            case 92: {
                return c;
            }
            case 110: {
                return 10;
            }
            case 116: {
                return 9;
            }
            case 114: {
                return 13;
            }
            case 102: {
                return 12;
            }
            case 118: {
                return 11;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.src.unread(c);
                return this.scanOct(3);
            }
            case 120: {
                int i;
                int hexValue = 0;
                for (i = 0; i < 2; ++i) {
                    int h1 = this.src.read();
                    if (!RubyYaccLexer.isHexChar(h1)) {
                        this.src.unread(h1);
                        break;
                    }
                    hexValue = (char)(hexValue << 4);
                    hexValue = (char)(hexValue | Integer.parseInt("" + (char)h1, 16) & 0xF);
                }
                if (i == 0) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                return hexValue;
            }
            case 98: {
                return 8;
            }
            case 115: {
                return 32;
            }
            case 77: {
                c = this.src.read();
                if (c != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                c = this.src.read();
                if (c == 92) {
                    return (char)(this.readEscape() | 0x80);
                }
                if (c == -1) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
                return (char)(c & 0xFF | 0x80);
            }
            case 67: {
                c = this.src.read();
                if (c != 45) {
                    throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), "Invalid escape character syntax", new Object[0]);
                }
            }
            case 99: {
                c = this.src.read();
                if (c == 92) {
                    c = this.readEscape();
                } else {
                    if (c == 63) {
                        return 375;
                    }
                    if (c == -1) {
                        throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), "Invalid escape character syntax", new Object[0]);
                    }
                }
                return (char)(c & 0x9F);
            }
            case -1: {
                throw new SyntaxException(SyntaxException.PID.INVALID_ESCAPE_SYNTAX, this.getPosition(), "Invalid escape character syntax", new Object[0]);
            }
        }
        return c;
    }

    private char scanOct(int count) throws IOException {
        char value = '\u0000';
        for (int i = 0; i < count; ++i) {
            int c = this.src.read();
            if (!RubyYaccLexer.isOctChar(c)) {
                this.src.unread(c);
                break;
            }
            value = (char)(value << 3);
            value = (char)(value | Integer.parseInt("" + (char)c, 8));
        }
        return value;
    }

    public void setPreserveSpaces(boolean preserveSpaces) {
        this.preserveSpaces = preserveSpaces;
    }

    public boolean getPreserveSpaces() {
        return this.preserveSpaces;
    }

    public LexState getLexState() {
        return this.lex_state;
    }

    public void setLexState(LexState lex_state) {
        this.lex_state = lex_state;
    }

    public boolean isSetSpaceSeen() {
        return this.setSpaceSeen;
    }

    public void setSpaceSeen(boolean setSpaceSeen) {
        this.setSpaceSeen = setSpaceSeen;
    }

    public boolean isCommandStart() {
        return this.commandStart;
    }

    public void setCommandStart(boolean commandStart) {
        this.commandStart = commandStart;
    }

    public LexerSource getSource() {
        return this.src;
    }

    static {
        map.put("end", Keyword.END);
        map.put("else", Keyword.ELSE);
        map.put("case", Keyword.CASE);
        map.put("ensure", Keyword.ENSURE);
        map.put("module", Keyword.MODULE);
        map.put("elsif", Keyword.ELSIF);
        map.put("def", Keyword.DEF);
        map.put("rescue", Keyword.RESCUE);
        map.put("not", Keyword.NOT);
        map.put("then", Keyword.THEN);
        map.put("yield", Keyword.YIELD);
        map.put("for", Keyword.FOR);
        map.put("self", Keyword.SELF);
        map.put("false", Keyword.FALSE);
        map.put("retry", Keyword.RETRY);
        map.put("return", Keyword.RETURN);
        map.put("true", Keyword.TRUE);
        map.put("if", Keyword.IF);
        map.put("defined?", Keyword.DEFINED_P);
        map.put("super", Keyword.SUPER);
        map.put("undef", Keyword.UNDEF);
        map.put("break", Keyword.BREAK);
        map.put("in", Keyword.IN);
        map.put("do", Keyword.DO);
        map.put("nil", Keyword.NIL);
        map.put("until", Keyword.UNTIL);
        map.put("unless", Keyword.UNLESS);
        map.put("or", Keyword.OR);
        map.put("next", Keyword.NEXT);
        map.put("when", Keyword.WHEN);
        map.put("redo", Keyword.REDO);
        map.put("and", Keyword.AND);
        map.put("begin", Keyword.BEGIN);
        map.put("__LINE__", Keyword.__LINE__);
        map.put("class", Keyword.CLASS);
        map.put("__FILE__", Keyword.__FILE__);
        map.put("END", Keyword.LEND);
        map.put("BEGIN", Keyword.LBEGIN);
        map.put("while", Keyword.WHILE);
        map.put("alias", Keyword.ALIAS);
    }

    public static class HeredocContext {
        private HeredocTerm[] heredocTerms;
        private boolean[] lookingForEnds;

        public HeredocContext(HeredocTerm term) {
            this.heredocTerms = new HeredocTerm[]{term, term};
            this.lookingForEnds = new boolean[]{false, true};
        }

        private HeredocContext(HeredocTerm[] terms, boolean[] lookingForEnds) {
            this.heredocTerms = terms;
            this.lookingForEnds = lookingForEnds;
        }

        private HeredocContext add(HeredocTerm h) {
            HeredocTerm[] copy = new HeredocTerm[this.heredocTerms.length + 2];
            System.arraycopy(this.heredocTerms, 0, copy, 0, this.heredocTerms.length);
            copy[this.heredocTerms.length] = h;
            copy[this.heredocTerms.length + 1] = h;
            boolean[] copy2 = new boolean[this.lookingForEnds.length + 2];
            System.arraycopy(this.lookingForEnds, 0, copy2, 0, this.lookingForEnds.length);
            copy2[this.lookingForEnds.length] = false;
            copy2[this.lookingForEnds.length + 1] = true;
            HeredocContext hc = new HeredocContext(copy, copy2);
            return hc;
        }

        private HeredocTerm getTerm() {
            return this.heredocTerms[0];
        }

        private HeredocContext pop() {
            if (this.heredocTerms.length > 1) {
                HeredocTerm[] copy = new HeredocTerm[this.heredocTerms.length - 1];
                System.arraycopy(this.heredocTerms, 1, copy, 0, copy.length);
                boolean[] copy2 = new boolean[this.lookingForEnds.length - 1];
                System.arraycopy(this.lookingForEnds, 1, copy2, 0, copy2.length);
                HeredocContext hc = new HeredocContext(copy, copy2);
                return hc;
            }
            return null;
        }

        public boolean isLookingForEnd() {
            return this.lookingForEnds[0];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("HeredocContext(count=");
            sb.append(Integer.toString(this.heredocTerms.length));
            sb.append("):");
            for (int i = 0; i < this.heredocTerms.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("end:");
                sb.append(this.lookingForEnds[i]);
                sb.append(",term:");
                sb.append(this.heredocTerms[i]);
            }
            return sb.toString();
        }

        public int hashCode() {
            return this.heredocTerms[0].getMutableState().hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof HeredocContext) {
                HeredocContext o = (HeredocContext)other;
                if (o.heredocTerms.length != this.heredocTerms.length) {
                    return false;
                }
                return this.heredocTerms[0].getMutableState().equals(o.heredocTerms[0].getMutableState());
            }
            return false;
        }
    }

    public static final class LexState
    extends Enum<LexState> {
        public static final /* enum */ LexState EXPR_BEG = new LexState();
        public static final /* enum */ LexState EXPR_END = new LexState();
        public static final /* enum */ LexState EXPR_ARG = new LexState();
        public static final /* enum */ LexState EXPR_CMDARG = new LexState();
        public static final /* enum */ LexState EXPR_ENDARG = new LexState();
        public static final /* enum */ LexState EXPR_MID = new LexState();
        public static final /* enum */ LexState EXPR_FNAME = new LexState();
        public static final /* enum */ LexState EXPR_DOT = new LexState();
        public static final /* enum */ LexState EXPR_CLASS = new LexState();
        private int ordinal;
        private static final /* synthetic */ LexState[] $VALUES;

        public static LexState[] values() {
            return (LexState[])$VALUES.clone();
        }

        public static LexState valueOf(String name) {
            return Enum.valueOf(LexState.class, name);
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public static LexState fromOrdinal(int ordinal) {
            switch (ordinal) {
                case 0: {
                    return EXPR_BEG;
                }
                case 1: {
                    return EXPR_END;
                }
                case 2: {
                    return EXPR_ARG;
                }
                case 3: {
                    return EXPR_CMDARG;
                }
                case 4: {
                    return EXPR_ENDARG;
                }
                case 5: {
                    return EXPR_MID;
                }
                case 6: {
                    return EXPR_FNAME;
                }
                case 7: {
                    return EXPR_DOT;
                }
                case 8: {
                    return EXPR_CLASS;
                }
            }
            return null;
        }

        static {
            $VALUES = new LexState[]{EXPR_BEG, EXPR_END, EXPR_ARG, EXPR_CMDARG, EXPR_ENDARG, EXPR_MID, EXPR_FNAME, EXPR_DOT, EXPR_CLASS};
            LexState.EXPR_BEG.ordinal = 0;
            LexState.EXPR_END.ordinal = 1;
            LexState.EXPR_ARG.ordinal = 2;
            LexState.EXPR_CMDARG.ordinal = 3;
            LexState.EXPR_ENDARG.ordinal = 4;
            LexState.EXPR_MID.ordinal = 5;
            LexState.EXPR_FNAME.ordinal = 6;
            LexState.EXPR_DOT.ordinal = 7;
            LexState.EXPR_CLASS.ordinal = 8;
            assert (LexState.EXPR_CLASS.ordinal == EXPR_CLASS.ordinal());
        }
    }

    public static enum Keyword {
        END("end", 264, 264, LexState.EXPR_END),
        ELSE("else", 269, 269, LexState.EXPR_BEG),
        CASE("case", 270, 270, LexState.EXPR_BEG),
        ENSURE("ensure", 263, 263, LexState.EXPR_BEG),
        MODULE("module", 258, 258, LexState.EXPR_BEG),
        ELSIF("elsif", 268, 268, LexState.EXPR_BEG),
        DEF("def", 259, 259, LexState.EXPR_FNAME),
        RESCUE("rescue", 262, 297, LexState.EXPR_MID),
        NOT("not", 292, 292, LexState.EXPR_BEG),
        THEN("then", 267, 267, LexState.EXPR_BEG),
        YIELD("yield", 284, 284, LexState.EXPR_ARG),
        FOR("for", 274, 274, LexState.EXPR_BEG),
        SELF("self", 286, 286, LexState.EXPR_END),
        FALSE("false", 289, 289, LexState.EXPR_END),
        RETRY("retry", 278, 278, LexState.EXPR_END),
        RETURN("return", 283, 283, LexState.EXPR_MID),
        TRUE("true", 288, 288, LexState.EXPR_END),
        IF("if", 265, 293, LexState.EXPR_BEG),
        DEFINED_P("defined?", 299, 299, LexState.EXPR_ARG),
        SUPER("super", 285, 285, LexState.EXPR_ARG),
        UNDEF("undef", 260, 260, LexState.EXPR_FNAME),
        BREAK("break", 275, 275, LexState.EXPR_MID),
        IN("in", 279, 279, LexState.EXPR_BEG),
        DO("do", 280, 280, LexState.EXPR_BEG),
        NIL("nil", 287, 287, LexState.EXPR_END),
        UNTIL("until", 273, 296, LexState.EXPR_BEG),
        UNLESS("unless", 266, 294, LexState.EXPR_BEG),
        OR("or", 291, 291, LexState.EXPR_BEG),
        NEXT("next", 276, 276, LexState.EXPR_MID),
        WHEN("when", 271, 271, LexState.EXPR_BEG),
        REDO("redo", 277, 277, LexState.EXPR_END),
        AND("and", 290, 290, LexState.EXPR_BEG),
        BEGIN("begin", 261, 261, LexState.EXPR_BEG),
        __LINE__("__LINE__", 302, 302, LexState.EXPR_END),
        CLASS("class", 257, 257, LexState.EXPR_CLASS),
        __FILE__("__FILE__", 303, 303, LexState.EXPR_END),
        LEND("END", 301, 301, LexState.EXPR_END),
        LBEGIN("BEGIN", 300, 300, LexState.EXPR_END),
        WHILE("while", 272, 295, LexState.EXPR_BEG),
        ALIAS("alias", 298, 298, LexState.EXPR_FNAME);

        public final String name;
        public final int id0;
        public final int id1;
        public final LexState state;

        private Keyword(String name, int id0, int id1, LexState state) {
            this.name = name;
            this.id0 = id0;
            this.id1 = id1;
            this.state = state;
        }
    }
}

