/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.lexer.yacc;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jruby.nb.lexer.yacc.IDESourcePositionFactory;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.lexer.yacc.ISourcePositionFactory;
import org.jruby.nb.lexer.yacc.InputStreamLexerSource;
import org.jruby.nb.lexer.yacc.SimplePositionFactory;
import org.jruby.nb.parser.ParserConfiguration;
import org.jruby.util.ByteList;

public abstract class LexerSource {
    private ISourcePositionFactory positionFactory;
    private final String sourceName;
    protected int line = 0;
    protected int offset = 0;
    private List<String> list;
    private StringBuilder lineBuffer;

    protected LexerSource(String sourceName, List<String> list, int line, boolean extraPositionInformation) {
        this.sourceName = sourceName;
        this.line = line;
        this.positionFactory = extraPositionInformation ? new IDESourcePositionFactory(this, line) : new SimplePositionFactory(this, line);
        this.list = list;
        this.lineBuffer = new StringBuilder();
    }

    public String getFilename() {
        return this.sourceName;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset <= 0 ? 0 : this.offset;
    }

    public ISourcePosition getPosition(ISourcePosition startPosition, boolean inclusive) {
        return this.positionFactory.getPosition(startPosition, inclusive);
    }

    public ISourcePosition getPosition() {
        return this.positionFactory.getPosition(null, false);
    }

    public ISourcePositionFactory getPositionFactory() {
        return this.positionFactory;
    }

    public static LexerSource getSource(String name, InputStream content, List<String> list, ParserConfiguration configuration) {
        return new InputStreamLexerSource(name, content, list, configuration.getLineNumber(), configuration.hasExtraPositionInformation());
    }

    protected void captureFeature(int c) {
        if (this.list != null) {
            if (c != -1) {
                this.lineBuffer.append((char)c);
            }
            if (c == 10 || c == -1 && this.lineBuffer.length() > 0) {
                this.list.add(this.lineBuffer.toString());
                this.lineBuffer.setLength(0);
            }
        }
    }

    public abstract boolean matchMarker(ByteList var1, boolean var2, boolean var3) throws IOException;

    public abstract int read() throws IOException;

    public abstract ByteList readUntil(char var1) throws IOException;

    public abstract ByteList readLineBytes() throws IOException;

    public abstract int skipUntil(int var1) throws IOException;

    public abstract void unread(int var1);

    public abstract void unreadMany(CharSequence var1);

    public abstract boolean peek(int var1) throws IOException;

    public abstract boolean lastWasBeginOfLine();

    public abstract boolean wasBeginOfLine();

    public abstract int chompReadAhead();

    public abstract boolean isANewLine();

    public abstract void setIsANewLine(boolean var1);

    public abstract void setOffset(int var1);
}

