/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class SClassNode
extends Node {
    private final Node receiverNode;
    private final StaticScope scope;
    private final Node bodyNode;

    public SClassNode(ISourcePosition position, Node recvNode, StaticScope scope, Node bodyNode) {
        super(position, NodeType.SCLASSNODE);
        assert (scope != null) : "scope is not null";
        assert (recvNode != null) : "receiverNode is not null";
        this.receiverNode = recvNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitSClassNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, aBlock);
        if (receiver instanceof RubyFixnum || receiver instanceof RubySymbol) {
            throw runtime.newTypeError("no virtual class for " + receiver.getMetaClass().getBaseName());
        }
        if (runtime.getSafeLevel() >= 4 && !receiver.isTaint()) {
            throw runtime.newSecurityError("Insecure: can't extend object.");
        }
        RubyClass singletonClass = receiver.getSingletonClass();
        this.scope.setModule(singletonClass);
        return ASTInterpreter.evalClassDefinitionBody(runtime, context, this.scope, this.bodyNode, singletonClass, self, aBlock);
    }
}

