/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import org.jruby.nb.CompatVersion;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArgsFile;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBignum;
import org.jruby.nb.RubyBinding;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyFile;
import org.jruby.nb.RubyFileTest;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyFloat;
import org.jruby.nb.RubyIO;
import org.jruby.nb.RubyInstanceConfig;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNameError;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyProc;
import org.jruby.nb.RubyProcess;
import org.jruby.nb.RubyString;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.RubySystemExit;
import org.jruby.nb.RubyThread;
import org.jruby.nb.anno.FrameField;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JRubyModule;
import org.jruby.nb.ast.util.ArgsUtil;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.exceptions.MainExitException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.internal.runtime.JumpTarget;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.load.IAutoloadMethod;
import org.jruby.nb.runtime.load.LoadService;
import org.jruby.nb.util.IdUtil;
import org.jruby.nb.util.ShellLauncher;
import org.jruby.nb.util.TypeConverter;

@JRubyModule(name={"Kernel"})
public class RubyKernel {
    public static final Class<?> IRUBY_OBJECT = IRubyObject.class;

    public static RubyModule createKernelModule(Ruby runtime) {
        RubyModule module = runtime.defineModule("Kernel");
        runtime.setKernel(module);
        module.defineAnnotatedMethods(RubyKernel.class);
        module.defineAnnotatedMethods(RubyObject.class);
        runtime.setRespondToMethod(module.searchMethod("respond_to?"));
        module.setFlag(2048, false);
        return module;
    }

    @JRubyMethod(name={"at_exit"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject at_exit(ThreadContext context, IRubyObject recv, Block block) {
        return context.getRuntime().pushExitBlock(context.getRuntime().newProc(Block.Type.PROC, block));
    }

    @JRubyMethod(name={"autoload?"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload_p(ThreadContext context, IRubyObject recv, IRubyObject symbol) {
        Ruby runtime = context.getRuntime();
        RubyModule module = recv instanceof RubyModule ? (RubyModule)recv : runtime.getObject();
        String name = module.getName() + "::" + symbol.asJavaString();
        IAutoloadMethod autoloadMethod = runtime.getLoadService().autoloadFor(name);
        if (autoloadMethod == null) {
            return runtime.getNil();
        }
        return runtime.newString(autoloadMethod.file());
    }

    @JRubyMethod(name={"autoload"}, required=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload(IRubyObject recv, IRubyObject symbol, final IRubyObject file) {
        Ruby runtime = recv.getRuntime();
        final LoadService loadService = runtime.getLoadService();
        String nonInternedName = symbol.asJavaString();
        if (!IdUtil.isValidConstantName(nonInternedName)) {
            throw runtime.newNameError("autoload must be constant name", nonInternedName);
        }
        RubyString fileString = file.convertToString();
        if (fileString.isEmpty()) {
            throw runtime.newArgumentError("empty file name");
        }
        final String baseName = symbol.asJavaString().intern();
        final RubyModule module = recv instanceof RubyModule ? (RubyModule)recv : runtime.getObject();
        String nm = module.getName() + "::" + baseName;
        IRubyObject existingValue = module.fastFetchConstant(baseName);
        if (existingValue != null && existingValue != RubyObject.UNDEF) {
            return runtime.getNil();
        }
        module.fastStoreConstant(baseName, RubyObject.UNDEF);
        loadService.addAutoload(nm, new IAutoloadMethod(){

            @Override
            public String file() {
                return file.toString();
            }

            @Override
            public IRubyObject load(Ruby runtime, String name) {
                boolean required = loadService.require(this.file());
                if (!required) {
                    return null;
                }
                return module.fastGetConstant(baseName);
            }
        });
        return runtime.getNil();
    }

    @JRubyMethod(name={"method_missing"}, rest=true, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject method_missing(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject[] exArgs;
        RubyClass exc;
        Ruby runtime = context.getRuntime();
        if (args.length == 0 || !(args[0] instanceof RubySymbol)) {
            throw runtime.newArgumentError("no id given");
        }
        Visibility lastVis = context.getLastVisibility();
        CallType lastCallType = context.getLastCallType();
        RubyNameError.RubyNameErrorMessage msg = new RubyNameError.RubyNameErrorMessage(runtime, recv, args[0], lastVis, lastCallType);
        if (lastCallType != CallType.VARIABLE) {
            exc = runtime.getNoMethodError();
            exArgs = new IRubyObject[]{msg, args[0], RubyArray.newArrayNoCopy(runtime, args, 1)};
        } else {
            exc = runtime.getNameError();
            exArgs = new IRubyObject[]{msg, args[0]};
        }
        throw new RaiseException((RubyException)exc.newInstance(context, exArgs, Block.NULL_BLOCK));
    }

    @JRubyMethod(name={"open"}, required=1, optional=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject open(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        String arg = args[0].convertToString().toString();
        Ruby runtime = context.getRuntime();
        if (arg.startsWith("|")) {
            String command = arg.substring(1);
            return RubyIO.popen(context, runtime.getIO(), new IRubyObject[]{runtime.newString(command)}, block);
        }
        return RubyFile.open(context, runtime.getFile(), args, block);
    }

    @JRubyMethod(name={"getc"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getc(ThreadContext context, IRubyObject recv) {
        context.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "getc is obsolete; use STDIN.getc instead", "getc", "STDIN.getc");
        IRubyObject defin = context.getRuntime().getGlobalVariables().get("$stdin");
        return defin.callMethod(context, "getc");
    }

    @JRubyMethod(name={"gets"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gets(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        return RubyArgsFile.gets(context, context.getRuntime().getGlobalVariables().get("$<"), args);
    }

    @JRubyMethod(name={"abort"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        if (args.length == 1) {
            context.getRuntime().getGlobalVariables().get("$stderr").callMethod(context, "puts", args[0]);
        }
        throw new MainExitException(1, true);
    }

    @JRubyMethod(name={"Array"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_array(ThreadContext context, IRubyObject recv, IRubyObject object) {
        IRubyObject value = object.checkArrayType();
        if (value.isNil()) {
            if (object.getMetaClass().searchMethod("to_a").getImplementationClass() != context.getRuntime().getKernel()) {
                value = object.callMethod(context, MethodIndex.TO_A, "to_a");
                if (!(value instanceof RubyArray)) {
                    throw context.getRuntime().newTypeError("`to_a' did not return Array");
                }
                return value;
            }
            return context.getRuntime().newArray(object);
        }
        return value;
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv) {
        return RuntimeHelpers.invoke(context, context.getRuntime().getComplex(), "convert");
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv, IRubyObject arg) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getComplex(), "convert", arg);
    }

    @JRubyMethod(name={"Complex"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_complex(ThreadContext context, IRubyObject recv, IRubyObject arg0, IRubyObject arg1) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getComplex(), "convert", arg0, arg1);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv) {
        return RuntimeHelpers.invoke(context, context.getRuntime().getRational(), "convert");
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv, IRubyObject arg) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getRational(), "convert", arg);
    }

    @JRubyMethod(name={"Rational"}, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static IRubyObject new_rational(ThreadContext context, IRubyObject recv, IRubyObject arg0, IRubyObject arg1) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getRational(), "convert", arg0, arg1);
    }

    @JRubyMethod(name={"Float"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_float(IRubyObject recv, IRubyObject object) {
        if (object instanceof RubyFixnum) {
            return RubyFloat.newFloat(object.getRuntime(), ((RubyFixnum)object).getDoubleValue());
        }
        if (object instanceof RubyFloat) {
            return object;
        }
        if (object instanceof RubyBignum) {
            return RubyFloat.newFloat(object.getRuntime(), RubyBignum.big2dbl((RubyBignum)object));
        }
        if (object instanceof RubyString) {
            if (((RubyString)object).getByteList().realSize == 0) {
                throw recv.getRuntime().newArgumentError("invalid value for Float(): " + object.inspect());
            }
            return RubyNumeric.str2fnum(recv.getRuntime(), (RubyString)object, true);
        }
        if (object.isNil()) {
            throw recv.getRuntime().newTypeError("can't convert nil into Float");
        }
        RubyFloat rFloat = (RubyFloat)TypeConverter.convertToType(object, recv.getRuntime().getFloat(), MethodIndex.TO_F, "to_f");
        if (Double.isNaN(rFloat.getDoubleValue())) {
            throw recv.getRuntime().newArgumentError("invalid value for Float()");
        }
        return rFloat;
    }

    @JRubyMethod(name={"Integer"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_integer(ThreadContext context, IRubyObject recv, IRubyObject object) {
        IRubyObject tmp;
        if (object instanceof RubyFloat) {
            double val = ((RubyFloat)object).getDoubleValue();
            if (val > 9.223372036854776E18 && val < -9.223372036854776E18) {
                return RubyNumeric.dbl2num(context.getRuntime(), ((RubyFloat)object).getDoubleValue());
            }
        } else {
            if (object instanceof RubyFixnum || object instanceof RubyBignum) {
                return object;
            }
            if (object instanceof RubyString) {
                return RubyNumeric.str2inum(context.getRuntime(), (RubyString)object, 0, true);
            }
        }
        if ((tmp = TypeConverter.convertToType(object, context.getRuntime().getInteger(), MethodIndex.TO_INT, "to_int", false)).isNil()) {
            return object.convertToInteger(MethodIndex.TO_I, "to_i");
        }
        return tmp;
    }

    @JRubyMethod(name={"String"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_string(ThreadContext context, IRubyObject recv, IRubyObject object) {
        return TypeConverter.convertToType(object, context.getRuntime().getString(), MethodIndex.TO_S, "to_s");
    }

    @JRubyMethod(name={"p"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject p(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = context.getRuntime();
        IRubyObject defout = runtime.getGlobalVariables().get("$>");
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            defout.callMethod(context, "write", RubyObject.inspect(context, args[i]));
            defout.callMethod(context, "write", runtime.newString("\n"));
        }
        if (defout instanceof RubyFile) {
            ((RubyFile)defout).flush();
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject putc(ThreadContext context, IRubyObject recv, IRubyObject ch) {
        IRubyObject defout = context.getRuntime().getGlobalVariables().get("$>");
        return defout.callMethod(context, "putc", ch);
    }

    @JRubyMethod(name={"puts"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = context.getRuntime().getGlobalVariables().get("$>");
        defout.callMethod(context, "puts", args);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"print"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject print(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = context.getRuntime().getGlobalVariables().get("$>");
        defout.callMethod(context, "print", args);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"printf"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject printf(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        if (args.length != 0) {
            IRubyObject defout = context.getRuntime().getGlobalVariables().get("$>");
            if (!(args[0] instanceof RubyString)) {
                defout = args[0];
                args = ArgsUtil.popArray(args);
            }
            defout.callMethod(context, "write", RubyKernel.sprintf(recv, args));
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"readline"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readline(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        IRubyObject line = RubyKernel.gets(context, recv, args);
        if (line.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray readlines(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        return RubyArgsFile.readlines(context, context.getRuntime().getGlobalVariables().get("$<"), args);
    }

    private static RubyString getLastlineString(ThreadContext context, Ruby runtime) {
        IRubyObject line = context.getPreviousFrame().getLastLine();
        if (line.isNil()) {
            throw runtime.newTypeError("$_ value need to be String (nil given).");
        }
        if (!(line instanceof RubyString)) {
            throw runtime.newTypeError("$_ value need to be String (" + line.getMetaClass().getName() + " given).");
        }
        return (RubyString)line;
    }

    public static IRubyObject sub_bang(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).sub_bang(context, args, block);
    }

    @JRubyMethod(name={"sub!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE})
    public static IRubyObject sub_bang(ThreadContext context, IRubyObject recv, IRubyObject arg0, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).sub_bang(context, arg0, block);
    }

    @JRubyMethod(name={"sub!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE})
    public static IRubyObject sub_bang(ThreadContext context, IRubyObject recv, IRubyObject arg0, IRubyObject arg1, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).sub_bang(context, arg0, arg1, block);
    }

    public static IRubyObject sub(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.sub_bang(context, args, block).isNil()) {
            context.getPreviousFrame().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"sub"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject sub(ThreadContext context, IRubyObject recv, IRubyObject arg0, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.sub_bang(context, arg0, block).isNil()) {
            context.getPreviousFrame().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"sub"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject sub(ThreadContext context, IRubyObject recv, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.sub_bang(context, arg0, arg1, block).isNil()) {
            context.getPreviousFrame().setLastLine(str);
        }
        return str;
    }

    public static IRubyObject gsub_bang(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).gsub_bang(context, args, block);
    }

    @JRubyMethod(name={"gsub!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject gsub_bang(ThreadContext context, IRubyObject recv, IRubyObject arg0, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).gsub_bang(context, arg0, block);
    }

    @JRubyMethod(name={"gsub!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject gsub_bang(ThreadContext context, IRubyObject recv, IRubyObject arg0, IRubyObject arg1, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).gsub_bang(context, arg0, arg1, block);
    }

    public static IRubyObject gsub(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.gsub_bang(context, args, block).isNil()) {
            context.getPreviousFrame().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"gsub"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject gsub(ThreadContext context, IRubyObject recv, IRubyObject arg0, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.gsub_bang(context, arg0, block).isNil()) {
            context.getPreviousFrame().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"gsub"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject gsub(ThreadContext context, IRubyObject recv, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(context, context.getRuntime()).dup();
        if (!str.gsub_bang(context, arg0, arg1, block).isNil()) {
            context.getPreviousFrame().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"chop!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject chop_bang(ThreadContext context, IRubyObject recv, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).chop_bang();
    }

    @JRubyMethod(name={"chop"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject chop(ThreadContext context, IRubyObject recv, Block block) {
        RubyString str = RubyKernel.getLastlineString(context, context.getRuntime());
        if (str.getByteList().realSize > 0) {
            str = (RubyString)str.dup();
            str.chop_bang();
            context.getPreviousFrame().setLastLine(str);
        }
        return str;
    }

    public static IRubyObject chomp_bang(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).chomp_bang(args);
    }

    @JRubyMethod(name={"chomp!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject chomp_bang(ThreadContext context, IRubyObject recv) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).chomp_bang();
    }

    @JRubyMethod(name={"chomp!"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject chomp_bang(ThreadContext context, IRubyObject recv, IRubyObject arg0) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).chomp_bang(arg0);
    }

    public static IRubyObject chomp(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString str = RubyKernel.getLastlineString(context, context.getRuntime());
        RubyString dup = (RubyString)str.dup();
        if (dup.chomp_bang(args).isNil()) {
            return str;
        }
        context.getPreviousFrame().setLastLine(dup);
        return dup;
    }

    @JRubyMethod(name={"chomp"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject chomp(ThreadContext context, IRubyObject recv) {
        RubyString str = RubyKernel.getLastlineString(context, context.getRuntime());
        RubyString dup = (RubyString)str.dup();
        if (dup.chomp_bang().isNil()) {
            return str;
        }
        context.getPreviousFrame().setLastLine(dup);
        return dup;
    }

    @JRubyMethod(name={"chomp"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE})
    public static IRubyObject chomp(ThreadContext context, IRubyObject recv, IRubyObject arg0) {
        RubyString str = RubyKernel.getLastlineString(context, context.getRuntime());
        RubyString dup = (RubyString)str.dup();
        if (dup.chomp_bang(arg0).isNil()) {
            return str;
        }
        context.getPreviousFrame().setLastLine(dup);
        return dup;
    }

    public static IRubyObject split(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).split(context, args);
    }

    @JRubyMethod(name={"split"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE, FrameField.BACKREF})
    public static IRubyObject split(ThreadContext context, IRubyObject recv) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).split(context);
    }

    @JRubyMethod(name={"split"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE, FrameField.BACKREF})
    public static IRubyObject split(ThreadContext context, IRubyObject recv, IRubyObject arg0) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).split(context, arg0);
    }

    @JRubyMethod(name={"split"}, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE}, writes={FrameField.LASTLINE, FrameField.BACKREF})
    public static IRubyObject split(ThreadContext context, IRubyObject recv, IRubyObject arg0, IRubyObject arg1) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).split(context, arg0, arg1);
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE, reads={FrameField.LASTLINE, FrameField.BACKREF}, writes={FrameField.LASTLINE, FrameField.BACKREF})
    public static IRubyObject scan(ThreadContext context, IRubyObject recv, IRubyObject pattern, Block block) {
        return RubyKernel.getLastlineString(context, context.getRuntime()).scan(context, pattern, block);
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject select(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        return RubyIO.select_static(context, context.getRuntime(), args);
    }

    @JRubyMethod(name={"sleep"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sleep(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        long loopStartTime;
        long milliseconds;
        if (args.length == 0) {
            milliseconds = 0L;
        } else {
            if (!(args[0] instanceof RubyNumeric)) {
                throw context.getRuntime().newTypeError("can't convert " + args[0].getMetaClass().getName() + "into time interval");
            }
            milliseconds = (long)(args[0].convertToFloat().getDoubleValue() * 1000.0);
            if (milliseconds < 0L) {
                throw context.getRuntime().newArgumentError("time interval must be positive");
            }
            if (milliseconds == 0L) {
                return context.getRuntime().newFixnum(0);
            }
        }
        long startTime = System.currentTimeMillis();
        RubyThread rubyThread = context.getThread();
        do {
            loopStartTime = System.currentTimeMillis();
            try {
                rubyThread.sleep(milliseconds);
            }
            catch (InterruptedException iExcptn) {
                // empty catch block
            }
        } while ((milliseconds -= System.currentTimeMillis() - loopStartTime) > 0L);
        return context.getRuntime().newFixnum(Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    @JRubyMethod(name={"exit"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(IRubyObject recv, IRubyObject[] args) {
        RubyKernel.exit(recv.getRuntime(), args, false);
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"exit!"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(IRubyObject recv, IRubyObject[] args) {
        RubyKernel.exit(recv.getRuntime(), args, true);
        return recv.getRuntime().getNil();
    }

    private static void exit(Ruby runtime, IRubyObject[] args, boolean hard) {
        runtime.secure(4);
        int status = 1;
        if (args.length > 0) {
            RubyObject argument = (RubyObject)args[0];
            if (argument instanceof RubyFixnum) {
                status = RubyNumeric.fix2int(argument);
            } else {
                int n = status = argument.isFalse() ? 1 : 0;
            }
        }
        if (hard) {
            throw new MainExitException(status, true);
        }
        throw runtime.newSystemExit(status);
    }

    @JRubyMethod(name={"global_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray global_variables(ThreadContext context, IRubyObject recv) {
        Ruby runtime = context.getRuntime();
        RubyArray globalVariables = runtime.newArray();
        for (String globalVariableName : runtime.getGlobalVariables().getNames()) {
            globalVariables.append(runtime.newString(globalVariableName));
        }
        return globalVariables;
    }

    @JRubyMethod(name={"local_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray local_variables(ThreadContext context, IRubyObject recv) {
        Ruby runtime = context.getRuntime();
        RubyArray localVariables = runtime.newArray();
        for (String name : context.getCurrentScope().getAllNamesInScope()) {
            if (!IdUtil.isLocal(name)) continue;
            localVariables.append(runtime.newString(name));
        }
        return localVariables;
    }

    @JRubyMethod(name={"binding"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBinding binding(ThreadContext context, IRubyObject recv, Block block) {
        return RubyBinding.newBinding(context.getRuntime());
    }

    @JRubyMethod(name={"block_given?", "iterator?"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBoolean block_given_p(ThreadContext context, IRubyObject recv, Block block) {
        return context.getRuntime().newBoolean(context.getPreviousFrame().getBlock().isGiven());
    }

    @Deprecated
    public static IRubyObject sprintf(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.sprintf(recv.getRuntime().getCurrentContext(), recv, args);
    }

    @JRubyMethod(name={"sprintf", "format"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sprintf(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            throw context.getRuntime().newArgumentError("sprintf must have at least one argument");
        }
        RubyString str = RubyString.stringValue(args[0]);
        RubyArray newArgs = context.getRuntime().newArrayNoCopy(args);
        newArgs.shift();
        return str.op_format(context, newArgs);
    }

    @JRubyMethod(name={"raise", "fail"}, optional=3, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject raise(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject exception;
        Ruby runtime = context.getRuntime();
        if (args.length == 0) {
            IRubyObject lastException = runtime.getGlobalVariables().get("$!");
            if (lastException.isNil()) {
                throw new RaiseException(runtime, runtime.getRuntimeError(), "", false);
            }
            throw new RaiseException((RubyException)lastException);
        }
        if (args.length == 1) {
            if (args[0] instanceof RubyString) {
                throw new RaiseException((RubyException)runtime.getRuntimeError().newInstance(context, args, block));
            }
            if (!args[0].respondsTo("exception")) {
                throw runtime.newTypeError("exception class/object expected");
            }
            exception = args[0].callMethod(context, "exception");
        } else {
            if (!args[0].respondsTo("exception")) {
                throw runtime.newTypeError("exception class/object expected");
            }
            exception = args[0].callMethod(context, "exception", args[1]);
        }
        if (!runtime.fastGetClass("Exception").isInstance(exception)) {
            throw runtime.newTypeError("exception object expected");
        }
        if (args.length == 3) {
            ((RubyException)exception).set_backtrace(args[2]);
        }
        if (runtime.getDebug().isTrue()) {
            RubyKernel.printExceptionSummary(context, runtime, (RubyException)exception);
        }
        throw new RaiseException((RubyException)exception);
    }

    private static void printExceptionSummary(ThreadContext context, Ruby runtime, RubyException rEx) {
        Frame currentFrame = context.getCurrentFrame();
        String msg = String.format("Exception `%s' at %s:%s - %s\n", rEx.getMetaClass(), currentFrame.getFile(), currentFrame.getLine() + 1, rEx.to_s());
        IRubyObject errorStream = runtime.getGlobalVariables().get("$stderr");
        errorStream.callMethod(context, "write", runtime.newString(msg));
    }

    @JRubyMethod(name={"require"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject require(IRubyObject recv, IRubyObject name, Block block) {
        Ruby runtime = recv.getRuntime();
        if (runtime.getLoadService().require(name.convertToString().toString())) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod(name={"load"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        RubyString file = args[0].convertToString();
        boolean wrap = args.length == 2 ? args[1].isTrue() : false;
        runtime.getLoadService().load(file.getByteList().toString(), wrap);
        return runtime.getTrue();
    }

    @JRubyMethod(name={"eval"}, required=1, optional=3, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject eval(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject scope;
        Ruby runtime = context.getRuntime();
        RubyString src = args[0].convertToString();
        runtime.checkSafeString(src);
        IRubyObject iRubyObject = scope = args.length > 1 && !args[1].isNil() ? args[1] : null;
        String file = args.length > 2 ? args[2].convertToString().toString() : (scope == null ? "(eval)" : null);
        int line = args.length > 3 ? (int)args[3].convertToInteger().getLongValue() : (scope == null ? 0 : -1);
        if (scope == null) {
            scope = RubyBinding.newBindingForEval(context);
        }
        return ASTInterpreter.evalWithBinding(context, src, scope, file, line);
    }

    @JRubyMethod(name={"callcc"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject callcc(ThreadContext context, IRubyObject recv, Block block) {
        Ruby runtime = context.getRuntime();
        runtime.getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "Kernel#callcc: Continuations are not implemented in JRuby and will not work", "Kernel#callcc");
        IRubyObject cc = runtime.getContinuation().callMethod(context, "new");
        cc.dataWrapStruct(block);
        return block.yield(context, cc);
    }

    @JRubyMethod(name={"caller"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject caller(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        int level;
        int n = level = args.length > 0 ? RubyNumeric.fix2int(args[0]) : 1;
        if (level < 0) {
            throw context.getRuntime().newArgumentError("negative level(" + level + ')');
        }
        return context.createCallerBacktrace(context.getRuntime(), level);
    }

    @JRubyMethod(name={"catch"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbCatch(ThreadContext context, IRubyObject recv, IRubyObject tag, Block block) {
        CatchTarget target = new CatchTarget(tag.asJavaString());
        try {
            context.pushCatch(target);
            IRubyObject iRubyObject = block.yield(context, tag);
            return iRubyObject;
        }
        catch (JumpException.ThrowJump tj) {
            if (tj.getTarget() == target) {
                IRubyObject iRubyObject = (IRubyObject)tj.getValue();
                return iRubyObject;
            }
            throw tj;
        }
        finally {
            context.popCatch();
        }
    }

    @JRubyMethod(name={"throw"}, required=1, frame=true, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbThrow(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = context.getRuntime();
        String tag = args[0].asJavaString();
        CatchTarget[] catches = context.getActiveCatches();
        String message = "uncaught throw `" + tag + "'";
        for (int i = catches.length - 1; i >= 0; --i) {
            if (!tag.equals(catches[i].getTag())) continue;
            throw new JumpException.ThrowJump(catches[i], args.length > 1 ? args[1] : runtime.getNil());
        }
        RubyThread currentThread = context.getThread();
        if (currentThread == runtime.getThreadService().getMainThread()) {
            throw runtime.newNameError(message, tag);
        }
        throw runtime.newThreadError(message + " in thread 0x" + Integer.toHexString(RubyInteger.fix2int(currentThread.id())));
    }

    @JRubyMethod(name={"trap"}, required=1, frame=true, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trap(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        context.getRuntime().getLoadService().require("jsignal");
        return RuntimeHelpers.invoke(context, recv, "__jtrap", args, block);
    }

    @JRubyMethod(name={"warn"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject warn(ThreadContext context, IRubyObject recv, IRubyObject message) {
        Ruby runtime = context.getRuntime();
        if (!runtime.getVerbose().isNil()) {
            IRubyObject out = runtime.getGlobalVariables().get("$stderr");
            RuntimeHelpers.invoke(context, out, "puts", message);
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"set_trace_func"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject set_trace_func(ThreadContext context, IRubyObject recv, IRubyObject trace_func, Block block) {
        if (trace_func.isNil()) {
            context.getRuntime().setTraceFunction(null);
        } else {
            if (!(trace_func instanceof RubyProc)) {
                throw context.getRuntime().newTypeError("trace_func needs to be Proc.");
            }
            context.getRuntime().setTraceFunction((RubyProc)trace_func);
        }
        return trace_func;
    }

    @JRubyMethod(name={"trace_var"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trace_var(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        String var;
        if (args.length == 0) {
            throw context.getRuntime().newArgumentError(0, 1);
        }
        RubyProc proc = null;
        String string = var = args.length > 1 ? args[0].toString() : null;
        if (var.charAt(0) != '$') {
            return context.getRuntime().getNil();
        }
        if (args.length == 1) {
            proc = RubyProc.newProc(context.getRuntime(), block, Block.Type.PROC);
        }
        if (args.length == 2) {
            proc = (RubyProc)TypeConverter.convertToType(args[1], context.getRuntime().getProc(), 0, "to_proc", true);
        }
        context.getRuntime().getGlobalVariables().setTraceVar(var, proc);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"untrace_var"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject untrace_var(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        String var;
        if (args.length == 0) {
            throw context.getRuntime().newArgumentError(0, 1);
        }
        String string = var = args.length >= 1 ? args[0].toString() : null;
        if (var.charAt(0) != '$') {
            return context.getRuntime().getNil();
        }
        if (args.length > 1) {
            ArrayList<IRubyObject> success = new ArrayList<IRubyObject>();
            for (int i = 1; i < args.length; ++i) {
                if (!context.getRuntime().getGlobalVariables().untraceVar(var, args[i])) continue;
                success.add(args[i]);
            }
            return RubyArray.newArray(context.getRuntime(), success);
        }
        context.getRuntime().getGlobalVariables().untraceVar(var);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_added"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_added(ThreadContext context, IRubyObject recv, IRubyObject symbolId, Block block) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_removed"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_removed(ThreadContext context, IRubyObject recv, IRubyObject symbolId, Block block) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_undefined"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_undefined(ThreadContext context, IRubyObject recv, IRubyObject symbolId, Block block) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"proc", "lambda"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyProc proc(ThreadContext context, IRubyObject recv, Block block) {
        return context.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @Deprecated
    public static RubyProc proc(IRubyObject recv, Block block) {
        return recv.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @JRubyMethod(name={"lambda"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyProc lambda(ThreadContext context, IRubyObject recv, Block block) {
        return context.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @JRubyMethod(name={"proc"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyProc proc_1_9(ThreadContext context, IRubyObject recv, Block block) {
        return context.getRuntime().newProc(Block.Type.PROC, block);
    }

    @JRubyMethod(name={"loop"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject loop(ThreadContext context, IRubyObject recv, Block block) {
        while (true) {
            block.yield(context, context.getRuntime().getNil());
            context.pollThreadEvents();
        }
    }

    @JRubyMethod(name={"test"}, required=2, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject test(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            throw context.getRuntime().newArgumentError("wrong number of arguments");
        }
        int cmd = args[0] instanceof RubyFixnum ? (int)((RubyFixnum)args[0]).getLongValue() : (args[0] instanceof RubyString && ((RubyString)args[0]).getByteList().length() > 0 ? (int)((RubyString)args[0]).getByteList().charAt(0) : (int)args[0].convertToInteger().getLongValue());
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 71: 
            case 77: 
            case 79: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 119: 
            case 120: 
            case 122: {
                break;
            }
            default: {
                throw context.getRuntime().newArgumentError("unknown command ?" + (char)cmd);
            }
        }
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: {
                if (args.length == 3) break;
                throw context.getRuntime().newArgumentError(args.length, 3);
            }
            default: {
                if (args.length == 2) break;
                throw context.getRuntime().newArgumentError(args.length, 2);
            }
        }
        switch (cmd) {
            case 65: {
                return context.getRuntime().newFileStat(args[1].convertToString().toString(), false).atime();
            }
            case 98: {
                return RubyFileTest.blockdev_p(recv, args[1]);
            }
            case 99: {
                return RubyFileTest.chardev_p(recv, args[1]);
            }
            case 67: {
                return context.getRuntime().newFileStat(args[1].convertToString().toString(), false).ctime();
            }
            case 100: {
                return RubyFileTest.directory_p(recv, args[1]);
            }
            case 101: {
                return RubyFileTest.exist_p(recv, args[1]);
            }
            case 102: {
                return RubyFileTest.file_p(recv, args[1]);
            }
            case 103: {
                return RubyFileTest.setgid_p(recv, args[1]);
            }
            case 71: {
                return RubyFileTest.grpowned_p(recv, args[1]);
            }
            case 107: {
                return RubyFileTest.sticky_p(recv, args[1]);
            }
            case 77: {
                return context.getRuntime().newFileStat(args[1].convertToString().toString(), false).mtime();
            }
            case 108: {
                return RubyFileTest.symlink_p(recv, args[1]);
            }
            case 111: {
                return RubyFileTest.owned_p(recv, args[1]);
            }
            case 79: {
                return RubyFileTest.rowned_p(recv, args[1]);
            }
            case 112: {
                return RubyFileTest.pipe_p(recv, args[1]);
            }
            case 114: {
                return RubyFileTest.readable_p(recv, args[1]);
            }
            case 82: {
                return RubyFileTest.readable_p(recv, args[1]);
            }
            case 115: {
                return RubyFileTest.size_p(recv, args[1]);
            }
            case 83: {
                return RubyFileTest.socket_p(recv, args[1]);
            }
            case 117: {
                return RubyFileTest.setuid_p(recv, args[1]);
            }
            case 119: {
                return RubyFileTest.writable_p(recv, args[1]);
            }
            case 87: {
                return RubyFileTest.writable_p(recv, args[1]);
            }
            case 120: {
                return RubyFileTest.executable_p(recv, args[1]);
            }
            case 88: {
                return RubyFileTest.executable_real_p(recv, args[1]);
            }
            case 122: {
                return RubyFileTest.zero_p(recv, args[1]);
            }
            case 61: {
                return context.getRuntime().newFileStat(args[1].convertToString().toString(), false).mtimeEquals(args[2]);
            }
            case 60: {
                return context.getRuntime().newFileStat(args[1].convertToString().toString(), false).mtimeLessThan(args[2]);
            }
            case 62: {
                return context.getRuntime().newFileStat(args[1].convertToString().toString(), false).mtimeGreaterThan(args[2]);
            }
            case 45: {
                return RubyFileTest.identical_p(recv, args[1], args[2]);
            }
        }
        throw new InternalError("unreachable code reached!");
    }

    @JRubyMethod(name={"`"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject backquote(ThreadContext context, IRubyObject recv, IRubyObject aString) {
        Ruby runtime = context.getRuntime();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        RubyString string = aString.convertToString();
        int resultCode = ShellLauncher.runAndWait(runtime, new IRubyObject[]{string}, output);
        runtime.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, resultCode));
        return RubyString.newString(runtime, output.toByteArray());
    }

    @JRubyMethod(name={"srand"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyInteger srand(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = context.getRuntime();
        long oldRandomSeed = runtime.getRandomSeed();
        if (args.length > 0) {
            RubyInteger integerSeed = args[0].convertToInteger(MethodIndex.TO_INT, "to_int");
            runtime.setRandomSeed(integerSeed.getLongValue());
        } else {
            runtime.setRandomSeed(System.currentTimeMillis() ^ (long)recv.hashCode() ^ runtime.incrementRandomSeedSequence() ^ (long)runtime.getRandom().nextInt(Math.max(1, Math.abs((int)runtime.getRandomSeed()))));
        }
        runtime.getRandom().setSeed(runtime.getRandomSeed());
        return runtime.newFixnum(oldRandomSeed);
    }

    @JRubyMethod(name={"rand"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyNumeric rand(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        long ceil;
        Ruby runtime = context.getRuntime();
        if (args.length == 0) {
            ceil = 0L;
        } else if (args.length == 1) {
            if (args[0] instanceof RubyBignum) {
                byte[] bigCeilBytes = ((RubyBignum)args[0]).getValue().toByteArray();
                BigInteger bigCeil = new BigInteger(bigCeilBytes).abs();
                byte[] randBytes = new byte[bigCeilBytes.length];
                runtime.getRandom().nextBytes(randBytes);
                BigInteger result = new BigInteger(randBytes).abs().mod(bigCeil);
                return new RubyBignum(runtime, result);
            }
            RubyInteger integerCeil = (RubyInteger)RubyKernel.new_integer(context, recv, args[0]);
            ceil = Math.abs(integerCeil.getLongValue());
        } else {
            throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for 1)");
        }
        if (ceil == 0L) {
            return RubyFloat.newFloat(runtime, runtime.getRandom().nextDouble());
        }
        if (ceil > Integer.MAX_VALUE) {
            return runtime.newFixnum(Math.abs(runtime.getRandom().nextLong()) % ceil);
        }
        return runtime.newFixnum(runtime.getRandom().nextInt((int)ceil));
    }

    @JRubyMethod(name={"syscall"}, required=1, optional=9, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject syscall(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        throw context.getRuntime().newNotImplementedError("Kernel#syscall is not implemented in JRuby");
    }

    @JRubyMethod(name={"system"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBoolean system(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        int resultCode;
        Ruby runtime = context.getRuntime();
        try {
            resultCode = ShellLauncher.runAndWait(runtime, args);
        }
        catch (Exception e) {
            resultCode = 127;
        }
        runtime.getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, resultCode));
        return runtime.newBoolean(resultCode == 0);
    }

    @JRubyMethod(name={"exec"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exec(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        int resultCode;
        Ruby runtime = context.getRuntime();
        try {
            resultCode = ShellLauncher.execAndWait(runtime, args);
        }
        catch (Exception e) {
            throw runtime.newErrnoENOENTError("cannot execute");
        }
        return RubyKernel.exit(recv, new IRubyObject[]{runtime.newFixnum(resultCode)});
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject fork(ThreadContext context, IRubyObject recv, Block block) {
        Ruby runtime = context.getRuntime();
        if (!RubyInstanceConfig.FORK_ENABLED) {
            throw runtime.newNotImplementedError("fork is unsafe and disabled by default on JRuby");
        }
        if (block.isGiven()) {
            int pid = runtime.getPosix().fork();
            if (pid == 0) {
                try {
                    block.yield(context, runtime.getNil());
                }
                catch (RaiseException re) {
                    if (re.getException() instanceof RubySystemExit) {
                        throw re;
                    }
                    return RubyKernel.exit_bang(recv, new IRubyObject[]{RubyFixnum.minus_one(runtime)});
                }
                catch (Throwable t) {
                    return RubyKernel.exit_bang(recv, new IRubyObject[]{RubyFixnum.minus_one(runtime)});
                }
                return RubyKernel.exit_bang(recv, new IRubyObject[]{RubyFixnum.zero(runtime)});
            }
            return runtime.newFixnum(pid);
        }
        int result = runtime.getPosix().fork();
        if (result == -1) {
            return runtime.getNil();
        }
        return runtime.newFixnum(result);
    }

    @JRubyMethod(frame=true, module=true)
    public static IRubyObject tap(ThreadContext context, IRubyObject recv, Block block) {
        block.yield(context, recv);
        return recv;
    }

    public static class CatchTarget
    implements JumpTarget {
        private final String tag;

        public CatchTarget(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

