/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import org.netbeans.modules.kenai.UserData;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiUser;

public final class KenaiProjectMember {
    private final KenaiUser user;
    private Role role;

    KenaiProjectMember(Kenai kenai, UserData userData) {
        if ("registered".equals(userData.role)) {
            this.role = Role.OBSERVER;
        } else {
            try {
                this.role = Role.valueOf(userData.role.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                this.role = Role.UNKNOWN;
            }
        }
        this.user = KenaiUser.get(kenai, userData);
    }

    public String getUserName() {
        return this.user.data.user_name;
    }

    public KenaiUser getKenaiUser() {
        return this.user;
    }

    public Role getRole() {
        return this.role;
    }

    public static enum Role {
        ADMIN,
        DEVELOPER,
        CONTENT,
        OBSERVER,
        TESTER,
        UNKNOWN;


        public String toString() {
            if (this == OBSERVER) {
                return "registered";
            }
            return super.toString().toLowerCase();
        }
    }
}

