/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.codeviation.commons.utils.StreamUtil;

public class ZipUtil {
    private static final int BUFFER_SIZE = 2048;

    public static void zip(File file, OutputStream os) throws IOException {
        ZipUtil.zip(file, os, true);
    }

    public static void zip(File file, OutputStream os, boolean addRoot) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        if (!addRoot && file.isDirectory()) {
            for (File f : file.listFiles()) {
                ZipUtil.add("", f, zos);
            }
        } else {
            ZipUtil.add("", file, zos);
        }
        zos.flush();
        zos.close();
    }

    public static void unzip(InputStream is, File target) throws IOException {
        ZipInputStream zis = new ZipInputStream(is);
        byte[] buffer = new byte[2048];
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            System.out.println("" + ze.getName() + ":" + " " + ze.getSize());
            if (ze.isDirectory()) {
                new File(target, ze.getName()).mkdirs();
            } else {
                File f = new File(target, ze.getName());
                if (!f.getParentFile().isDirectory()) {
                    f.getParentFile().mkdirs();
                }
                f.createNewFile();
                FileOutputStream os = new FileOutputStream(f);
                int read = -1;
                do {
                    if ((read = zis.read(buffer)) == -1) continue;
                    ((OutputStream)os).write(buffer, 0, read);
                    os.flush();
                } while (read != -1);
                ((OutputStream)os).close();
            }
            zis.closeEntry();
            ze = zis.getNextEntry();
        }
    }

    private static void add(String path, File file, ZipOutputStream zip) throws IOException {
        path = path + "/" + file.getName();
        if (file.isFile()) {
            zip.putNextEntry(new ZipEntry(path));
            StreamUtil.copy(new FileInputStream(file), zip);
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                zip.putNextEntry(new ZipEntry(path + "/"));
            } else {
                for (File f : files) {
                    ZipUtil.add(path, f, zip);
                }
            }
        }
    }
}

