/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.navigation;

import javax.swing.JComponent;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.navigation.ClassMemberNavigatorSourceFactory;
import org.netbeans.modules.csl.navigation.ClassMemberPanelUI;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ClassMemberPanel
implements NavigatorPanel {
    private ClassMemberPanelUI component;
    private static ClassMemberPanel INSTANCE;

    public void panelActivated(Lookup context) {
        assert (context != null);
        INSTANCE = this;
        FileObject fileObject = (FileObject)context.lookup(FileObject.class);
        Language language = null;
        if (fileObject != null) {
            language = LanguageRegistry.getInstance().getLanguageByMimeType(fileObject.getMIMEType());
        }
        ClassMemberNavigatorSourceFactory.getInstance().setLookup(context, this.getClassMemberPanelUI(language));
        this.getClassMemberPanelUI().showWaitNode();
    }

    public void panelDeactivated() {
        this.getClassMemberPanelUI().showWaitNode();
        ClassMemberNavigatorSourceFactory.getInstance().setLookup(Lookup.EMPTY, null);
        INSTANCE = null;
    }

    public Lookup getLookup() {
        return this.getClassMemberPanelUI().getLookup();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ClassMemberPanel.class, (String)"LBL_members");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(ClassMemberPanel.class, (String)"HINT_members");
    }

    public JComponent getComponent() {
        return this.getClassMemberPanelUI();
    }

    public void selectElement(ParserResult info, int offset) {
        this.getClassMemberPanelUI().selectElementNode(info, offset);
    }

    private synchronized ClassMemberPanelUI getClassMemberPanelUI(Language language) {
        if (this.component == null) {
            this.component = new ClassMemberPanelUI(language);
        }
        return this.component;
    }

    private ClassMemberPanelUI getClassMemberPanelUI() {
        return this.getClassMemberPanelUI(null);
    }

    public static ClassMemberPanel getInstance() {
        return INSTANCE;
    }
}

