/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.openide.cookies.LineCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class Utils {
    public static String stripPackageName(String string) {
        int n = string.indexOf("<");
        int n2 = 0;
        if (n > 0) {
            String string2 = string.substring(0, n);
            n2 = string2.lastIndexOf(".");
        } else {
            n2 = string.lastIndexOf(".");
        }
        if (n2 > 0) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    public static Collection<String> sortKeys(Collection<String> collection) {
        TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareTo(string2);
            }
        });
        treeSet.addAll(collection);
        return treeSet;
    }

    public static void showMethod(FileObject fileObject, String string) {
        try {
            LineCookie lineCookie;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
            if ((lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class)) != null) {
                final long[] lArray = JavaSourceHelper.getPosition(javaSource, string);
                final Line line = lineCookie.getLineSet().getOriginal((int)lArray[0]);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.NONE, (int)lArray[1]);
                    }
                });
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public static Method getValueOfMethod(Class clazz) {
        try {
            Method method = clazz.getDeclaredMethod("valueOf", String.class);
            if (method == null || !Modifier.isStatic(method.getModifiers())) {
                return null;
            }
            return method;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Constructor getConstructorWithStringParam(Class clazz) {
        try {
            return clazz.getConstructor(String.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Project[] getProjectsFromLookup(Lookup lookup) {
        HashSet<Project> hashSet = new HashSet<Project>();
        for (Project project : lookup.lookupAll(Project.class)) {
            hashSet.add(project);
        }
        for (Project project : lookup.lookupAll(DataObject.class)) {
            FileObject fileObject = project.getPrimaryFile();
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project2 == null) continue;
            hashSet.add(project2);
        }
        Project[] projectArray = hashSet.toArray(new Project[hashSet.size()]);
        return projectArray;
    }

    public static FileObject findBuildXml(Project project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }
}

