/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.bind.JAXBException;
import org.netbeans.modules.websvc.rest.client.JerseyClientWizardPanel;
import org.netbeans.modules.websvc.rest.client.RESTExplorerPanel;
import org.netbeans.modules.websvc.rest.client.SaasExplorerPanel;
import org.netbeans.modules.websvc.rest.client.Security;
import org.netbeans.modules.websvc.rest.client.Wadl2JavaHelper;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasMetadata;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class RESTResourcesPanel
extends JPanel {
    private Object[] cbDefault = new Object[]{Security.Authentication.NONE, Security.Authentication.BASIC};
    boolean securityDefault = true;
    private Node resourceNode;
    private DialogDescriptor descriptor;
    private boolean nameChangedByUser = false;
    private JerseyClientWizardPanel wizardPanel;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public RESTResourcesPanel(JerseyClientWizardPanel jerseyClientWizardPanel) {
        this.init();
        this.wizardPanel = jerseyClientWizardPanel;
        this.jLabel2.setVisible(false);
        this.jTextField2.setVisible(false);
    }

    public RESTResourcesPanel() {
        this.init();
        this.jTextField2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RESTResourcesPanel.this.nameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RESTResourcesPanel.this.nameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RESTResourcesPanel.this.nameChanged();
            }
        });
    }

    private void init() {
        this.initComponents();
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RESTResourcesPanel.this.resourceChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RESTResourcesPanel.this.resourceChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RESTResourcesPanel.this.resourceChanged();
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(this.cbDefault));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jTextField2 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RESTResourcesPanel.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.jLabel2.setLabelFor(this.jTextField2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jLabel2.text"));
        this.jLabel3.setLabelFor(this.jTextField1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jLabel3.text"));
        this.jTextField1.setEditable(false);
        this.jLabel4.setLabelFor(this.jComboBox1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jLabel4.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jCheckBox1.text"));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton1, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jRadioButton1.text"));
        this.jRadioButton1.setToolTipText(NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jRadioButton1_hint"));
        this.jPanel1.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
        Mnemonics.setLocalizedText((AbstractButton)this.jRadioButton2, (String)NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jRadioButton2.text"));
        this.jRadioButton2.setToolTipText(NbBundle.getMessage(RESTResourcesPanel.class, (String)"RESTResourcesPanel.jRadioButton2_hint"));
        this.jPanel1.add(this.jRadioButton2);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.jLabel3).addComponent(this.jTextField1, -1, 358, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, 0, 198, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel2).addGap(28, 28, 28).addComponent(this.jTextField2, -1, 249, Short.MAX_VALUE)).addComponent(this.jLabel1)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 33, -2)).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3, -2, 17, -2).addGap(4, 4, 4).addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jComboBox1, -2, 23, -2).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    void setDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
        dialogDescriptor.setValid(false);
    }

    private void resourceChanged() {
        WadlSaasResource wadlSaasResource = (WadlSaasResource)this.resourceNode.getLookup().lookup(WadlSaasResource.class);
        if (wadlSaasResource != null) {
            boolean bl = false;
            try {
                if (wadlSaasResource.getSaas().getOauthMetadata() != null) {
                    this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(new Object[]{Security.Authentication.OAUTH}));
                    this.securityDefault = false;
                    bl = true;
                }
            }
            catch (IOException iOException) {
            }
            catch (JAXBException jAXBException) {
                // empty catch block
            }
            if (!bl) {
                SaasMetadata.Authentication authentication = wadlSaasResource.getSaas().getSaasMetadata().getAuthentication();
                if (authentication != null) {
                    if (authentication.getSessionKey().size() > 0) {
                        this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(new Object[]{Security.Authentication.SESSION_KEY}));
                        this.securityDefault = false;
                    } else if (authentication.getHttpBasic() != null) {
                        if (!this.securityDefault) {
                            this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(this.cbDefault));
                            this.securityDefault = true;
                        }
                        this.jComboBox1.setSelectedItem((Object)Security.Authentication.BASIC);
                    } else if (!this.securityDefault) {
                        this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(this.cbDefault));
                        this.securityDefault = true;
                    }
                } else if (!this.securityDefault) {
                    this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(this.cbDefault));
                    this.securityDefault = true;
                }
            }
        } else if (!this.securityDefault) {
            this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(this.cbDefault));
            this.securityDefault = true;
        }
        this.jComboBox1.setEnabled(this.securityDefault);
        if (this.wizardPanel == null) {
            if (!(this.nameChangedByUser && this.jTextField2.getText().trim().length() != 0 || this.resourceNode == null)) {
                if (wadlSaasResource != null) {
                    this.jTextField2.setText(Wadl2JavaHelper.getClientClassName(wadlSaasResource));
                } else {
                    RestServiceDescription restServiceDescription = (RestServiceDescription)this.resourceNode.getLookup().lookup(RestServiceDescription.class);
                    if (restServiceDescription != null) {
                        this.jTextField2.setText(restServiceDescription.getName() + "_JerseyClient");
                    }
                }
            }
        } else {
            this.wizardPanel.fireChangeEvent();
        }
    }

    private void nameChanged() {
        if (this.wizardPanel == null) {
            if (this.jTextField2.getText().trim().length() == 0) {
                this.descriptor.setValid(false);
            } else if (this.resourceNode == null) {
                this.descriptor.setValid(false);
            } else {
                this.descriptor.setValid(true);
            }
            this.nameChangedByUser = true;
        }
    }

    boolean isValid(WizardDescriptor wizardDescriptor) {
        if (this.wizardPanel != null && wizardDescriptor != null) {
            if (this.resourceNode != null) {
                return true;
            }
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(RESTResourcesPanel.class, (String)"LBL_SelectRestResource"));
            return false;
        }
        return true;
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        if (this.jRadioButton1.isSelected()) {
            RESTExplorerPanel rESTExplorerPanel = new RESTExplorerPanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)rESTExplorerPanel, NbBundle.getMessage(RESTResourcesPanel.class, (String)"TTL_RESTResources"));
            rESTExplorerPanel.setDescriptor(dialogDescriptor);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(NotifyDescriptor.OK_OPTION)) {
                this.resourceNode = rESTExplorerPanel.getSelectedService();
                boolean bl = this.nameChangedByUser;
                this.jTextField1.setText(this.resourceNode.getDisplayName());
                if (!bl) {
                    this.nameChangedByUser = false;
                }
            }
        } else {
            SaasExplorerPanel saasExplorerPanel = new SaasExplorerPanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)saasExplorerPanel, NbBundle.getMessage(RESTResourcesPanel.class, (String)"TTL_RESTResources"));
            saasExplorerPanel.setDescriptor(dialogDescriptor);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(NotifyDescriptor.OK_OPTION)) {
                this.resourceNode = saasExplorerPanel.getSelectedService();
                boolean bl = this.nameChangedByUser;
                this.jTextField1.setText(this.getSaasResourceName(this.resourceNode));
                if (!bl) {
                    this.nameChangedByUser = false;
                }
            }
        }
        if (this.resourceNode != null && this.wizardPanel == null) {
            this.descriptor.setValid(true);
        }
    }

    private String getSaasResourceName(Node node) {
        Node node2;
        WadlSaasResource wadlSaasResource = (WadlSaasResource)node.getLookup().lookup(WadlSaasResource.class);
        String string = wadlSaasResource.getResource().getPath();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        for (node2 = node.getParentNode(); node2 != null && node2.getLookup().lookup(WadlSaas.class) == null; node2 = node2.getParentNode()) {
            wadlSaasResource = (WadlSaasResource)node2.getLookup().lookup(WadlSaasResource.class);
            if (wadlSaasResource != null) {
                String string2 = wadlSaasResource.getResource().getPath();
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith("/")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (string2.length() <= 0) continue;
                string = string2 + "/" + string;
                continue;
            }
            string = node2.getDisplayName() + "/" + string;
        }
        if (node2 != null) {
            string = node2.getDisplayName() + " [" + string + "]";
        }
        return string;
    }

    public Node getResourceNode() {
        return this.resourceNode;
    }

    public String getResourceName() {
        return this.jTextField1.getText().trim();
    }

    public String getClassName() {
        return this.jTextField2.getText().trim();
    }

    public Security getSecurity() {
        return new Security(this.jCheckBox1.isSelected(), (Security.Authentication)((Object)this.jComboBox1.getSelectedItem()));
    }
}

