/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator.impl.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.AMConfigType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.ObjectFactory;

class AMConfigManager {
    private static final String AMCONFIG_CACHE_PATH = "amserver";
    private static final String AMCONFIG_CACHE_FILE = "amconfig.xml";
    private static final String JAXB_CONTEXT = "org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb";
    private static AMConfigManager instance;
    private HashMap<String, WeakReference> amConfigMap = new HashMap();

    private AMConfigManager() {
    }

    public static AMConfigManager getDefault() {
        if (instance == null) {
            instance = new AMConfigManager();
        }
        return instance;
    }

    public JAXBElement<AMConfigType> getAMConfig(String path) {
        String normalizedPath = path.replace('\\', '/');
        WeakReference<JAXBElement<AMConfigType>> reference = this.amConfigMap.get(normalizedPath);
        if (reference == null || reference.get() == null) {
            JAXBElement<AMConfigType> amConfig = this.getAMConfigInternal(path);
            reference = new WeakReference<JAXBElement<AMConfigType>>(amConfig);
            this.amConfigMap.put(normalizedPath, reference);
        }
        return (JAXBElement)reference.get();
    }

    public void removeAMConfig(String path) {
        String normalizedPath = path.replace('\\', '/');
        this.amConfigMap.remove(normalizedPath);
    }

    public void saveAMConfig(JAXBElement<AMConfigType> amConfig, String path) {
        try {
            this.createMarshaller().marshal(amConfig, (OutputStream)new FileOutputStream(AMConfigManager.getConfigFile(path, true)));
        }
        catch (JAXBException excp) {
            excp.printStackTrace();
        }
        catch (FileNotFoundException fexcp) {
            fexcp.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBElement<AMConfigType> getAMConfigInternal(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            File configFile = AMConfigManager.getConfigFile(path, false);
            JAXBElement<AMConfigType> amConfig = null;
            if (!configFile.exists()) {
                ObjectFactory objFactory = new ObjectFactory();
                AMConfigType amconfigType = objFactory.createAMConfigType();
                amConfig = objFactory.createAMConfig(amconfigType);
            } else {
                Unmarshaller unmarshaller = this.createUnmarshaller();
                amConfig = (JAXBElement<AMConfigType>)unmarshaller.unmarshal(configFile);
            }
            JAXBElement<AMConfigType> jAXBElement = amConfig;
            return jAXBElement;
        }
        catch (JAXBException excp) {
            excp.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return null;
    }

    private Unmarshaller createUnmarshaller() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_CONTEXT);
            return jaxbContext.createUnmarshaller();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Marshaller createMarshaller() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)JAXB_CONTEXT);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            return marshaller;
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static File getConfigFile(String path, boolean create) {
        File amconfigPath = new File(path.trim() + File.separator + AMCONFIG_CACHE_PATH);
        if (!amconfigPath.exists() && create) {
            amconfigPath.mkdir();
        }
        return new File(amconfigPath, File.separator + AMCONFIG_CACHE_FILE);
    }

    private static class BypassClassLoader
    extends ClassLoader {
        private ClassLoader[] parents = new ClassLoader[]{this.getClass().getClassLoader(), JAXBContext.class.getClassLoader()};

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            ClassNotFoundException cnfe = null;
            Class<?> clazz = null;
            for (ClassLoader cl : this.parents) {
                try {
                    clazz = cl.loadClass(name);
                    if (clazz == null) continue;
                    break;
                }
                catch (ClassNotFoundException ex) {
                    cnfe = ex;
                }
            }
            if (clazz == null && cnfe != null) {
                throw cnfe;
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }
}

