/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator.impl.dynamic;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.profile.api.configurator.TrustAuthorityConfigurator;
import org.netbeans.modules.identity.profile.api.configurator.impl.dynamic.ClassLoaderManager;
import org.netbeans.modules.identity.profile.api.configurator.spi.TrustAuthorityConfig;

public class TrustAuthorityConfigImpl
implements TrustAuthorityConfig {
    private static final String AM_TRUST_AUTHORITY_CONFIG_CLASS = "com.sun.identity.wss.provider.TrustAuthorityConfig";
    private static final String AM_DISCOVERY_TRUST_AUTHORITY_FIELD = "DISCOVERY_TRUST_AUTHORITY";
    private static final String AM_GET_CONFIG_METHOD = "getConfig";
    private static final String AM_SET_ENDPOINT_METHOD = "setEndpoint";
    private static final String AM_GET_ENDPOINT_METHOD = "getEndpoint";
    private static final String AM_SAVE_CONFIG_METHOD = "saveConfig";
    private String name;
    private TrustAuthorityConfigurator.Type type;
    private ServerProperties properties;
    private Object trustAuthConfig;
    private Class trustAuthConfigClass;
    private ClassLoader classLoader;

    public TrustAuthorityConfigImpl(String name, TrustAuthorityConfigurator.Type type, ServerProperties properties) {
        this.name = name;
        this.type = type;
        this.properties = properties;
    }

    protected ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = ClassLoaderManager.getDefault().getClassLoader(this.properties);
        }
        return this.classLoader;
    }

    protected Class getTrustAuthorityConfigClass() {
        if (this.trustAuthConfigClass == null) {
            try {
                this.trustAuthConfigClass = this.getClassLoader().loadClass(AM_TRUST_AUTHORITY_CONFIG_CLASS);
            }
            catch (Exception ex) {
                throw this.createConfiguratorException(ex);
            }
        }
        return this.trustAuthConfigClass;
    }

    protected Object getTrustAuthorityConfig() {
        if (this.trustAuthConfig == null) {
            try {
                Method method = this.getTrustAuthorityConfigClass().getMethod(AM_GET_CONFIG_METHOD, String.class, String.class);
                this.trustAuthConfig = method.invoke(null, this.name, this.getTypeValue());
            }
            catch (Exception ex) {
                throw this.createConfiguratorException(ex);
            }
        }
        return this.trustAuthConfig;
    }

    public TrustAuthorityConfigurator.Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public ServerProperties getServerProperties() {
        return this.properties;
    }

    @Override
    public void setEndpoint(String endpoint) {
        try {
            Method method = this.getTrustAuthorityConfigClass().getMethod(AM_SET_ENDPOINT_METHOD, new Class[0]);
            method.invoke(this.getTrustAuthorityConfig(), endpoint);
        }
        catch (Exception ex) {
            throw this.createConfiguratorException(ex);
        }
    }

    @Override
    public String getEndpoint() {
        try {
            Method method = this.getTrustAuthorityConfigClass().getMethod(AM_GET_ENDPOINT_METHOD, new Class[0]);
            return (String)method.invoke(this.getTrustAuthorityConfig(), new Object[0]);
        }
        catch (Exception ex) {
            throw this.createConfiguratorException(ex);
        }
    }

    @Override
    public void saveConfig() {
        try {
            Method method = this.getTrustAuthorityConfigClass().getMethod(AM_SAVE_CONFIG_METHOD, this.getTrustAuthorityConfigClass());
            method.invoke(null, this.getTrustAuthorityConfig());
        }
        catch (Exception ex) {
            throw this.createConfiguratorException(ex);
        }
    }

    private String getTypeValue() {
        try {
            String fieldName = null;
            if (this.type == TrustAuthorityConfigurator.Type.DISCOVERY) {
                fieldName = AM_DISCOVERY_TRUST_AUTHORITY_FIELD;
            }
            Field field = this.getTrustAuthorityConfigClass().getField(fieldName);
            return (String)field.get(null);
        }
        catch (Exception ex) {
            throw this.createConfiguratorException(ex);
        }
    }

    protected ConfiguratorException createConfiguratorException(Exception ex) {
        Throwable cause = ex.getCause();
        return new ConfiguratorException(cause != null ? cause : ex);
    }
}

