/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator;

import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.netbeans.modules.identity.profile.api.configurator.ConfiguratorException;
import org.openide.util.NbBundle;

public class ServerProperties
extends Properties
implements Cloneable {
    public static final String PROP_ID = "org.netbeans.modules.identity.profile.api.configurator.id";
    public static final String PROP_HOST = "com.iplanet.am.server.host";
    public static final String PROP_PORT = "com.iplanet.am.server.port";
    public static final String PROP_CONTEXT_ROOT = "org.netbeans.modules.identity.profile.api.configurator.contextroot";
    public static final String PROP_USERNAME = "com.sun.identity.agents.app.username";
    public static final String PROP_PASSWORD = "com.iplanet.am.service.password";
    private static final String PROP_PROTOCOL = "com.iplanet.am.server.protocol";
    public static final String PROP_AM_CONFIG_FILE = "org.netbeans.modules.identity.profile.api.configurator.amconfigfile";
    public static final String PROP_AM_CONSOLE_URL = "org.netbeans.modules.identity.profile.api.configurator.amconsoleurl";
    private static final String PROP_NAMING_SERVICE_URL = "com.iplanet.am.naming.url";
    public static final String PROP_IS_ALIVE_URL = "org.netbeans.modules.identity.profile.api.configurator.isaliveurl";
    public static final String PROP_LIBERTY_DISCO_SERVICE_URL = "org.netbeans.modules.identity.profile.api.configurator.libertydiscoserviceurl";
    public static final String PROP_AS_ROOT = "org.netbeans.modules.identity.profile.api.configurator.asroot";
    private static final String NAMING_SERVICE = "/namingservice";
    private static final String IS_ALIVE_JSP = "/isAlive.jsp";
    private static final String LIBERTY_DISCO_SERVICE = "/Liberty/disco";
    private static final String AM_CONFIG_FILE = "/domains/domain1/config/AMConfig.properties";
    private static HashMap<String, ServerProperties> instanceMap = new HashMap();

    public static synchronized ServerProperties getInstance(String id) {
        ServerProperties instance = instanceMap.get(id);
        if (instance == null) {
            instance = new ServerProperties(id);
            instanceMap.put(id, instance);
        }
        return instance;
    }

    private ServerProperties(String id) throws ConfiguratorException {
        this.init(id);
    }

    private void init(String id) {
        String asRoot = id.substring(1, id.indexOf(93));
        String amConfigFile = asRoot + AM_CONFIG_FILE;
        String[] segments = id.substring(id.indexOf(93) + 1).split(":");
        String host = segments[4];
        try {
            this.load(new FileInputStream(amConfigFile.trim()));
            this.setProperty(PROP_AM_CONFIG_FILE, amConfigFile);
            this.setProperty(PROP_AS_ROOT, asRoot);
            this.setProperty(PROP_ID, id);
            this.setProperty(PROP_CONTEXT_ROOT, this.getContextRoot());
            this.setProperty(PROP_HOST, host);
            this.updateURLs();
        }
        catch (Exception ex) {
            throw new ConfiguratorException(NbBundle.getMessage(ServerProperties.class, (String)"TXT_InvalidAMConfigFile"));
        }
    }

    @Override
    public Object setProperty(String key, String value) {
        Object prevValue = super.setProperty(key, value);
        this.updateInternalProperties(key);
        return prevValue;
    }

    private void updateInternalProperties(String key) {
        if (key.equals(PROP_PORT) || key.equals(PROP_HOST) || key.equals(PROP_PROTOCOL) || key.equals(PROP_CONTEXT_ROOT)) {
            this.updateURLs();
        } else if (key.equals(PROP_USERNAME) || key.equals(PROP_PASSWORD)) {
            // empty if block
        }
    }

    private void updateURLs() {
        String port = this.getProperty(PROP_PORT);
        String host = this.getProperty(PROP_HOST);
        String protocol = this.getProperty(PROP_PROTOCOL);
        String contextRoot = this.getProperty(PROP_CONTEXT_ROOT);
        String amConsoleURL = protocol + "://" + host + ":" + port + "/" + contextRoot;
        String namingServiceURL = amConsoleURL + NAMING_SERVICE;
        String isAliveURL = amConsoleURL + IS_ALIVE_JSP;
        String discoURL = amConsoleURL + LIBERTY_DISCO_SERVICE;
        this.setProperty(PROP_AM_CONSOLE_URL, amConsoleURL);
        this.setProperty(PROP_NAMING_SERVICE_URL, namingServiceURL);
        this.setProperty(PROP_IS_ALIVE_URL, isAliveURL);
        this.setProperty(PROP_LIBERTY_DISCO_SERVICE_URL, discoURL);
    }

    private String getContextRoot() {
        String namingURL = this.getProperty(PROP_NAMING_SERVICE_URL);
        String adminURL = namingURL.substring(0, namingURL.length() - NAMING_SERVICE.length());
        String contextRoot = adminURL.substring(adminURL.lastIndexOf(47) + 1);
        return contextRoot;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ServerProperties) {
            ServerProperties properties = (ServerProperties)obj;
            if (!this.getProperty(PROP_HOST).equals(properties.getProperty(PROP_HOST))) {
                return false;
            }
            if (!this.getProperty(PROP_PORT).equals(properties.getProperty(PROP_PORT))) {
                return false;
            }
            if (!this.getProperty(PROP_USERNAME).equals(properties.getProperty(PROP_USERNAME))) {
                return false;
            }
            if (!this.getProperty(PROP_PASSWORD).equals(properties.getProperty(PROP_PASSWORD))) {
                return false;
            }
            return this.getProperty(PROP_CONTEXT_ROOT).equals(properties.getProperty(PROP_CONTEXT_ROOT));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        String value = null;
        value = this.getProperty(PROP_HOST);
        if (value != null) {
            hashCode += value.hashCode();
        }
        if ((value = this.getProperty(PROP_PORT)) != null) {
            hashCode += value.hashCode();
        }
        if ((value = this.getProperty(PROP_USERNAME)) != null) {
            hashCode += value.hashCode();
        }
        if ((value = this.getProperty(PROP_PASSWORD)) != null) {
            hashCode += value.hashCode();
        }
        if ((value = this.getProperty(PROP_CONTEXT_ROOT)) != null) {
            hashCode += value.hashCode();
        }
        return hashCode;
    }

    @Override
    public Object clone() {
        Object clone = super.clone();
        Enumeration<?> propNames = this.propertyNames();
        while (propNames.hasMoreElements()) {
            String name = (String)propNames.nextElement();
            ((ServerProperties)clone).setProperty(name, this.getProperty(name));
        }
        return clone;
    }

    @Override
    public String toString() {
        return this.getProperty(PROP_ID) + " (" + this.getProperty(PROP_HOST) + ":" + this.getProperty(PROP_PORT) + ")";
    }
}

