/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class Hk2Logger {
    private static final int delay = 1000;
    private static Map<String, Hk2Logger> instances = new HashMap<String, Hk2Logger>();
    private InputOutput io;

    private Hk2Logger(String string) {
        this.io = UISupport.getServerIO((String)string);
        if (this.io == null) {
            return;
        }
        try {
            this.io.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.io.select();
    }

    public static Hk2Logger getInstance(String string) {
        if (!instances.containsKey(string)) {
            instances.put(string, new Hk2Logger(string));
        }
        return instances.get(string);
    }

    public void readInputStreams(InputStream[] inputStreamArray) {
        for (InputStream inputStream : inputStreamArray) {
            RequestProcessor.getDefault().post((Runnable)new LoggerRunnable(inputStream));
        }
    }

    public void readFiles(File[] fileArray) {
        for (InputStream inputStream : Hk2Logger.getInputStreamsFromFiles(fileArray)) {
            RequestProcessor.getDefault().post((Runnable)new LoggerRunnable(inputStream));
        }
    }

    public synchronized void write(String string) {
        this.io.getOut().print(string);
    }

    public synchronized void selectIO() {
        this.io.select();
    }

    private static InputStream[] getInputStreamsFromFiles(File[] fileArray) {
        InputStream[] inputStreamArray = new InputStream[fileArray.length];
        int n = 0;
        try {
            for (n = 0; n < fileArray.length; ++n) {
                inputStreamArray[n] = new FileInputStream(fileArray[n]);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, fileArray[n].getAbsolutePath(), fileNotFoundException);
            return new InputStream[0];
        }
        return inputStreamArray;
    }

    private class LoggerRunnable
    implements Runnable {
        private InputStream inputStream;

        public LoggerRunnable(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream);
                    char[] cArray = new char[1024];
                    while (true) {
                        if (inputStreamReader.ready()) {
                            Hk2Logger.this.write(new String(cArray, 0, inputStreamReader.read(cArray)));
                            Hk2Logger.this.selectIO();
                            continue;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException iOException2) {
                        ErrorManager.getDefault().notify(4096, (Throwable)iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    this.inputStream.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                }
                throw throwable;
            }
        }
    }
}

