/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.impl.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTMacroExpandedStream;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.model.services.CsmMacroExpansionDocProvider;
import org.openide.text.NbDocument;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;

public class MacroExpansionDocProviderImpl
implements CsmMacroExpansionDocProvider {
    public static final String MACRO_EXPANSION_OFFSET_TRANSFORMER = "macro-expansion-offset-transformer";
    public static final String MACRO_EXPANSION_MACRO_TABLE = "macro-expansion-macro-table";
    public static final String MACRO_EXPANSION_STOP_ON_OFFSET_PARSE_FILE_WALKER_CACHE = "macro-expansion-stop-on-offset-parse-file-walker-cache";

    public synchronized int expand(final Document document, final int n, final int n2, Document document2) {
        if (document == null || document2 == null) {
            return 0;
        }
        final CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)true, (boolean)false);
        if (csmFile == null) {
            return 0;
        }
        final MyTokenSequence myTokenSequence = this.getFileTokenSequence(csmFile, n, n2);
        if (myTokenSequence == null) {
            return 0;
        }
        final StringBuilder stringBuilder = new StringBuilder();
        final TransformationTable transformationTable = new TransformationTable(DocumentUtilities.getDocumentVersion((Document)document), CsmFileInfoQuery.getDefault().getFileVersion(csmFile));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)document, (int)document.getLength(), (boolean)false, (boolean)true);
                if (tokenSequence == null) {
                    return;
                }
                tokenSequence.move(n);
                transformationTable.setInStart(n);
                transformationTable.setOutStart(0);
                boolean bl = false;
                boolean bl2 = true;
                while (tokenSequence.moveNext()) {
                    Token token = tokenSequence.token();
                    int n3 = tokenSequence.offset();
                    int n22 = n3 + token.length();
                    if (MacroExpansionDocProviderImpl.this.isWhitespace((Token<CppTokenId>)token)) continue;
                    APTToken aPTToken = MacroExpansionDocProviderImpl.this.findToken(myTokenSequence, n3);
                    if (aPTToken == null) {
                        if (!bl && !bl2) {
                            MacroExpansionDocProviderImpl.this.copyInterval(document, (n2 > n3 ? n3 : n2) - transformationTable.currentIn.start, transformationTable, stringBuilder);
                        }
                        transformationTable.appendInterval(n2 - transformationTable.currentIn.start, 0);
                        break;
                    }
                    if (n22 <= aPTToken.getOffset() || !APTUtils.isMacroExpandedToken((org.netbeans.modules.cnd.antlr.Token)aPTToken)) {
                        if (MacroExpansionDocProviderImpl.this.isOnInclude((TokenSequence<CppTokenId>)tokenSequence)) {
                            if (!bl && !bl2) {
                                MacroExpansionDocProviderImpl.this.copyInterval(document, n3 - transformationTable.currentIn.start, transformationTable, stringBuilder);
                            } else {
                                transformationTable.appendInterval(n3 - transformationTable.currentIn.start, 0);
                            }
                            MacroExpansionDocProviderImpl.this.expandIcludeToken((TokenSequence<CppTokenId>)tokenSequence, document, csmFile, transformationTable, stringBuilder);
                        } else if (n22 <= aPTToken.getOffset()) {
                            if (bl || bl2) {
                                transformationTable.appendInterval(n22 - transformationTable.currentIn.start, 0);
                                continue;
                            }
                            MacroExpansionDocProviderImpl.this.copyInterval(document, n3 - transformationTable.currentIn.start, transformationTable, stringBuilder);
                            transformationTable.appendInterval(n22 - transformationTable.currentIn.start, 0);
                            bl2 = true;
                            continue;
                        }
                        bl = false;
                        bl2 = false;
                        continue;
                    }
                    MacroExpansionDocProviderImpl.this.copyInterval(document, n3 - transformationTable.currentIn.start, transformationTable, stringBuilder);
                    MacroExpansionDocProviderImpl.this.expandMacroToken(tokenSequence, myTokenSequence, transformationTable, stringBuilder);
                    bl = true;
                }
                MacroExpansionDocProviderImpl.this.copyInterval(document, n2 - transformationTable.currentIn.start, transformationTable, stringBuilder);
                transformationTable.cleanUp();
            }
        };
        document.render(runnable);
        document2.putProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER, transformationTable);
        try {
            document2.insertString(0, stringBuilder.toString(), null);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        this.initGuardedBlocks(document2, transformationTable);
        return this.calcExpansionNumber(transformationTable);
    }

    public int getOffsetInExpandedText(Document document, int n) {
        Object object = document.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (object != null && object instanceof TransformationTable) {
            TransformationTable transformationTable = (TransformationTable)object;
            return transformationTable.getOutOffset(n);
        }
        return n;
    }

    public int getOffsetInOriginalText(Document document, int n) {
        Object object = document.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (object != null && object instanceof TransformationTable) {
            TransformationTable transformationTable = (TransformationTable)object;
            return transformationTable.getInOffset(n);
        }
        return n;
    }

    public int getNextMacroExpansionStartOffset(Document document, int n) {
        Object object = document.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (object != null && object instanceof TransformationTable) {
            TransformationTable transformationTable = (TransformationTable)object;
            return transformationTable.getNextMacroExpansionStartOffset(n);
        }
        return n;
    }

    public int getPrevMacroExpansionStartOffset(Document document, int n) {
        Object object = document.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (object != null && object instanceof TransformationTable) {
            TransformationTable transformationTable = (TransformationTable)object;
            return transformationTable.getPrevMacroExpansionStartOffset(n);
        }
        return n;
    }

    private void fillParamsToExpansionMap(APTToken aPTToken, TransformationTable transformationTable, int n, Map<Interval, List<Interval>> map) {
        APTToken aPTToken2 = APTUtils.getExpandedToken((APTToken)aPTToken);
        if (aPTToken2 != null) {
            Interval interval = new Interval(aPTToken2.getOffset(), aPTToken2.getEndOffset());
            Interval interval2 = new Interval(transformationTable.currentOut.start + n, transformationTable.currentOut.start + n + aPTToken.getText().length());
            List<Interval> list = map.get(interval);
            if (list != null) {
                list.add(interval2);
            } else {
                list = new ArrayList<Interval>(1);
                list.add(interval2);
                map.put(interval, list);
            }
        }
    }

    private APTToken findToken(MyTokenSequence myTokenSequence, int n) {
        while (myTokenSequence.token() != null && !APTUtils.isEOF((org.netbeans.modules.cnd.antlr.Token)myTokenSequence.token()) && myTokenSequence.token().getOffset() < n) {
            myTokenSequence.moveNext();
        }
        if (myTokenSequence.token() == null || APTUtils.isEOF((org.netbeans.modules.cnd.antlr.Token)myTokenSequence.token())) {
            return null;
        }
        return myTokenSequence.token();
    }

    private TransformationTable getMacroTable(Document document) {
        Object object = document.getProperty(MACRO_EXPANSION_MACRO_TABLE);
        if (object != null && object instanceof TransformationTable) {
            TransformationTable transformationTable = (TransformationTable)object;
            return transformationTable;
        }
        return null;
    }

    private TransformationTable getTransformationTable(Document document) {
        Object object = document.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (object != null && object instanceof TransformationTable) {
            TransformationTable transformationTable = (TransformationTable)object;
            return transformationTable;
        }
        return null;
    }

    public String[] getMacroExpansion(Document document, int n) {
        return new String[]{"", ""};
    }

    public String expand(Document document, int n, int n2) {
        if (document == null) {
            return null;
        }
        return this.expand(document, CsmUtilities.getCsmFile((Document)document, (boolean)true, (boolean)false), n, n2);
    }

    public String expand(Document document, CsmFile csmFile, int n, int n2) {
        TransformationTable transformationTable = this.updateMacroTableIfNeeded(document, csmFile);
        return transformationTable == null ? null : this.expandInterval(document, transformationTable, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getMacroExpansionSpan(Document document, int n, boolean bl) {
        int n2;
        TransformationTable transformationTable;
        Document document2;
        int[] nArray = new int[]{n, n};
        if (bl) {
            document2 = CsmUtilities.getCsmFile((Document)document, (boolean)true, (boolean)false);
            transformationTable = this.updateMacroTableIfNeeded(document, (CsmFile)document2);
        } else {
            document2 = document;
            synchronized (document2) {
                transformationTable = this.getMacroTable(document);
            }
        }
        if (transformationTable != null && 0 <= (n2 = transformationTable.findInIntervalIndex(n)) && n2 < transformationTable.intervals.size()) {
            IntervalCorrespondence intervalCorrespondence;
            int n3;
            if (((IntervalCorrespondence)transformationTable.intervals.get(n2)).getInInterval().end == n && n2 < transformationTable.intervals.size() - 1) {
                ++n2;
            }
            boolean bl2 = false;
            int n4 = transformationTable.intervals.size();
            for (n3 = n2; n3 >= 0; --n3) {
                intervalCorrespondence = (IntervalCorrespondence)transformationTable.intervals.get(n3);
                if (intervalCorrespondence.isMacro()) {
                    nArray[0] = intervalCorrespondence.getInInterval().start;
                    nArray[1] = intervalCorrespondence.getInInterval().end;
                    bl2 = true;
                    n4 = n3;
                    break;
                }
                if (intervalCorrespondence.getOutInterval().length() == 0) continue;
                return nArray;
            }
            if (bl2) {
                for (n3 = n4 + 1; n3 < transformationTable.intervals.size(); ++n3) {
                    intervalCorrespondence = (IntervalCorrespondence)transformationTable.intervals.get(n3);
                    if (intervalCorrespondence.getOutInterval().length() != 0) {
                        return nArray;
                    }
                    nArray[1] = intervalCorrespondence.getInInterval().end;
                }
            }
        }
        return nArray;
    }

    public int[][] getUsages(Document document, int n) {
        TransformationTable transformationTable;
        int n2;
        Object object = document.getProperty(MACRO_EXPANSION_OFFSET_TRANSFORMER);
        if (object != null && object instanceof TransformationTable && 0 <= (n2 = (transformationTable = (TransformationTable)object).findInIntervalIndex(n)) && n2 < transformationTable.intervals.size()) {
            if (((IntervalCorrespondence)transformationTable.intervals.get(n2)).getInInterval().end == n && n2 < transformationTable.intervals.size() - 1) {
                ++n2;
            }
            for (int i = n2; i >= 0; --i) {
                IntervalCorrespondence intervalCorrespondence = (IntervalCorrespondence)transformationTable.intervals.get(i);
                if (intervalCorrespondence.isMacro()) {
                    if (intervalCorrespondence.getParamsToExpansion() == null) break;
                    for (Interval interval : intervalCorrespondence.getParamsToExpansion().keySet()) {
                        if (!interval.contains(n)) continue;
                        List<Interval> list = intervalCorrespondence.getParamsToExpansion().get(interval);
                        int[][] nArray = new int[list.size()][2];
                        for (int j = 0; j < nArray.length; ++j) {
                            nArray[j][0] = list.get(j).start;
                            nArray[j][1] = list.get(j).end;
                        }
                        return nArray;
                    }
                    break;
                }
                if (intervalCorrespondence.getOutInterval().length() == 0) continue;
                return null;
            }
        }
        return null;
    }

    public String expand(Document document, int n, String string) {
        if (document == null) {
            return string;
        }
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)document, (boolean)true, (boolean)false);
        if (!(csmFile instanceof FileImpl)) {
            return string;
        }
        FileImpl fileImpl = (FileImpl)csmFile;
        APTPreprocHandler aPTPreprocHandler = ((FileImpl)csmFile).getPreprocHandler(n);
        if (aPTPreprocHandler == null) {
            return string;
        }
        APTFile aPTFile = null;
        try {
            aPTFile = APTDriver.getInstance().findAPTLight((APTFileBuffer)fileImpl.getBuffer());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        if (aPTFile == null) {
            return string;
        }
        CsmProject csmProject = csmFile.getProject();
        if (!(csmProject instanceof ProjectBase)) {
            return string;
        }
        ProjectBase projectBase = (ProjectBase)csmProject;
        APTFileCacheEntry aPTFileCacheEntry = fileImpl.getAPTCacheEntry(aPTPreprocHandler, Boolean.FALSE);
        StopOnOffsetParseFileWalker stopOnOffsetParseFileWalker = new StopOnOffsetParseFileWalker(projectBase, aPTFile, fileImpl, n, aPTPreprocHandler, aPTFileCacheEntry);
        stopOnOffsetParseFileWalker.visit();
        TokenStream tokenStream = APTTokenStreamBuilder.buildTokenStream((String)string, (String)fileImpl.getFileLanguage());
        if (tokenStream != null) {
            tokenStream = new APTMacroExpandedStream(tokenStream, (APTMacroCallback)aPTPreprocHandler.getMacroMap());
            StringBuilder stringBuilder = new StringBuilder("");
            try {
                APTToken aPTToken = (APTToken)tokenStream.nextToken();
                while (aPTToken != null && !APTUtils.isEOF((org.netbeans.modules.cnd.antlr.Token)aPTToken)) {
                    stringBuilder.append(aPTToken.getText());
                    aPTToken = (APTToken)tokenStream.nextToken();
                }
            }
            catch (TokenStreamException tokenStreamException) {
                Exceptions.printStackTrace((Throwable)tokenStreamException);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private String expandInterval(Document document, TransformationTable transformationTable, int n, int n2) {
        IntervalCorrespondence intervalCorrespondence;
        if (transformationTable.intervals.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("");
        int n3 = transformationTable.intervals.size();
        int n4 = transformationTable.findInIntervalIndex(n);
        if (n4 < 0) {
            return "";
        }
        for (int i = n4; i < n3 && (intervalCorrespondence = (IntervalCorrespondence)transformationTable.intervals.get(i)).getInInterval().start < n2; ++i) {
            if (intervalCorrespondence.getInInterval().end <= n) continue;
            int n5 = n - intervalCorrespondence.getInInterval().start;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n5 >= intervalCorrespondence.getOutInterval().length()) continue;
            int n6 = n5 + (n2 - n);
            if (n2 >= intervalCorrespondence.getInInterval().end) {
                n6 = intervalCorrespondence.getOutInterval().length();
            }
            if (n6 > intervalCorrespondence.getOutInterval().length()) {
                n6 = intervalCorrespondence.getOutInterval().length();
            }
            if (n6 - n5 == 0) continue;
            if (intervalCorrespondence.isMacro()) {
                if (n5 == 0 && n6 == intervalCorrespondence.getOutInterval().length()) {
                    stringBuilder.append(intervalCorrespondence.getMacroExpansion());
                    continue;
                }
                stringBuilder.append(((Object)intervalCorrespondence.getMacroExpansion()).toString().substring(n5, n6));
                continue;
            }
            if (intervalCorrespondence.getOutInterval().length() == 0) continue;
            stringBuilder.append(MacroExpansionDocProviderImpl.getDocumentText(document, intervalCorrespondence.getInInterval().start + n5, n6 - n5));
        }
        return stringBuilder.toString();
    }

    private void expand(final Document document, final CsmFile csmFile, final TransformationTable transformationTable) {
        if (document == null) {
            return;
        }
        if (csmFile == null) {
            return;
        }
        final MyTokenSequence myTokenSequence = this.getFileTokenSequence(csmFile, 0, document.getLength());
        if (myTokenSequence == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)document, (int)document.getLength(), (boolean)false, (boolean)true);
                if (tokenSequence == null) {
                    return;
                }
                tokenSequence.moveStart();
                int n = 0;
                int n2 = document.getLength();
                transformationTable.setInStart(n);
                transformationTable.setOutStart(0);
                boolean bl = false;
                boolean bl2 = true;
                while (tokenSequence.moveNext()) {
                    Token token = tokenSequence.token();
                    int n3 = tokenSequence.offset();
                    int n4 = n3 + token.length();
                    if (MacroExpansionDocProviderImpl.this.isWhitespace((Token<CppTokenId>)token)) continue;
                    APTToken aPTToken = MacroExpansionDocProviderImpl.this.findToken(myTokenSequence, n3);
                    if (aPTToken == null) {
                        if (!bl && !bl2) {
                            MacroExpansionDocProviderImpl.this.copyInterval(document, (n2 > n3 ? n3 : n2) - transformationTable.currentIn.start, transformationTable, null);
                        }
                        transformationTable.appendInterval(n2 - transformationTable.currentIn.start, 0);
                        break;
                    }
                    if (n4 <= aPTToken.getOffset() || !APTUtils.isMacroExpandedToken((org.netbeans.modules.cnd.antlr.Token)aPTToken)) {
                        if (MacroExpansionDocProviderImpl.this.isOnInclude((TokenSequence<CppTokenId>)tokenSequence)) {
                            if (!bl && !bl2) {
                                MacroExpansionDocProviderImpl.this.copyInterval(document, n3 - transformationTable.currentIn.start, transformationTable, null);
                            } else {
                                transformationTable.appendInterval(n3 - transformationTable.currentIn.start, 0);
                            }
                            MacroExpansionDocProviderImpl.this.expandIcludeToken((TokenSequence<CppTokenId>)tokenSequence, document, csmFile, transformationTable, null);
                        } else if (n4 <= aPTToken.getOffset()) {
                            if (bl || bl2) {
                                transformationTable.appendInterval(n4 - transformationTable.currentIn.start, 0);
                                continue;
                            }
                            MacroExpansionDocProviderImpl.this.copyInterval(document, n3 - transformationTable.currentIn.start, transformationTable, null);
                            transformationTable.appendInterval(n4 - transformationTable.currentIn.start, 0);
                            bl2 = true;
                            continue;
                        }
                        bl = false;
                        bl2 = false;
                        continue;
                    }
                    MacroExpansionDocProviderImpl.this.copyInterval(document, n3 - transformationTable.currentIn.start, transformationTable, null);
                    MacroExpansionDocProviderImpl.this.expandMacroToken(tokenSequence, myTokenSequence, transformationTable, null);
                    bl = true;
                }
                MacroExpansionDocProviderImpl.this.copyInterval(document, n2 - transformationTable.currentIn.start, transformationTable, null);
            }
        };
        document.render(runnable);
    }

    private String expandMacroToken(MyTokenSequence myTokenSequence, int n, int n2, TransformationTable transformationTable) {
        APTToken aPTToken = myTokenSequence.token();
        StringBuilder stringBuilder = new StringBuilder("");
        int n3 = 0;
        HashMap<Interval, List<Interval>> hashMap = new HashMap<Interval, List<Interval>>();
        boolean bl = true;
        if (aPTToken.getOffset() < n2) {
            if (!APTUtils.isCommentToken((org.netbeans.modules.cnd.antlr.Token)aPTToken)) {
                stringBuilder.append(aPTToken.getText());
                if (APTUtils.isMacroParamExpandedToken((org.netbeans.modules.cnd.antlr.Token)aPTToken)) {
                    this.fillParamsToExpansionMap(aPTToken, transformationTable, n3, hashMap);
                }
                n3 += aPTToken.getText().length();
                bl = false;
            }
            APTToken aPTToken2 = aPTToken;
            myTokenSequence.moveNext();
            aPTToken = myTokenSequence.token();
            while (aPTToken != null && !APTUtils.isEOF((org.netbeans.modules.cnd.antlr.Token)aPTToken) && aPTToken.getOffset() < n2) {
                if (!APTUtils.isCommentToken((org.netbeans.modules.cnd.antlr.Token)aPTToken)) {
                    if (!bl && !APTUtils.areAdjacent((APTToken)aPTToken2, (APTToken)aPTToken)) {
                        stringBuilder.append(" ");
                        ++n3;
                    }
                    bl = false;
                    stringBuilder.append(aPTToken.getText());
                    if (APTUtils.isMacroParamExpandedToken((org.netbeans.modules.cnd.antlr.Token)aPTToken)) {
                        this.fillParamsToExpansionMap(aPTToken, transformationTable, n3, hashMap);
                    }
                    n3 += aPTToken.getText().length();
                }
                aPTToken2 = aPTToken;
                myTokenSequence.moveNext();
                aPTToken = myTokenSequence.token();
            }
        }
        transformationTable.appendInterval(n2 - n, stringBuilder.length(), true, stringBuilder.toString(), hashMap);
        return stringBuilder.toString();
    }

    private void expandMacroToken(TokenSequence tokenSequence, MyTokenSequence myTokenSequence, TransformationTable transformationTable, StringBuilder stringBuilder) {
        this.expandMacroToken(tokenSequence.token(), tokenSequence.offset(), myTokenSequence, transformationTable, stringBuilder);
    }

    private void expandMacroToken(Token token, int n, MyTokenSequence myTokenSequence, TransformationTable transformationTable, StringBuilder stringBuilder) {
        String string = this.expandMacroToken(myTokenSequence, n, n + token.length(), transformationTable);
        this.addString(string, stringBuilder);
    }

    private void expandIcludeToken(TokenSequence<CppTokenId> tokenSequence, Document document, CsmFile csmFile, TransformationTable transformationTable, StringBuilder stringBuilder) {
        int n = tokenSequence.offset();
        String string = this.getIncludeName(csmFile, n);
        if (string == null) {
            return;
        }
        int n2 = n;
        int n3 = n;
        Token token = tokenSequence.token();
        block0 : switch ((CppTokenId)token.id()) {
            case PREPROCESSOR_DIRECTIVE: {
                TokenSequence tokenSequence2 = tokenSequence.embedded();
                if (tokenSequence2 == null) break;
                tokenSequence2.moveStart();
                if (!tokenSequence2.moveNext()) {
                    return;
                }
                Token token2 = tokenSequence2.token();
                if (token2 == null || !(token2.id() instanceof CppTokenId) || token2.id() != CppTokenId.PREPROCESSOR_START) {
                    return;
                }
                if (!tokenSequence2.moveNext()) {
                    return;
                }
                this.skipWhitespacesAndComments(tokenSequence2);
                token2 = tokenSequence2.token();
                if (token2 == null || !(token2.id() instanceof CppTokenId)) break;
                switch ((CppTokenId)token2.id()) {
                    case PREPROCESSOR_INCLUDE: {
                        if (!tokenSequence2.moveNext()) {
                            return;
                        }
                        this.skipWhitespacesAndComments(tokenSequence2);
                        n2 = tokenSequence2.offset();
                        token2 = tokenSequence2.token();
                        while (token2 != null && token2.id() instanceof CppTokenId && token2.id() != CppTokenId.NEW_LINE) {
                            if (!tokenSequence2.moveNext()) {
                                return;
                            }
                            n3 = tokenSequence2.offset();
                            this.skipWhitespacesAndComments(tokenSequence2);
                            token2 = tokenSequence2.token();
                        }
                        break block0;
                    }
                    default: {
                        return;
                    }
                }
            }
            default: {
                return;
            }
        }
        this.copyInterval(document, n2 - n, transformationTable, stringBuilder);
        int n4 = this.addString(string, stringBuilder);
        transformationTable.appendInterval(n3 - n2, n4);
    }

    private String getIncludeName(CsmFile csmFile, int n) {
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            if (csmInclude.getStartOffset() != n) continue;
            if (csmInclude.isSystem()) {
                StringBuilder stringBuilder = new StringBuilder("<");
                stringBuilder.append(((Object)csmInclude.getIncludeName()).toString());
                stringBuilder.append(">");
                return stringBuilder.toString();
            }
            StringBuilder stringBuilder = new StringBuilder("\"");
            stringBuilder.append(((Object)csmInclude.getIncludeName()).toString());
            stringBuilder.append("\"");
            return stringBuilder.toString();
        }
        return null;
    }

    private void skipWhitespacesAndComments(TokenSequence tokenSequence) {
        if (tokenSequence != null) {
            Token token = tokenSequence.token();
            block3: while (token != null && token.id() instanceof CppTokenId) {
                switch ((CppTokenId)token.id()) {
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: 
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case ESCAPED_LINE: {
                        tokenSequence.moveNext();
                        token = tokenSequence.token();
                        continue block3;
                    }
                }
                return;
            }
        }
    }

    private void initGuardedBlocks(Document document, TransformationTable transformationTable) {
        if (document instanceof StyledDocument) {
            for (IntervalCorrespondence intervalCorrespondence : transformationTable.intervals) {
                if (!intervalCorrespondence.isMacro()) continue;
                NbDocument.markGuarded((StyledDocument)((StyledDocument)document), (int)intervalCorrespondence.getOutInterval().start, (int)intervalCorrespondence.getOutInterval().length());
            }
        }
    }

    private int calcExpansionNumber(TransformationTable transformationTable) {
        int n = 0;
        for (IntervalCorrespondence intervalCorrespondence : transformationTable.intervals) {
            if (!intervalCorrespondence.isMacro()) continue;
            ++n;
        }
        return n;
    }

    private MyTokenSequence getFileTokenSequence(CsmFile csmFile, int n, int n2) {
        TokenStream tokenStream;
        FileImpl fileImpl = null;
        if (csmFile instanceof FileImpl && (tokenStream = (fileImpl = (FileImpl)csmFile).getTokenStream(n, n2, 0, false)) != null) {
            return new MyTokenSequence(tokenStream, fileImpl);
        }
        return null;
    }

    private void copyInterval(Document document, int n, TransformationTable transformationTable, StringBuilder stringBuilder) {
        if (n != 0) {
            this.addString(MacroExpansionDocProviderImpl.getDocumentText(document, transformationTable.currentIn.start, n), stringBuilder);
            transformationTable.appendInterval(n, n);
        }
    }

    private static String getDocumentText(Document document, int n, int n2) {
        try {
            int n3 = document.getLength();
            n = n > 0 ? n : 0;
            n = n < n3 ? n : n3;
            n2 = n2 > 0 ? n2 : 0;
            int n4 = n2 = n + n2 <= n3 ? n2 : n3 - n;
            if (n2 > 0) {
                return document.getText(n, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "";
    }

    private boolean isWhitespace(Token<CppTokenId> token) {
        switch ((CppTokenId)token.id()) {
            case WHITESPACE: 
            case ESCAPED_WHITESPACE: 
            case ESCAPED_LINE: 
            case NEW_LINE: {
                return true;
            }
        }
        return false;
    }

    private boolean isOnInclude(TokenSequence<CppTokenId> tokenSequence) {
        Token token = tokenSequence.token();
        switch ((CppTokenId)token.id()) {
            case PREPROCESSOR_DIRECTIVE: {
                TokenSequence tokenSequence2 = tokenSequence.embedded();
                if (tokenSequence2 == null) break;
                tokenSequence2.moveStart();
                if (!tokenSequence2.moveNext()) break;
                Token token2 = tokenSequence2.token();
                if (token2 == null || !(token2.id() instanceof CppTokenId) || token2.id() != CppTokenId.PREPROCESSOR_START) {
                    return false;
                }
                if (!tokenSequence2.moveNext()) break;
                this.skipWhitespacesAndComments(tokenSequence2);
                token2 = tokenSequence2.token();
                if (token2 == null || !(token2.id() instanceof CppTokenId)) break;
                switch ((CppTokenId)token2.id()) {
                    case PREPROCESSOR_INCLUDE: 
                    case PREPROCESSOR_INCLUDE_NEXT: {
                        return true;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private int addString(String string, StringBuilder stringBuilder) {
        if (stringBuilder != null) {
            stringBuilder.append(string);
        }
        return string.length();
    }

    String dumpTables(Document document) {
        StringBuilder stringBuilder = new StringBuilder();
        TransformationTable transformationTable = this.getMacroTable(document);
        if (transformationTable != null) {
            stringBuilder.append("MacroTable: ");
            stringBuilder.append(transformationTable.toString());
        }
        if ((transformationTable = this.getTransformationTable(document)) != null) {
            stringBuilder.append("TransformationTable: ");
            stringBuilder.append(transformationTable.toString());
        }
        return stringBuilder.toString();
    }

    private static IntervalCorrespondence createIntervalCorrespondence(Interval interval) {
        return new IntervalCorrespondenceSimple(interval, interval);
    }

    private static IntervalCorrespondence createIntervalCorrespondence(Interval interval, Interval interval2, boolean bl, CharSequence charSequence, Map<Interval, List<Interval>> map) {
        if (!bl && charSequence == null && map == null) {
            return new IntervalCorrespondenceSimple(interval, interval2);
        }
        if (map != null && map.isEmpty()) {
            map = Collections.emptyMap();
        }
        return new IntervalCorrespondenceMacro(interval, interval2, bl, charSequence, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransformationTable updateMacroTableIfNeeded(Document document, CsmFile csmFile) {
        if (csmFile == null || document == null) {
            return null;
        }
        TransformationTable transformationTable = null;
        Object object = document;
        synchronized (object) {
            transformationTable = this.getMacroTable(document);
            if (transformationTable == null) {
                transformationTable = new TransformationTable(DocumentUtilities.getDocumentVersion((Document)document), CsmFileInfoQuery.getDefault().getFileVersion(csmFile));
                document.putProperty(MACRO_EXPANSION_MACRO_TABLE, transformationTable);
            }
        }
        object = transformationTable;
        synchronized (object) {
            Document document2 = document;
            synchronized (document2) {
                transformationTable = this.getMacroTable(document);
                if (transformationTable.documentVersion != DocumentUtilities.getDocumentVersion((Document)document) || transformationTable.fileVersion != CsmFileInfoQuery.getDefault().getFileVersion(csmFile)) {
                    transformationTable = new TransformationTable(DocumentUtilities.getDocumentVersion((Document)document), CsmFileInfoQuery.getDefault().getFileVersion(csmFile));
                }
            }
            if (!transformationTable.isInited()) {
                this.expand(document, csmFile, transformationTable);
                transformationTable.cleanUp();
                document2 = document;
                synchronized (document2) {
                    document.putProperty(MACRO_EXPANSION_MACRO_TABLE, transformationTable);
                }
            }
        }
        return transformationTable;
    }

    private static class StopOnOffsetParseFileWalker
    extends APTParseFileWalker {
        private final int stopOffset;

        public StopOnOffsetParseFileWalker(ProjectBase projectBase, APTFile aPTFile, FileImpl fileImpl, int n, APTPreprocHandler aPTPreprocHandler, APTFileCacheEntry aPTFileCacheEntry) {
            super(projectBase, aPTFile, fileImpl, aPTPreprocHandler, false, null, aPTFileCacheEntry);
            this.stopOffset = n;
        }

        protected boolean onAPT(APT aPT, boolean bl) {
            if (aPT.getEndOffset() >= this.stopOffset) {
                this.stop();
                return false;
            }
            return super.onAPT(aPT, bl);
        }
    }

    private static class TransformationTable {
        private ArrayList<IntervalCorrespondence> intervals = new ArrayList();
        private Map<CharSequence, CharSequence> cache = new HashMap<CharSequence, CharSequence>();
        private Interval currentIn;
        private Interval currentOut;
        private final long documentVersion;
        private final long fileVersion;

        public TransformationTable(long l, long l2) {
            this.documentVersion = l;
            this.fileVersion = l2;
        }

        public void cleanUp() {
            this.cache = null;
        }

        public boolean isInited() {
            return this.cache == null;
        }

        public void setInStart(int n) {
            this.currentIn = new Interval(n);
        }

        public void setOutStart(int n) {
            this.currentOut = new Interval(n);
        }

        public void appendInterval(int n, int n2) {
            this.appendInterval(n, n2, false, null, null);
        }

        public void appendInterval(int n, int n2, boolean bl, String string, Map<Interval, List<Interval>> map) {
            assert (this.cache != null);
            CharSequence charSequence = CharSequences.create((CharSequence)string);
            CharSequence charSequence2 = this.cache.get(charSequence);
            if (charSequence2 != null) {
                charSequence = charSequence2;
            } else {
                this.cache.put(charSequence, charSequence);
            }
            this.currentIn.setLength(n);
            this.currentOut.setLength(n2);
            this.intervals.add(MacroExpansionDocProviderImpl.createIntervalCorrespondence(this.currentIn, this.currentOut, bl, charSequence, map));
            this.setInStart(this.currentIn.end);
            this.setOutStart(this.currentOut.end);
        }

        public int getOutOffset(int n) {
            if (this.intervals.isEmpty()) {
                return n;
            }
            if (this.intervals.get(0).getInInterval().start > n) {
                int n2 = this.intervals.get(0).getInInterval().start - n;
                return this.intervals.get(0).getOutInterval().start - n2;
            }
            IntervalCorrespondence intervalCorrespondence = null;
            for (IntervalCorrespondence intervalCorrespondence2 : this.intervals) {
                int n3;
                if (intervalCorrespondence2.getOutInterval().length() != 0) {
                    intervalCorrespondence = null;
                }
                if (intervalCorrespondence2.isMacro()) {
                    intervalCorrespondence = intervalCorrespondence2;
                }
                if (!intervalCorrespondence2.getInInterval().contains(n)) continue;
                if (intervalCorrespondence2.getOutInterval().length() == 0 && intervalCorrespondence != null) {
                    for (Interval interval : intervalCorrespondence.getParamsToExpansion().keySet()) {
                        Interval interval2;
                        if (!interval.contains(n)) continue;
                        int n4 = n - interval.start;
                        if (n4 >= (interval2 = intervalCorrespondence.getParamsToExpansion().get(interval).get(0)).length() || n4 >= interval2.length()) {
                            return interval2.end;
                        }
                        return interval2.start + n4;
                    }
                }
                if ((n3 = n - intervalCorrespondence2.getInInterval().start) >= intervalCorrespondence2.getInInterval().length() || n3 >= intervalCorrespondence2.getOutInterval().length()) {
                    return intervalCorrespondence2.getOutInterval().end;
                }
                if (intervalCorrespondence2.isMacro()) {
                    return intervalCorrespondence2.getOutInterval().start;
                }
                return intervalCorrespondence2.getOutInterval().start + n3;
            }
            int n5 = n - this.intervals.get(this.intervals.size() - 1).getInInterval().end;
            return this.intervals.get(this.intervals.size() - 1).getOutInterval().end + n5;
        }

        public int getInOffset(int n) {
            if (this.intervals.isEmpty()) {
                return n;
            }
            if (this.intervals.get(0).getOutInterval().start > n) {
                int n2 = this.intervals.get(0).getOutInterval().start - n;
                return this.intervals.get(0).getInInterval().start - n2;
            }
            for (IntervalCorrespondence intervalCorrespondence : this.intervals) {
                int n3;
                if (!intervalCorrespondence.getOutInterval().contains(n)) continue;
                if (intervalCorrespondence.isMacro()) {
                    for (Interval interval : intervalCorrespondence.getParamsToExpansion().keySet()) {
                        for (Interval interval2 : intervalCorrespondence.getParamsToExpansion().get(interval)) {
                            if (!interval2.contains(n)) continue;
                            int n4 = n - interval2.start;
                            if (n4 >= interval.length() || n4 >= interval2.length()) {
                                return interval.end;
                            }
                            return interval.start + n4;
                        }
                    }
                }
                if ((n3 = n - intervalCorrespondence.getOutInterval().start) >= intervalCorrespondence.getOutInterval().length() || n3 >= intervalCorrespondence.getInInterval().length()) {
                    return intervalCorrespondence.getInInterval().end;
                }
                if (intervalCorrespondence.isMacro()) {
                    return intervalCorrespondence.getInInterval().start;
                }
                return intervalCorrespondence.getInInterval().start + n3;
            }
            int n5 = n - this.intervals.get(this.intervals.size() - 1).getOutInterval().end;
            return this.intervals.get(this.intervals.size() - 1).getInInterval().end + n5;
        }

        public int getNextMacroExpansionStartOffset(int n) {
            if (this.intervals.isEmpty()) {
                return n;
            }
            for (IntervalCorrespondence intervalCorrespondence : this.intervals) {
                if (intervalCorrespondence.getOutInterval().start <= n || !intervalCorrespondence.isMacro()) continue;
                return intervalCorrespondence.getOutInterval().start;
            }
            return n;
        }

        public int getPrevMacroExpansionStartOffset(int n) {
            if (this.intervals.isEmpty()) {
                return n;
            }
            int n2 = n;
            for (IntervalCorrespondence intervalCorrespondence : this.intervals) {
                if (intervalCorrespondence.getOutInterval().end >= n) {
                    return n2;
                }
                if (!intervalCorrespondence.isMacro()) continue;
                n2 = intervalCorrespondence.getOutInterval().start;
            }
            return n;
        }

        public int findInIntervalIndex(int n) {
            return Collections.binarySearch(this.intervals, MacroExpansionDocProviderImpl.createIntervalCorrespondence(new Interval(n, n)), new Comparator<IntervalCorrespondence>(){

                @Override
                public int compare(IntervalCorrespondence intervalCorrespondence, IntervalCorrespondence intervalCorrespondence2) {
                    if (intervalCorrespondence.getInInterval().end < intervalCorrespondence2.getInInterval().start) {
                        return -1;
                    }
                    if (intervalCorrespondence.getInInterval().start > intervalCorrespondence2.getInInterval().end) {
                        return 1;
                    }
                    return 0;
                }
            });
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("");
            for (IntervalCorrespondence intervalCorrespondence : this.intervals) {
                stringBuilder.append("[" + intervalCorrespondence.getInInterval().start + "," + intervalCorrespondence.getInInterval().end + "] => [" + intervalCorrespondence.getOutInterval().start + "," + intervalCorrespondence.getOutInterval().end + "]\n");
            }
            return stringBuilder.toString();
        }
    }

    private static class IntervalCorrespondenceMacro
    extends IntervalCorrespondence {
        private final boolean macro;
        private final CharSequence macroExpansion;
        private final Map<Interval, List<Interval>> paramsToExpansion;

        private IntervalCorrespondenceMacro(Interval interval, Interval interval2, boolean bl, CharSequence charSequence, Map<Interval, List<Interval>> map) {
            super(interval, interval2);
            this.macro = bl;
            this.macroExpansion = charSequence;
            this.paramsToExpansion = map;
        }

        @Override
        public CharSequence getMacroExpansion() {
            return this.macroExpansion;
        }

        @Override
        public boolean isMacro() {
            return this.macro;
        }

        @Override
        public Map<Interval, List<Interval>> getParamsToExpansion() {
            return this.paramsToExpansion;
        }
    }

    private static class IntervalCorrespondenceSimple
    extends IntervalCorrespondence {
        private IntervalCorrespondenceSimple(Interval interval, Interval interval2) {
            super(interval, interval2);
        }

        @Override
        public boolean isMacro() {
            return false;
        }
    }

    private static abstract class IntervalCorrespondence {
        private final Interval inInterval;
        private final Interval outInterval;

        public IntervalCorrespondence(Interval interval, Interval interval2) {
            this.inInterval = interval;
            this.outInterval = interval2;
        }

        public CharSequence getMacroExpansion() {
            return null;
        }

        public Interval getInInterval() {
            return this.inInterval;
        }

        public Interval getOutInterval() {
            return this.outInterval;
        }

        public abstract boolean isMacro();

        public Map<Interval, List<Interval>> getParamsToExpansion() {
            return null;
        }

        public String toString() {
            return "IN:" + this.getInInterval() + " OUT:" + this.getOutInterval();
        }
    }

    private static class Interval {
        private final int start;
        private int end;

        public Interval(int n) {
            this.start = n;
            this.end = n;
        }

        public void setEnd(int n) {
            this.end = n;
        }

        public void setLength(int n) {
            this.end = this.start + n;
        }

        public Interval(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public Interval(Interval interval, int n) {
            this.start = interval.start + n;
            this.end = interval.end + n;
        }

        public int length() {
            return this.end - this.start;
        }

        public boolean contains(int n) {
            return this.start <= n && this.end >= n;
        }

        public boolean equals(Object object) {
            if (object instanceof Interval) {
                Interval interval = (Interval)object;
                return this.start == interval.start && this.end == interval.end;
            }
            return false;
        }

        public int hashCode() {
            int n = 7;
            n = 79 * n + this.start;
            n = 79 * n + this.end;
            return n;
        }

        public String toString() {
            return "[" + this.start + "-" + this.end + "]";
        }
    }

    private static class MyTokenSequence {
        private final TokenStream ts;
        private final FileImpl file;
        private APTToken currentToken = null;

        public MyTokenSequence(TokenStream tokenStream, FileImpl fileImpl) {
            this.ts = tokenStream;
            this.file = fileImpl;
            this.moveNext();
        }

        public APTToken token() {
            return this.currentToken;
        }

        public void moveNext() {
            try {
                this.currentToken = (APTToken)this.ts.nextToken();
            }
            catch (TokenStreamException tokenStreamException) {
                Exceptions.printStackTrace((Throwable)tokenStreamException);
            }
        }
    }
}

