/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml.lexer.api;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.rhtml.lexer.RhtmlLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum RhtmlTokenId implements TokenId
{
    HTML("html"),
    RUBYCOMMENT("comment"),
    RUBY_EXPR("ruby"),
    RUBY("ruby"),
    DELIMITER("ruby-delimiter");

    public static final String MIME_TYPE = "application/x-httpd-eruby";
    private final String primaryCategory;
    private static final Language<RhtmlTokenId> language;

    public static boolean isRuby(TokenId id) {
        return id == RUBY || id == RUBY_EXPR || id == RUBYCOMMENT;
    }

    private RhtmlTokenId(String primaryCategory) {
        this.primaryCategory = primaryCategory;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<RhtmlTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<RhtmlTokenId>(){

            protected Collection<RhtmlTokenId> createTokenIds() {
                return EnumSet.allOf(RhtmlTokenId.class);
            }

            protected Map<String, Collection<RhtmlTokenId>> createTokenCategories() {
                return null;
            }

            public Lexer<RhtmlTokenId> createLexer(LexerRestartInfo<RhtmlTokenId> info) {
                return new RhtmlLexer(info);
            }

            protected LanguageEmbedding<? extends TokenId> embedding(Token<RhtmlTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                switch ((RhtmlTokenId)token.id()) {
                    case HTML: {
                        return LanguageEmbedding.create((Language)HTMLTokenId.language(), (int)0, (int)0, (boolean)true);
                    }
                    case RUBY_EXPR: 
                    case RUBY: {
                        return LanguageEmbedding.create((Language)RubyTokenId.language(), (int)0, (int)0, (boolean)false);
                    }
                }
                return null;
            }

            public String mimeType() {
                return RhtmlTokenId.MIME_TYPE;
            }
        }.language();
    }
}

