/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyFile;
import org.jruby.RubyFileStat;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

@JRubyModule(name={"FileTest"})
public class RubyFileTest {
    public static RubyModule createFileTestModule(Ruby runtime2) {
        RubyModule fileTestModule = runtime2.defineModule("FileTest");
        runtime2.setFileTest(fileTestModule);
        fileTestModule.defineAnnotatedMethods(RubyFileTest.class);
        return fileTestModule;
    }

    @JRubyMethod(name={"blockdev?"}, required=1, module=true)
    public static IRubyObject blockdev_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isBlockDev());
    }

    @JRubyMethod(name={"chardev?"}, required=1, module=true)
    public static IRubyObject chardev_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isCharDev());
    }

    public static IRubyObject directory_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.directory_p(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    public static IRubyObject directory_p(Ruby ruby2, IRubyObject filename2) {
        return RubyFileTest.directory_p(ruby2.getCurrentContext(), filename2);
    }

    @JRubyMethod(name={"directory?"}, required=1, module=true)
    public static IRubyObject directory_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.directory_p(context, filename2);
    }

    public static IRubyObject directory_p(ThreadContext context, IRubyObject filename2) {
        ZipEntry entry;
        Ruby runtime2 = context.getRuntime();
        if (!(filename2 instanceof RubyFile)) {
            filename2 = RubyFile.get_path(context, filename2);
        }
        if ((entry = RubyFileTest.file_in_archive(filename2)) != null) {
            return entry.isDirectory() ? runtime2.getTrue() : runtime2.getFalse();
        }
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isDirectory());
    }

    @JRubyMethod(name={"executable?"}, required=1, module=true)
    public static IRubyObject executable_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isExecutable());
    }

    @JRubyMethod(name={"executable_real?"}, required=1, module=true)
    public static IRubyObject executable_real_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isExecutableReal());
    }

    public static IRubyObject exist_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.exist_p(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"exist?", "exists?"}, required=1, module=true)
    public static IRubyObject exist_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = context.getRuntime();
        if (!(filename2 instanceof RubyFile)) {
            filename2 = RubyFile.get_path(context, filename2);
        }
        if (RubyFileTest.existsOnClasspath(filename2)) {
            return runtime2.getTrue();
        }
        if (Ruby.isSecurityRestricted()) {
            return runtime2.getFalse();
        }
        if (RubyFileTest.file_in_archive(filename2) != null) {
            return runtime2.getTrue();
        }
        return runtime2.newBoolean(RubyFile.file(filename2).exists());
    }

    public static RubyBoolean file_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.file_p(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"file?"}, required=1, module=true)
    public static RubyBoolean file_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        ZipEntry entry;
        Ruby runtime2 = context.getRuntime();
        if (!(filename2 instanceof RubyFile)) {
            filename2 = RubyFile.get_path(context, filename2);
        }
        if ((entry = RubyFileTest.file_in_archive(filename2)) != null) {
            return entry.isDirectory() ? recv2.getRuntime().getFalse() : recv2.getRuntime().getTrue();
        }
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && file2.isFile());
    }

    @JRubyMethod(name={"grpowned?"}, required=1, module=true)
    public static IRubyObject grpowned_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        if (Platform.IS_WINDOWS) {
            return runtime2.getFalse();
        }
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isGroupOwned());
    }

    @JRubyMethod(name={"identical?"}, required=2, module=true)
    public static IRubyObject identical_p(IRubyObject recv2, IRubyObject filename1, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file1 = RubyFile.file(filename1);
        JRubyFile file2 = RubyFile.file(filename2);
        if (Platform.IS_WINDOWS) {
            try {
                return runtime2.newBoolean(file1.exists() && file2.exists() && file1.getCanonicalPath().equals(file2.getCanonicalPath()));
            }
            catch (IOException e) {
                return runtime2.getFalse();
            }
        }
        return runtime2.newBoolean(file1.exists() && file2.exists() && runtime2.getPosix().stat(file1.getAbsolutePath()).isIdentical(runtime2.getPosix().stat(file2.getAbsolutePath())));
    }

    @JRubyMethod(name={"owned?"}, required=1, module=true)
    public static IRubyObject owned_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isOwned());
    }

    @JRubyMethod(name={"pipe?"}, required=1, module=true)
    public static IRubyObject pipe_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isNamedPipe());
    }

    public static IRubyObject readable_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.readable_p(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"readable?", "readable_real?"}, required=1, module=true)
    public static IRubyObject readable_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        ZipEntry entry;
        Ruby runtime2 = context.getRuntime();
        if (!(filename2 instanceof RubyFile)) {
            filename2 = RubyFile.get_path(context, filename2);
        }
        if ((entry = RubyFileTest.file_in_archive(filename2)) != null) {
            return entry.isDirectory() ? recv2.getRuntime().getFalse() : recv2.getRuntime().getTrue();
        }
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && file2.canRead());
    }

    public static IRubyObject rowned_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isROwned());
    }

    @JRubyMethod(name={"setgid?"}, required=1, module=true)
    public static IRubyObject setgid_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isSetgid());
    }

    @JRubyMethod(name={"setuid?"}, required=1, module=true)
    public static IRubyObject setuid_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isSetuid());
    }

    public static IRubyObject size(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.size(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"size"}, required=1, module=true)
    public static IRubyObject size(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        ZipEntry entry;
        Ruby runtime2 = recv2.getRuntime();
        if (!(filename2 instanceof RubyFile)) {
            filename2 = RubyFile.get_path(context, filename2);
        }
        if ((entry = RubyFileTest.file_in_archive(filename2)) != null) {
            return runtime2.newFixnum(entry.getSize());
        }
        JRubyFile file2 = RubyFile.file(filename2);
        if (!file2.exists()) {
            RubyFileTest.noFileError(filename2);
        }
        return runtime2.newFixnum(file2.length());
    }

    public static IRubyObject size_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.size_p(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"size?"}, required=1, module=true)
    public static IRubyObject size_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        ZipEntry entry;
        Ruby runtime2 = context.getRuntime();
        if (!(filename2 instanceof RubyFile)) {
            filename2 = RubyFile.get_path(context, filename2);
        }
        if ((entry = RubyFileTest.file_in_archive(filename2)) != null) {
            long size2 = entry.getSize();
            if (size2 > 0L) {
                return runtime2.newFixnum(size2);
            }
            return runtime2.getNil();
        }
        JRubyFile file2 = RubyFile.file(filename2);
        if (!file2.exists()) {
            return runtime2.getNil();
        }
        long length2 = file2.length();
        if (length2 > 0L) {
            return runtime2.newFixnum(length2);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"socket?"}, required=1, module=true)
    public static IRubyObject socket_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isSocket());
    }

    @JRubyMethod(name={"sticky?"}, required=1, module=true)
    public static IRubyObject sticky_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        return runtime2.newBoolean(file2.exists() && runtime2.getPosix().stat(file2.getAbsolutePath()).isSticky());
    }

    @JRubyMethod(name={"symlink?"}, required=1, module=true)
    public static RubyBoolean symlink_p(IRubyObject recv2, IRubyObject filename2) {
        Ruby runtime2 = recv2.getRuntime();
        JRubyFile file2 = RubyFile.file(filename2);
        try {
            return runtime2.newBoolean(runtime2.getPosix().lstat(file2.getAbsolutePath()).isSymlink());
        }
        catch (SecurityException re) {
            return runtime2.getFalse();
        }
        catch (RaiseException re) {
            return runtime2.getFalse();
        }
    }

    @JRubyMethod(name={"writable?", "writable_real?"}, required=1, module=true)
    public static RubyBoolean writable_p(IRubyObject recv2, IRubyObject filename2) {
        return filename2.getRuntime().newBoolean(RubyFile.file(filename2).canWrite());
    }

    public static RubyBoolean zero_p(IRubyObject recv2, IRubyObject filename2) {
        return RubyFileTest.zero_p(recv2.getRuntime().getCurrentContext(), recv2, filename2);
    }

    @JRubyMethod(name={"zero?"}, required=1, module=true)
    public static RubyBoolean zero_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        ZipEntry entry;
        Ruby runtime2 = context.getRuntime();
        if (!(filename2 instanceof RubyFile)) {
            filename2 = RubyFile.get_path(context, filename2);
        }
        if ((entry = RubyFileTest.file_in_archive(filename2)) != null) {
            return runtime2.newBoolean(entry.getSize() == 0L);
        }
        JRubyFile file2 = RubyFile.file(filename2);
        if (file2.exists()) {
            if (file2.isDirectory()) {
                return runtime2.newBoolean(Platform.IS_WINDOWS);
            }
            return runtime2.newBoolean(file2.length() == 0L);
        }
        return runtime2.getFalse();
    }

    @JRubyMethod(name={"world_readable?"}, required=1, module=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject worldReadable(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        RubyFileStat stat2 = RubyFileTest.getFileStat(context, filename2);
        if (stat2 == null) {
            return context.getRuntime().getNil();
        }
        return stat2.worldReadable(context);
    }

    @JRubyMethod(name={"world_writable?"}, required=1, module=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject worldWritable(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        RubyFileStat stat2 = RubyFileTest.getFileStat(context, filename2);
        if (stat2 == null) {
            return context.getRuntime().getNil();
        }
        return stat2.worldWritable(context);
    }

    private static RubyFileStat getFileStat(ThreadContext context, IRubyObject filename2) {
        Ruby runtime2 = context.getRuntime();
        RubyFileStat stat2 = null;
        if (!(filename2 instanceof RubyFile)) {
            RubyString path2 = RubyFile.get_path(context, filename2);
            JRubyFile file2 = JRubyFile.create(runtime2.getCurrentDirectory(), path2.getUnicodeValue());
            if (file2.exists()) {
                stat2 = runtime2.newFileStat(file2.getPath(), false);
            }
        } else {
            stat2 = (RubyFileStat)((RubyFile)filename2).stat(context);
        }
        return stat2;
    }

    private static ZipEntry file_in_archive(IRubyObject path2) {
        Ruby runtime2 = path2.getRuntime();
        if (path2 instanceof RubyFile) {
            return null;
        }
        RubyString pathStr = RubyFile.get_path(runtime2.getCurrentContext(), path2);
        String pathJStr = pathStr.getUnicodeValue();
        if (pathJStr.startsWith("jar:")) {
            pathJStr = pathJStr.substring(4);
        }
        if (pathJStr.startsWith("file:")) {
            String file2 = pathJStr.substring(5);
            int bang = file2.indexOf(33);
            if (bang == -1 || bang == file2.length() - 1) {
                return null;
            }
            String jar = file2.substring(0, bang);
            String after = file2.substring(bang + 2);
            try {
                JarFile jf = new JarFile(jar);
                ZipEntry entry = RubyFile.getDirOrFileEntry(jf, after);
                return entry;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean existsOnClasspath(IRubyObject path2) {
        if (path2 instanceof RubyFile) {
            return false;
        }
        Ruby runtime2 = path2.getRuntime();
        RubyString pathStr = RubyFile.get_path(runtime2.getCurrentContext(), path2);
        String pathJStr = pathStr.getUnicodeValue();
        if (pathJStr.startsWith("classpath:/")) {
            InputStream is;
            pathJStr = pathJStr.substring("classpath:/".length());
            ClassLoader classLoader = runtime2.getJRubyClassLoader();
            if (Ruby.isSecurityRestricted() && classLoader == null) {
                classLoader = runtime2.getInstanceConfig().getLoader();
            }
            if ((is = ((ClassLoader)classLoader).getResourceAsStream(pathJStr)) != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {
                }
                catch (NullPointerException wtf) {
                    // empty catch block
                }
                return true;
            }
        }
        return false;
    }

    private static void noFileError(IRubyObject filename2) {
        throw filename2.getRuntime().newErrnoENOENTError("No such file or directory - " + filename2.convertToString());
    }

    public static class FileTestFileMethods {
        @JRubyMethod(name={"blockdev?"}, required=1)
        public static IRubyObject blockdev_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.blockdev_p(recv2, filename2);
        }

        @JRubyMethod(name={"chardev?"}, required=1)
        public static IRubyObject chardev_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.chardev_p(recv2, filename2);
        }

        @JRubyMethod(name={"directory?"}, required=1)
        public static IRubyObject directory_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.directory_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"executable?"}, required=1)
        public static IRubyObject executable_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.executable_p(recv2, filename2);
        }

        @JRubyMethod(name={"executable_real?"}, required=1)
        public static IRubyObject executable_real_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.executable_real_p(recv2, filename2);
        }

        @JRubyMethod(name={"exist?", "exists?"}, required=1)
        public static IRubyObject exist_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.exist_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"file?"}, required=1)
        public static RubyBoolean file_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.file_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"grpowned?"}, required=1)
        public static IRubyObject grpowned_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.grpowned_p(recv2, filename2);
        }

        @JRubyMethod(name={"identical?"}, required=2)
        public static IRubyObject identical_p(IRubyObject recv2, IRubyObject filename1, IRubyObject filename2) {
            return RubyFileTest.identical_p(recv2, filename1, filename2);
        }

        @JRubyMethod(name={"owned?"}, required=1)
        public static IRubyObject owned_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.owned_p(recv2, filename2);
        }

        @JRubyMethod(name={"pipe?"}, required=1)
        public static IRubyObject pipe_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.pipe_p(recv2, filename2);
        }

        @JRubyMethod(name={"readable?", "readable_real?"}, required=1)
        public static IRubyObject readable_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.readable_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"setgid?"}, required=1)
        public static IRubyObject setgid_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.setgid_p(recv2, filename2);
        }

        @JRubyMethod(name={"setuid?"}, required=1)
        public static IRubyObject setuid_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.setuid_p(recv2, filename2);
        }

        @JRubyMethod(name={"size"}, required=1)
        public static IRubyObject size(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.size(context, recv2, filename2);
        }

        @JRubyMethod(name={"size?"}, required=1)
        public static IRubyObject size_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.size_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"socket?"}, required=1)
        public static IRubyObject socket_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.socket_p(recv2, filename2);
        }

        @JRubyMethod(name={"sticky?"}, required=1)
        public static IRubyObject sticky_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.sticky_p(recv2, filename2);
        }

        @JRubyMethod(name={"symlink?"}, required=1)
        public static RubyBoolean symlink_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.symlink_p(recv2, filename2);
        }

        @JRubyMethod(name={"writable?", "writable_real?"}, required=1)
        public static RubyBoolean writable_p(IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.writable_p(recv2, filename2);
        }

        @JRubyMethod(name={"zero?"}, required=1)
        public static RubyBoolean zero_p(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.zero_p(context, recv2, filename2);
        }

        @JRubyMethod(name={"world_readable?"}, required=1, compat=CompatVersion.RUBY1_9)
        public static IRubyObject worldReadable(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.worldReadable(context, recv2, filename2);
        }

        @JRubyMethod(name={"world_writable?"}, required=1, compat=CompatVersion.RUBY1_9)
        public static IRubyObject worldWritable(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
            return RubyFileTest.worldWritable(context, recv2, filename2);
        }
    }
}

