/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.Alias;
import com.martiansoftware.nailgun.AliasManager;
import com.martiansoftware.nailgun.NGSecurityManager;
import com.martiansoftware.nailgun.NGSession;
import com.martiansoftware.nailgun.NGSessionPool;
import com.martiansoftware.nailgun.NailStats;
import com.martiansoftware.nailgun.ThreadLocalInputStream;
import com.martiansoftware.nailgun.ThreadLocalPrintStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class NGServer
implements Runnable {
    private InetAddress addr = null;
    private int port = 0;
    private ServerSocket serversocket;
    private boolean shutdown = false;
    private boolean running = false;
    private AliasManager aliasManager;
    private boolean allowNailsByClassName = true;
    private Class defaultNailClass = null;
    private NGSessionPool sessionPool = null;
    public final PrintStream out = System.out;
    public final PrintStream err = System.err;
    public final InputStream in = System.in;
    private Map allNailStats = null;
    private SecurityManager originalSecurityManager = null;
    static /* synthetic */ Class class$com$martiansoftware$nailgun$builtins$DefaultNail;
    static /* synthetic */ Class class$com$martiansoftware$nailgun$NGServer;

    public NGServer(InetAddress inetAddress, int n) {
        this.init(inetAddress, n);
    }

    public NGServer() {
        this.init(null, 2113);
    }

    private void init(InetAddress inetAddress, int n) {
        this.addr = inetAddress;
        this.port = n;
        this.aliasManager = new AliasManager();
        this.allNailStats = new HashMap();
        this.sessionPool = new NGSessionPool(this, 10);
    }

    public void setAllowNailsByClassName(boolean bl) {
        this.allowNailsByClassName = bl;
    }

    public boolean allowsNailsByClassName() {
        return this.allowNailsByClassName;
    }

    public void setDefaultNailClass(Class clazz) {
        this.defaultNailClass = clazz;
    }

    public Class getDefaultNailClass() {
        Class clazz = this.defaultNailClass == null ? (class$com$martiansoftware$nailgun$builtins$DefaultNail == null ? (class$com$martiansoftware$nailgun$builtins$DefaultNail = NGServer.class$("com.martiansoftware.nailgun.builtins.DefaultNail")) : class$com$martiansoftware$nailgun$builtins$DefaultNail) : this.defaultNailClass;
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NailStats getOrCreateStatsFor(Class clazz) {
        NailStats nailStats = null;
        Map map = this.allNailStats;
        synchronized (map) {
            nailStats = (NailStats)this.allNailStats.get(clazz);
            if (nailStats == null) {
                nailStats = new NailStats(clazz);
                this.allNailStats.put(clazz, nailStats);
            }
        }
        return nailStats;
    }

    void nailStarted(Class clazz) {
        NailStats nailStats = this.getOrCreateStatsFor(clazz);
        nailStats.nailStarted();
    }

    void nailFinished(Class clazz) {
        NailStats nailStats = (NailStats)this.allNailStats.get(clazz);
        nailStats.nailFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getNailStats() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        Map map = this.allNailStats;
        synchronized (map) {
            Iterator iterator = this.allNailStats.keySet().iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                treeMap.put(clazz.getName(), ((NailStats)this.allNailStats.get(clazz)).clone());
            }
        }
        return treeMap;
    }

    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        Class[] classArray = this;
        synchronized (this) {
            Object object;
            if (this.shutdown) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.shutdown = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                this.serversocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.sessionPool.shutdown();
            classArray = new Class[]{class$com$martiansoftware$nailgun$NGServer == null ? (class$com$martiansoftware$nailgun$NGServer = NGServer.class$("com.martiansoftware.nailgun.NGServer")) : class$com$martiansoftware$nailgun$NGServer};
            Object[] objectArray = new Object[]{this};
            Object object2 = this.getAliasManager().getAliases().iterator();
            while (object2.hasNext()) {
                object = (Alias)object2.next();
                super.getOrCreateStatsFor(((Alias)object).getAliasedClass());
            }
            object2 = this.allNailStats;
            synchronized (object2) {
                object = this.allNailStats.values().iterator();
                while (object.hasNext()) {
                    NailStats nailStats = (NailStats)object.next();
                    Class clazz = nailStats.getNailClass();
                    try {
                        Method method2 = clazz.getMethod("nailShutdown", classArray);
                        method2.invoke(null, objectArray);
                    }
                    catch (Throwable throwable) {}
                }
            }
            System.setIn(this.in);
            System.setOut(this.out);
            System.setErr(this.err);
            System.setSecurityManager(this.originalSecurityManager);
            if (bl) {
                System.exit(0);
            }
            return;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPort() {
        return this.serversocket == null ? this.port : this.serversocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        NGSession nGSession;
        block8: {
            this.running = true;
            nGSession = null;
            this.originalSecurityManager = System.getSecurityManager();
            System.setSecurityManager(new NGSecurityManager(this.originalSecurityManager));
            Closeable closeable = System.in;
            synchronized (closeable) {
                if (!(System.in instanceof ThreadLocalInputStream)) {
                    System.setIn(new ThreadLocalInputStream(this.in));
                    System.setOut(new ThreadLocalPrintStream(this.out));
                    System.setErr(new ThreadLocalPrintStream(this.err));
                }
            }
            try {
                this.serversocket = this.addr == null ? new ServerSocket(this.port) : new ServerSocket(this.port, 0, this.addr);
                while (!this.shutdown) {
                    nGSession = this.sessionPool.take();
                    closeable = this.serversocket.accept();
                    nGSession.run((Socket)closeable);
                }
            }
            catch (Throwable throwable) {
                if (this.shutdown) break block8;
                throwable.printStackTrace();
            }
        }
        if (nGSession != null) {
            nGSession.shutdown();
        }
        this.running = false;
    }

    private static void usage() {
        System.err.println("Usage: java com.martiansoftware.nailgun.NGServer");
        System.err.println("   or: java com.martiansoftware.nailgun.NGServer port");
        System.err.println("   or: java com.martiansoftware.nailgun.NGServer IPAddress");
        System.err.println("   or: java com.martiansoftware.nailgun.NGServer IPAddress:port");
    }

    public static void main(String[] stringArray) throws NumberFormatException, UnknownHostException {
        Object object;
        Object object2;
        if (stringArray.length > 1) {
            NGServer.usage();
            return;
        }
        InetAddress inetAddress = null;
        int n = 2113;
        if (stringArray.length != 0) {
            object2 = stringArray[0].split(":");
            object = null;
            String string2 = null;
            if (((String[])object2).length == 2) {
                object = object2[0];
                string2 = object2[1];
            } else if (object2[0].indexOf(46) >= 0) {
                object = object2[0];
            } else {
                string2 = object2[0];
            }
            if (object != null) {
                inetAddress = InetAddress.getByName((String)object);
            }
            if (string2 != null) {
                n = Integer.parseInt(string2);
            }
        }
        object2 = new NGServer(inetAddress, n);
        object = new Thread((Runnable)object2);
        ((Thread)object).setName("NGServer(" + inetAddress + ", " + n + ")");
        ((Thread)object).start();
        Runtime.getRuntime().addShutdownHook(new NGServerShutdowner((NGServer)object2));
        int n2 = ((NGServer)object2).getPort();
        while (n2 == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            n2 = ((NGServer)object2).getPort();
        }
        System.out.println("NGServer started on " + (inetAddress == null ? "all interfaces" : inetAddress.getHostAddress()) + ", port " + n2 + ".");
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class NGServerShutdowner
    extends Thread {
        private NGServer server = null;

        NGServerShutdowner(NGServer nGServer) {
            this.server = nGServer;
        }

        public void run() {
            this.server.shutdown(false);
            for (int j = 0; this.server.isRunning() && j < 50; ++j) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.server.isRunning()) {
                System.err.println("Unable to cleanly shutdown server.  Exiting JVM Anyway.");
            } else {
                System.out.println("NGServer shut down.");
            }
        }
    }
}

