/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.tools.example.debug.gui.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceModel
extends AbstractListModel {
    private File path;
    boolean isActuallySource = true;
    private List<ReferenceType> classes = new ArrayList<ReferenceType>();
    private Environment env;
    private List<Line> sourceLines = null;
    public static final Line prototypeCellValue = new Line("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+{}|:<>?`-=[];',.XXXXXXXXXXXX/\\\"");

    SourceModel(Environment environment, File file) {
        this.env = environment;
        this.path = file;
    }

    public SourceModel(String string) {
        this.path = null;
        this.setMessage(string);
    }

    private void setMessage(String string) {
        this.isActuallySource = false;
        this.sourceLines = new ArrayList<Line>();
        this.sourceLines.add(new Line(string));
    }

    @Override
    public Object getElementAt(int n) {
        if (this.sourceLines == null) {
            this.initialize();
        }
        return this.sourceLines.get(n);
    }

    @Override
    public int getSize() {
        if (this.sourceLines == null) {
            this.initialize();
        }
        return this.sourceLines.size();
    }

    public File fileName() {
        return this.path;
    }

    public BufferedReader sourceReader() throws IOException {
        return new BufferedReader(new FileReader(this.path));
    }

    public Line line(int n) {
        int n2;
        if (this.sourceLines == null) {
            this.initialize();
        }
        if ((n2 = n - 1) >= this.sourceLines.size() || n2 < 0) {
            return null;
        }
        return this.sourceLines.get(n2);
    }

    public String sourceLine(int n) {
        Line line = this.line(n);
        if (line == null) {
            return null;
        }
        return line.text;
    }

    void addClass(ReferenceType referenceType) {
        if (this.classes.indexOf(referenceType) == -1) {
            this.classes.add(referenceType);
            if (this.sourceLines != null) {
                this.markClassLines(referenceType);
            }
        }
    }

    public List<ReferenceType> referenceTypes() {
        return Collections.unmodifiableList(this.classes);
    }

    private void initialize() {
        try {
            this.rawInit();
        }
        catch (IOException iOException) {
            this.setMessage("[Error reading source code]");
        }
    }

    public void showBreakpoint(int n, boolean bl) {
        this.line((int)n).hasBreakpoint = bl;
        this.fireContentsChanged(this, n, n);
    }

    public void showExecutable(int n, ReferenceType referenceType) {
        this.line((int)n).refType = referenceType;
        this.fireContentsChanged(this, n, n);
    }

    private void markClassLines(ReferenceType referenceType) {
        Object object;
        Object absentInformationException;
        List<Method> list = referenceType.methods();
        for (Method object32 : list) {
            try {
                absentInformationException = object32.allLineLocations();
                object = absentInformationException.iterator();
                while (object.hasNext()) {
                    Location location = object.next();
                    this.showExecutable(location.lineNumber(), referenceType);
                }
            }
            catch (AbsentInformationException absentInformationException2) {
            }
        }
        List<BreakpointRequest> list2 = this.env.getExecutionManager().eventRequestManager().breakpointRequests();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            absentInformationException = (BreakpointRequest)iterator.next();
            if (absentInformationException.location() == null || !((Object)(object = absentInformationException.location()).declaringType()).equals(referenceType)) continue;
            this.showBreakpoint(object.lineNumber(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rawInit() throws IOException {
        Object object;
        this.sourceLines = new ArrayList<Line>();
        BufferedReader bufferedReader = this.sourceReader();
        try {
            object = bufferedReader.readLine();
            while (object != null) {
                this.sourceLines.add(new Line(this.expandTabs((String)object)));
                object = bufferedReader.readLine();
            }
        }
        finally {
            bufferedReader.close();
        }
        object = this.classes.iterator();
        while (object.hasNext()) {
            this.markClassLines((ClassType)object.next());
        }
    }

    private String expandTabs(String string) {
        int n = 0;
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(132);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (c == '\t') {
                int n3 = 8 - n % 8;
                for (int j = 0; j < n3; ++j) {
                    stringBuffer.append(' ');
                }
                n += n3;
                continue;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static class Line {
        public String text;
        public boolean hasBreakpoint = false;
        public ReferenceType refType = null;

        Line(String string) {
            this.text = string;
        }

        public boolean isExecutable() {
            return this.refType != null;
        }

        public boolean hasBreakpoint() {
            return this.hasBreakpoint;
        }
    }
}

