/*
 * Decompiled with CFR 0.152.
 */
package com.sun.inputmethods.internal.thaiim;

import com.sun.inputmethods.internal.thaiim.ThaiRules;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.spi.InputMethodContext;
import java.text.AttributedString;

class ThaiInputMethodImpl {
    private static final char[] keyboardMap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '\u0e45', '.', '\u0e52', '\u0e53', '\u0e54', '\u0e4e', '\u0e07', '\u0e56', '\u0e57', '\u0e55', '\u0e59', '\u0e21', '\u0e02', '\u0e43', '\u0e1d', '\u0e08', '\u0e3f', '/', '-', '\u0e20', '\u0e16', '\u0e38', '\u0e36', '\u0e04', '\u0e15', '\u0e0b', '\u0e27', '\u0e12', '\u0e0a', '\u0e2c', '\u0e26', '\u0e51', '\u0e24', '\u0e3a', '\u0e09', '\u0e0f', '\u0e0e', '\u0e42', '\u0e0c', '\u0e47', '\u0e13', '\u0e4b', '\u0e29', '\u0e28', '?', '\u0e4c', '\u0e2f', '\u0e0d', '\u0e50', '\u0e11', '\u0e06', '\u0e18', '\u0e4a', '\u0e2e', '\"', ')', '\u0e4d', '(', '\u0e1a', '\u0e05', '\u0e25', '\u0e39', '\u0e58', '\u0e4f', '\u0e1f', '\u0e34', '\u0e41', '\u0e01', '\u0e33', '\u0e14', '\u0e40', '\u0e49', '\u0e23', '\u0e48', '\u0e32', '\u0e2a', '\u0e17', '\u0e37', '\u0e19', '\u0e22', '\u0e46', '\u0e1e', '\u0e2b', '\u0e30', '\u0e35', '\u0e2d', '\u0e44', '\u0e1b', '\u0e31', '\u0e1c', '\u0e10', '\u0e03', ',', '\u0e5b', '\u007f'};
    private static final TextHitInfo ZERO_TRAILING_HIT_INFO = TextHitInfo.trailing(0);
    private ThaiRules rules;
    private InputMethodContext context;

    ThaiInputMethodImpl() {
    }

    private char getMappedChar(char c) {
        if (c <= keyboardMap.length) {
            return keyboardMap[c];
        }
        return c;
    }

    void setInputMethodContext(InputMethodContext inputMethodContext) {
        this.context = inputMethodContext;
        this.rules = new ThaiRules(inputMethodContext);
    }

    void handleKeyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        char c2 = this.getMappedChar(c);
        if (!Character.UnicodeBlock.THAI.equals(Character.UnicodeBlock.of(c2))) {
            return;
        }
        if (this.rules.isInputValid(c2)) {
            Character c3 = new Character(c2);
            String string = c3.toString();
            this.context.dispatchInputMethodEvent(1100, new AttributedString(string).getIterator(), 1, ZERO_TRAILING_HIT_INFO, ZERO_TRAILING_HIT_INFO);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        keyEvent.consume();
    }

    void endComposition() {
    }
}

