/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import sun.tools.jconsole.inspector.XObject;
import sun.tools.jconsole.inspector.XTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static Set<Integer> tableNavigationKeys;
    private static final Set<Class<?>> primitiveWrappers;
    private static final Set<Class<?>> primitives;
    private static final Map<String, Class<?>> primitiveMap;
    private static final Map<String, Class<?>> primitiveToWrapper;
    private static final Set<String> editableTypes;
    private static final Set<Class<?>> extraEditableClasses;
    private static final Set<String> numericalTypes;
    private static final Set<String> extraNumericalTypes;
    private static final Set<String> booleanTypes;

    private Utils() {
    }

    public static Class<?> getClass(String string) throws ClassNotFoundException {
        Class<?> clazz = primitiveMap.get(string);
        if (clazz != null) {
            return clazz;
        }
        return Class.forName(string);
    }

    public static boolean isUniformCollection(Collection<?> collection, Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null reference type");
        }
        if (collection == null) {
            throw new IllegalArgumentException("Null collection");
        }
        if (collection.isEmpty()) {
            return false;
        }
        for (Object obj : collection) {
            if (obj != null && clazz.isAssignableFrom(obj.getClass())) continue;
            return false;
        }
        return true;
    }

    public static boolean canBeRenderedAsArray(Object object) {
        if (Utils.isSupportedArray(object)) {
            return true;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                return false;
            }
            return !Utils.isUniformCollection(collection, CompositeData.class) && !Utils.isUniformCollection(collection, TabularData.class);
        }
        if (object instanceof Map) {
            return !(object instanceof TabularData);
        }
        return false;
    }

    public static boolean isSupportedArray(Object object) {
        if (object == null || !object.getClass().isArray()) {
            return false;
        }
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz.isArray()) {
            return false;
        }
        return Array.getLength(object) <= 0 || !CompositeData.class.isAssignableFrom(clazz) && !TabularData.class.isAssignableFrom(clazz);
    }

    public static String getArrayClassName(String string) {
        String string2 = null;
        if (string.startsWith("[")) {
            int n = string.lastIndexOf("[");
            string2 = string.substring(n, string.length());
            if (string2.startsWith("[L")) {
                string2 = string2.substring(2, string2.length() - 1);
            } else {
                try {
                    Class<?> clazz = Class.forName(string2);
                    string2 = clazz.getComponentType().getName();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException("Bad class name " + string, classNotFoundException);
                }
            }
        }
        return string2;
    }

    public static String getReadableClassName(String string) {
        String string2 = Utils.getArrayClassName(string);
        if (string2 == null) {
            return string;
        }
        int n = string.lastIndexOf("[");
        StringBuilder stringBuilder = new StringBuilder(string2);
        for (int i = 0; i <= n; ++i) {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    public static boolean isEditableType(String string) {
        return editableTypes.contains(string);
    }

    public static String getDefaultValue(String string) {
        if (numericalTypes.contains(string) || extraNumericalTypes.contains(string)) {
            return "0";
        }
        if (booleanTypes.contains(string)) {
            return "true";
        }
        int n = (string = Utils.getReadableClassName(string)).lastIndexOf(46);
        if (n > 0) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    public static Object newStringConstructor(String string, String string2) throws Exception {
        Constructor<?> constructor = Utils.getClass(string).getConstructor(String.class);
        try {
            return constructor.newInstance(string2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw invocationTargetException;
        }
    }

    private static Number createNumberFromStringValue(String string) throws NumberFormatException {
        String string2 = string.substring(string.length() - 1);
        if ("L".equalsIgnoreCase(string2)) {
            return Long.valueOf(string.substring(0, string.length() - 1));
        }
        if ("F".equalsIgnoreCase(string2)) {
            return Float.valueOf(string.substring(0, string.length() - 1));
        }
        if ("D".equalsIgnoreCase(string2)) {
            return Double.valueOf(string.substring(0, string.length() - 1));
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException3) {
                    throw new NumberFormatException("Cannot convert string value '" + string + "' into a numerical value");
                }
            }
        }
    }

    public static Object createObjectFromString(String string, String string2) throws Exception {
        Object object = primitiveToWrapper.containsKey(string) ? (string.equals(Character.TYPE.getName()) ? new Character(string2.charAt(0)) : Utils.newStringConstructor(primitiveToWrapper.get(string).getName(), string2)) : (string.equals(Character.class.getName()) ? new Character(string2.charAt(0)) : (Number.class.isAssignableFrom(Utils.getClass(string)) ? Utils.createNumberFromStringValue(string2) : (string2 == null || string2.toString().equals("null") ? null : Utils.newStringConstructor(string, string2))));
        return object;
    }

    public static Object[] getParameters(XTextField[] xTextFieldArray, String[] stringArray) throws Exception {
        Object[] objectArray = new Object[xTextFieldArray.length];
        for (int i = 0; i < xTextFieldArray.length; ++i) {
            Object object = xTextFieldArray[i].getValue();
            objectArray[i] = object instanceof XObject ? ((XObject)object).getObject() : Utils.createObjectFromString(stringArray[i].toString(), (String)object);
        }
        return objectArray;
    }

    public static Throwable getActualException(Throwable throwable) {
        Throwable throwable2;
        if ((throwable instanceof MBeanException || throwable instanceof RuntimeMBeanException || throwable instanceof RuntimeOperationsException || throwable instanceof ReflectionException) && (throwable2 = throwable.getCause()) != null) {
            return throwable2;
        }
        return throwable;
    }

    static {
        Object object;
        tableNavigationKeys = new HashSet<Integer>(Arrays.asList(9, 10, 36, 35, 37, 39, 38, 40, 33, 34));
        primitiveWrappers = new HashSet<Class>(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Boolean.class));
        primitives = new HashSet();
        primitiveMap = new HashMap();
        primitiveToWrapper = new HashMap();
        editableTypes = new HashSet<String>();
        extraEditableClasses = new HashSet<Class>(Arrays.asList(BigDecimal.class, BigInteger.class, Number.class, String.class, ObjectName.class));
        numericalTypes = new HashSet<String>();
        extraNumericalTypes = new HashSet<String>(Arrays.asList(BigDecimal.class.getName(), BigInteger.class.getName(), Number.class.getName()));
        booleanTypes = new HashSet<String>(Arrays.asList(Boolean.TYPE.getName(), Boolean.class.getName()));
        for (Class<?> clazz : primitiveWrappers) {
            try {
                object = clazz.getField("TYPE");
                Class clazz2 = (Class)((Field)object).get(null);
                primitives.add(clazz2);
                primitiveMap.put(clazz2.getName(), clazz2);
                primitiveToWrapper.put(clazz2.getName(), clazz);
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
        }
        for (Class<?> clazz : primitives) {
            editableTypes.add(clazz.getName());
        }
        for (Class<?> clazz : primitiveWrappers) {
            editableTypes.add(clazz.getName());
        }
        for (Class<?> clazz : extraEditableClasses) {
            editableTypes.add(clazz.getName());
        }
        for (Class<?> clazz : primitives) {
            object = clazz.getName();
            if (((String)object).equals(Boolean.TYPE.getName())) continue;
            numericalTypes.add((String)object);
        }
        for (Class<?> clazz : primitiveWrappers) {
            object = clazz.getName();
            if (((String)object).equals(Boolean.class.getName())) continue;
            numericalTypes.add((String)object);
        }
    }

    public static class CopyKeyAdapter
    extends KeyAdapter {
        private static final String defaultEditorKitCopyActionName = "copy-to-clipboard";
        private static final String transferHandlerCopyActionName = (String)TransferHandler.getCopyAction().getValue("Name");

        public void keyPressed(KeyEvent keyEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
            JComponent jComponent = (JComponent)keyEvent.getSource();
            for (int i = 0; i < 3; ++i) {
                InputMap inputMap = jComponent.getInputMap(i);
                Object object = inputMap.get(keyStroke);
                if (!defaultEditorKitCopyActionName.equals(object) && !transferHandlerCopyActionName.equals(object)) continue;
                return;
            }
            if (!tableNavigationKeys.contains(keyEvent.getKeyCode())) {
                keyEvent.consume();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            keyEvent.consume();
        }
    }

    public static class EditFocusAdapter
    extends FocusAdapter {
        private CellEditor editor;

        public EditFocusAdapter(CellEditor cellEditor) {
            this.editor = cellEditor;
        }

        public void focusLost(FocusEvent focusEvent) {
            this.editor.stopCellEditing();
        }
    }

    public static class ReadOnlyTableCellEditor
    extends DefaultCellEditor {
        public ReadOnlyTableCellEditor(JTextField jTextField) {
            super(jTextField);
            jTextField.addFocusListener(new EditFocusAdapter(this));
            jTextField.addKeyListener(new CopyKeyAdapter());
        }
    }
}

