/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.plaf.synth;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthFileChooserUIImpl;
import sun.swing.plaf.synth.SynthUI;

public abstract class SynthFileChooserUI
extends BasicFileChooserUI
implements SynthUI {
    private JButton approveButton;
    private JButton cancelButton;
    private SynthStyle style;
    private Action fileNameCompletionAction = new FileNameCompletionAction();
    private FileFilter actualFileFilter = null;
    private GlobFilter globFilter = null;
    private String fileNameCompletionString;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthFileChooserUIImpl((JFileChooser)jComponent);
    }

    public SynthFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return new SynthContext(jComponent, Region.FILE_CHOOSER, this.style, this.getComponentState(jComponent));
    }

    protected SynthContext getContext(JComponent jComponent, int n) {
        Region region = SynthLookAndFeel.getRegion(jComponent);
        return new SynthContext(jComponent, Region.FILE_CHOOSER, this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        if (jComponent.isEnabled()) {
            if (jComponent.isFocusOwner()) {
                return 257;
            }
            return 1;
        }
        return 8;
    }

    private void updateStyle(JComponent jComponent) {
        SynthStyle synthStyle = SynthLookAndFeel.getStyleFactory().getStyle(jComponent, Region.FILE_CHOOSER);
        if (synthStyle != this.style) {
            if (this.style != null) {
                this.style.uninstallDefaults(this.getContext(jComponent, 1));
            }
            this.style = synthStyle;
            SynthContext synthContext = this.getContext(jComponent, 1);
            this.style.installDefaults(synthContext);
            Border border = jComponent.getBorder();
            if (border == null || border instanceof UIResource) {
                jComponent.setBorder(new UIBorder(this.style.getInsets(synthContext, null)));
            }
            this.directoryIcon = this.style.getIcon(synthContext, "FileView.directoryIcon");
            this.fileIcon = this.style.getIcon(synthContext, "FileView.fileIcon");
            this.computerIcon = this.style.getIcon(synthContext, "FileView.computerIcon");
            this.hardDriveIcon = this.style.getIcon(synthContext, "FileView.hardDriveIcon");
            this.floppyDriveIcon = this.style.getIcon(synthContext, "FileView.floppyDriveIcon");
            this.newFolderIcon = this.style.getIcon(synthContext, "FileChooser.newFolderIcon");
            this.upFolderIcon = this.style.getIcon(synthContext, "FileChooser.upFolderIcon");
            this.homeFolderIcon = this.style.getIcon(synthContext, "FileChooser.homeFolderIcon");
            this.detailsViewIcon = this.style.getIcon(synthContext, "FileChooser.detailsViewIcon");
            this.listViewIcon = this.style.getIcon(synthContext, "FileChooser.listViewIcon");
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtilities.replaceUIActionMap(jComponent, this.createActionMap());
    }

    @Override
    public void installComponents(JFileChooser jFileChooser) {
        SynthContext synthContext = this.getContext(jFileChooser, 1);
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setName("SynthFileChooser.cancelButton");
        this.cancelButton.setIcon(synthContext.getStyle().getIcon(synthContext, "FileChooser.cancelIcon"));
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser));
        this.approveButton.setName("SynthFileChooser.approveButton");
        this.approveButton.setIcon(synthContext.getStyle().getIcon(synthContext, "FileChooser.okIcon"));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
    }

    @Override
    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
    }

    @Override
    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
    }

    protected abstract ActionMap createActionMap();

    @Override
    protected void installDefaults(JFileChooser jFileChooser) {
        super.installDefaults(jFileChooser);
        this.updateStyle(jFileChooser);
    }

    @Override
    protected void uninstallDefaults(JFileChooser jFileChooser) {
        super.uninstallDefaults(jFileChooser);
        SynthContext synthContext = this.getContext(this.getFileChooser(), 1);
        this.style.uninstallDefaults(synthContext);
        this.style = null;
    }

    @Override
    protected void installIcons(JFileChooser jFileChooser) {
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        if (jComponent.isOpaque()) {
            graphics.setColor(this.style.getColor(synthContext, ColorType.BACKGROUND));
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.style.getPainter(synthContext).paintFileChooserBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    @Override
    public abstract void setFileName(String var1);

    @Override
    public abstract String getFileName();

    protected void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (!this.getFileChooser().isMultiSelectionEnabled()) {
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    protected void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.approveButton.setText(this.getApproveButtonText(this.getFileChooser()));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.getFileChooser()));
        }
    }

    protected void doAncestorChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new SynthFCPropertyChangeListener();
    }

    private void updateFileNameCompletion() {
        if (this.fileNameCompletionString != null && this.fileNameCompletionString.equals(this.getFileName())) {
            File[] fileArray = this.getModel().getFiles().toArray(new File[0]);
            String string = this.getCommonStartString(fileArray);
            if (string != null && string.startsWith(this.fileNameCompletionString)) {
                this.setFileName(string);
            }
            this.fileNameCompletionString = null;
        }
    }

    private String getCommonStartString(File[] fileArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        if (fileArray.length == 0) {
            return null;
        }
        while (true) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string3 = fileArray[i].getName();
                if (i == 0) {
                    if (string3.length() == n) {
                        return string;
                    }
                    string2 = string3.substring(0, n + 1);
                }
                if (string3.startsWith(string2)) continue;
                return string;
            }
            string = string2;
            ++n;
        }
    }

    private void resetGlobFilter() {
        if (this.actualFileFilter != null) {
            JFileChooser jFileChooser = this.getFileChooser();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter != null && fileFilter.equals(this.globFilter)) {
                jFileChooser.setFileFilter(this.actualFileFilter);
                jFileChooser.removeChoosableFileFilter(this.globFilter);
            }
            this.actualFileFilter = null;
        }
    }

    private static boolean isGlobPattern(String string) {
        return File.separatorChar == '\\' && string.indexOf(42) >= 0 || File.separatorChar == '/' && (string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(91) >= 0);
    }

    public Action getFileNameCompletionAction() {
        return this.fileNameCompletionAction;
    }

    @Override
    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    protected JButton getCancelButton(JFileChooser jFileChooser) {
        return this.cancelButton;
    }

    @Override
    public void clearIconCache() {
    }

    private class UIBorder
    extends AbstractBorder
    implements UIResource {
        private Insets _insets;

        UIBorder(Insets insets) {
            this._insets = insets != null ? new Insets(insets.top, insets.left, insets.bottom, insets.right) : null;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JComponent jComponent = (JComponent)component;
            SynthContext synthContext = SynthFileChooserUI.this.getContext(jComponent);
            SynthStyle synthStyle = synthContext.getStyle();
            if (synthStyle != null) {
                synthStyle.getPainter(synthContext).paintFileChooserBorder(synthContext, graphics, n, n2, n3, n4);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            if (this._insets != null) {
                insets.top = this._insets.top;
                insets.bottom = this._insets.bottom;
                insets.left = this._insets.left;
                insets.right = this._insets.right;
            } else {
                insets.left = 0;
                insets.right = 0;
                insets.bottom = 0;
                insets.top = 0;
            }
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    class GlobFilter
    extends FileFilter {
        Pattern pattern;
        String globPattern;

        GlobFilter() {
        }

        public void setPattern(String string) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length * 2];
            boolean bl = File.separatorChar == '\\';
            boolean bl2 = false;
            int n = 0;
            this.globPattern = string;
            if (bl) {
                int n2 = cArray.length;
                if (string.endsWith("*.*")) {
                    n2 -= 2;
                }
                for (int i = 0; i < n2; ++i) {
                    if (cArray[i] == '*') {
                        cArray2[n++] = 46;
                    }
                    cArray2[n++] = cArray[i];
                }
            } else {
                block12: for (int i = 0; i < cArray.length; ++i) {
                    switch (cArray[i]) {
                        case '*': {
                            if (!bl2) {
                                cArray2[n++] = 46;
                            }
                            cArray2[n++] = 42;
                            continue block12;
                        }
                        case '?': {
                            cArray2[n++] = bl2 ? 63 : 46;
                            continue block12;
                        }
                        case '[': {
                            bl2 = true;
                            cArray2[n++] = cArray[i];
                            if (i >= cArray.length - 1) continue block12;
                            switch (cArray[i + 1]) {
                                case '!': 
                                case '^': {
                                    cArray2[n++] = 94;
                                    ++i;
                                    break;
                                }
                                case ']': {
                                    cArray2[n++] = cArray[++i];
                                }
                            }
                            continue block12;
                        }
                        case ']': {
                            cArray2[n++] = cArray[i];
                            bl2 = false;
                            continue block12;
                        }
                        case '\\': {
                            if (i == 0 && cArray.length > 1 && cArray[1] == '~') {
                                cArray2[n++] = cArray[++i];
                                continue block12;
                            }
                            cArray2[n++] = 92;
                            if (i < cArray.length - 1 && "*?[]".indexOf(cArray[i + 1]) >= 0) {
                                cArray2[n++] = cArray[++i];
                                continue block12;
                            }
                            cArray2[n++] = 92;
                            continue block12;
                        }
                        default: {
                            if (!Character.isLetterOrDigit(cArray[i])) {
                                cArray2[n++] = 92;
                            }
                            cArray2[n++] = cArray[i];
                        }
                    }
                }
            }
            this.pattern = Pattern.compile(new String(cArray2, 0, n), 2);
        }

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(file.getName()).matches();
        }

        @Override
        public String getDescription() {
            return this.globPattern;
        }
    }

    private class FileNameCompletionAction
    extends AbstractAction {
        protected FileNameCompletionAction() {
            super("fileNameCompletion");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = SynthFileChooserUI.this.getFileChooser();
            String string = SynthFileChooserUI.this.getFileName();
            if (string != null) {
                string = string.trim();
            }
            SynthFileChooserUI.this.resetGlobFilter();
            if (string == null || string.equals("") || jFileChooser.isMultiSelectionEnabled() && string.startsWith("\"")) {
                return;
            }
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (SynthFileChooserUI.this.globFilter == null) {
                SynthFileChooserUI.this.globFilter = new GlobFilter();
            }
            try {
                SynthFileChooserUI.this.globFilter.setPattern(!SynthFileChooserUI.isGlobPattern(string) ? string + "*" : string);
                if (!(fileFilter instanceof GlobFilter)) {
                    SynthFileChooserUI.this.actualFileFilter = fileFilter;
                }
                jFileChooser.setFileFilter(null);
                jFileChooser.setFileFilter(SynthFileChooserUI.this.globFilter);
                SynthFileChooserUI.this.fileNameCompletionString = string;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    private class SynthFCPropertyChangeListener
    implements PropertyChangeListener {
        private SynthFCPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("fileSelectionChanged")) {
                SynthFileChooserUI.this.doFileSelectionModeChanged(propertyChangeEvent);
            } else if (string.equals("SelectedFileChangedProperty")) {
                SynthFileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
            } else if (string.equals("SelectedFilesChangedProperty")) {
                SynthFileChooserUI.this.doSelectedFilesChanged(propertyChangeEvent);
            } else if (string.equals("directoryChanged")) {
                SynthFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
            } else if (string == "MultiSelectionEnabledChangedProperty") {
                SynthFileChooserUI.this.doMultiSelectionChanged(propertyChangeEvent);
            } else if (string == "AccessoryChangedProperty") {
                SynthFileChooserUI.this.doAccessoryChanged(propertyChangeEvent);
            } else if (string == "ApproveButtonTextChangedProperty" || string == "ApproveButtonToolTipTextChangedProperty" || string == "DialogTypeChangedProperty" || string == "ControlButtonsAreShownChangedProperty") {
                SynthFileChooserUI.this.doControlButtonsChanged(propertyChangeEvent);
            } else if (string.equals("componentOrientation")) {
                ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                    jFileChooser.applyComponentOrientation(componentOrientation);
                }
            } else if (string.equals("ancestor")) {
                SynthFileChooserUI.this.doAncestorChanged(propertyChangeEvent);
            }
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        DelayedSelectionUpdater() {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            SynthFileChooserUI.this.updateFileNameCompletion();
        }
    }
}

