/*
 * Decompiled with CFR 0.152.
 */
package sun.security.timestamp;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import sun.misc.IOUtils;
import sun.security.timestamp.TSRequest;
import sun.security.timestamp.TSResponse;
import sun.security.timestamp.Timestamper;

public class HttpTimestamper
implements Timestamper {
    private static final int CONNECT_TIMEOUT = 15000;
    private static final String TS_QUERY_MIME_TYPE = "application/timestamp-query";
    private static final String TS_REPLY_MIME_TYPE = "application/timestamp-reply";
    private static final boolean DEBUG = false;
    private String tsaUrl = null;

    public HttpTimestamper(String string) {
        this.tsaUrl = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSResponse generateTimestamp(TSRequest tSRequest) throws IOException {
        Object object;
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(this.tsaUrl).openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-Type", TS_QUERY_MIME_TYPE);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.connect();
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            object = tSRequest.encode();
            dataOutputStream.write((byte[])object, 0, ((byte[])object).length);
            dataOutputStream.flush();
        }
        finally {
            if (dataOutputStream != null) {
                dataOutputStream.close();
            }
        }
        object = null;
        byte[] byArray = null;
        try {
            object = new BufferedInputStream(httpURLConnection.getInputStream());
            int n = httpURLConnection.getContentLength();
            HttpTimestamper.verifyMimeType(httpURLConnection.getContentType());
            byArray = IOUtils.readFully((InputStream)object, n, false);
        }
        finally {
            if (object != null) {
                ((BufferedInputStream)object).close();
            }
        }
        return new TSResponse(byArray);
    }

    private static void verifyMimeType(String string) throws IOException {
        if (!TS_REPLY_MIME_TYPE.equalsIgnoreCase(string)) {
            throw new IOException("MIME Content-Type is not application/timestamp-reply");
        }
    }
}

