/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.MainSwatchPanel;
import javax.swing.colorchooser.RecentSwatchPanel;
import javax.swing.colorchooser.SwatchPanel;

class DefaultSwatchChooserPanel
extends AbstractColorChooserPanel {
    SwatchPanel swatchPanel;
    RecentSwatchPanel recentSwatchPanel;
    MouseListener mainSwatchListener;
    MouseListener recentSwatchListener;
    private static String recentStr = UIManager.getString("ColorChooser.swatchesRecentText");

    public DefaultSwatchChooserPanel() {
        this.setInheritsPopupMenu(true);
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    @Override
    public int getMnemonic() {
        return DefaultSwatchChooserPanel.getInt("ColorChooser.swatchesMnemonic", -1);
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return DefaultSwatchChooserPanel.getInt("ColorChooser.swatchesDisplayedMnemonicIndex", -1);
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(JColorChooser jColorChooser) {
        super.installChooserPanel(jColorChooser);
    }

    @Override
    protected void buildChooser() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.putClientProperty("AccessibleName", this.getDisplayName());
        this.swatchPanel.setInheritsPopupMenu(true);
        this.recentSwatchPanel = new RecentSwatchPanel();
        this.recentSwatchPanel.putClientProperty("AccessibleName", recentStr);
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        jPanel2.setBorder(compoundBorder);
        jPanel2.add((Component)this.swatchPanel, "Center");
        gridBagConstraints.anchor = 25;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets = insets;
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        this.recentSwatchPanel.setInheritsPopupMenu(true);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(compoundBorder);
        jPanel3.setInheritsPopupMenu(true);
        jPanel3.add((Component)this.recentSwatchPanel, "Center");
        JLabel jLabel = new JLabel(recentStr);
        jLabel.setLabelFor(this.recentSwatchPanel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        jPanel.setInheritsPopupMenu(true);
        this.add(jPanel);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        super.uninstallChooserPanel(jColorChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.swatchPanel = null;
        this.recentSwatchPanel = null;
        this.mainSwatchListener = null;
        this.recentSwatchListener = null;
        this.removeAll();
    }

    @Override
    public void updateChooser() {
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        MainSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Color color = DefaultSwatchChooserPanel.this.swatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
            DefaultSwatchChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
        }
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        RecentSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Color color = DefaultSwatchChooserPanel.this.recentSwatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

