/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectCharBufferRU;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectCharBufferU
extends CharBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    protected static final boolean unaligned = Bits.unaligned();
    protected Object viewedBuffer = null;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public Cleaner cleaner() {
        return null;
    }

    DirectCharBufferU(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + (long)n5;
        this.viewedBuffer = directBuffer;
    }

    public CharBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 1;
        assert (n4 >= 0);
        return new DirectCharBufferU(this, -1, 0, n3, n3, n4);
    }

    public CharBuffer duplicate() {
        return new DirectCharBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public CharBuffer asReadOnlyBuffer() {
        return new DirectCharBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int n) {
        return this.address + (long)(n << 1);
    }

    public char get() {
        return unsafe.getChar(this.ix(this.nextGetIndex()));
    }

    public char get(int n) {
        return unsafe.getChar(this.ix(this.checkIndex(n)));
    }

    public CharBuffer get(char[] cArray, int n, int n2) {
        if (n2 << 1 > 6) {
            int n3;
            DirectCharBufferU.checkBounds(n, n2, cArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToCharArray(this.ix(n4), cArray, n << 1, n2 << 1);
            } else {
                Bits.copyToByteArray(this.ix(n4), cArray, n << 1, n2 << 1);
            }
            this.position(n4 + n2);
        } else {
            super.get(cArray, n, n2);
        }
        return this;
    }

    public CharBuffer put(char c) {
        unsafe.putChar(this.ix(this.nextPutIndex()), c);
        return this;
    }

    public CharBuffer put(int n, char c) {
        unsafe.putChar(this.ix(this.checkIndex(n)), c);
        return this;
    }

    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer instanceof DirectCharBufferU) {
            int n;
            if (charBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectCharBufferU directCharBufferU = (DirectCharBufferU)charBuffer;
            int n2 = directCharBufferU.position();
            int n3 = directCharBufferU.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directCharBufferU.ix(n2), this.ix(n5), n4 << 1);
            directCharBufferU.position(n2 + n4);
            this.position(n5 + n4);
        } else if (charBuffer.hb != null) {
            int n = charBuffer.position();
            int n8 = charBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(charBuffer.hb, charBuffer.offset + n, n9);
            charBuffer.position(n + n9);
        } else {
            super.put(charBuffer);
        }
        return this;
    }

    public CharBuffer put(char[] cArray, int n, int n2) {
        if (n2 << 1 > 6) {
            int n3;
            DirectCharBufferU.checkBounds(n, n2, cArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromCharArray(cArray, n << 1, this.ix(n4), n2 << 1);
            } else {
                Bits.copyFromByteArray(cArray, n << 1, this.ix(n4), n2 << 1);
            }
            this.position(n4 + n2);
        } else {
            super.put(cArray, n, n2);
        }
        return this;
    }

    public CharBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        unsafe.copyMemory(this.ix(n), this.ix(0), n3 << 1);
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String toString(int n, int n2) {
        if (n2 > this.limit() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int n3 = n2 - n;
            char[] cArray = new char[n3];
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            CharBuffer charBuffer2 = this.duplicate();
            charBuffer2.position(n);
            charBuffer2.limit(n2);
            charBuffer.put(charBuffer2);
            return new String(cArray);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public CharSequence subSequence(int n, int n2) {
        int n3 = this.position();
        int n4 = this.limit();
        assert (n3 <= n4);
        n3 = n3 <= n4 ? n3 : n4;
        int n5 = n4 - n3;
        if (n < 0 || n2 > n5 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n6 = n2 - n;
        int n7 = n3 + n << 1;
        assert (n7 >= 0);
        return new DirectCharBufferU(this, -1, 0, n6, n6, n7);
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

