/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model.wsdl;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLService;
import com.sun.xml.internal.ws.model.wsdl.AbstractExtensibleImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSDLServiceImpl
extends AbstractExtensibleImpl
implements WSDLService {
    private final QName name;
    private final Map<QName, WSDLPortImpl> ports;
    private final WSDLModelImpl parent;

    public WSDLServiceImpl(XMLStreamReader xsr, WSDLModelImpl parent, QName name) {
        super(xsr);
        this.parent = parent;
        this.name = name;
        this.ports = new LinkedHashMap<QName, WSDLPortImpl>();
    }

    @Override
    @NotNull
    public WSDLModelImpl getParent() {
        return this.parent;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public WSDLPortImpl get(QName portName) {
        return this.ports.get(portName);
    }

    @Override
    public WSDLPort getFirstPort() {
        if (this.ports.isEmpty()) {
            return null;
        }
        return this.ports.values().iterator().next();
    }

    public Iterable<WSDLPortImpl> getPorts() {
        return this.ports.values();
    }

    @Nullable
    public WSDLPortImpl getMatchingPort(QName portTypeName) {
        for (WSDLPortImpl port : this.getPorts()) {
            QName ptName = port.getBinding().getPortTypeName();
            assert (ptName != null);
            if (!ptName.equals(portTypeName)) continue;
            return port;
        }
        return null;
    }

    public void put(QName portName, WSDLPortImpl port) {
        if (portName == null || port == null) {
            throw new NullPointerException();
        }
        this.ports.put(portName, port);
    }

    void freeze(WSDLModelImpl root) {
        for (WSDLPortImpl port : this.ports.values()) {
            port.freeze(root);
        }
    }
}

