/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.ui.SAPanel;
import sun.jvm.hotspot.utilities.soql.JSJavaObject;
import sun.jvm.hotspot.utilities.soql.ObjectVisitor;
import sun.jvm.hotspot.utilities.soql.SOQLEngine;

public class FindByQueryPanel
extends SAPanel {
    private JTextArea queryEditor;
    private JEditorPane objectsEditor;
    private SOQLEngine queryEngine = SOQLEngine.getEngine();

    public FindByQueryPanel() {
        HyperlinkListener hyperListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    VM vm = VM.getVM();
                    OopHandle handle = vm.getDebugger().parseAddress(e.getDescription()).addOffsetToAsOopHandle(0L);
                    FindByQueryPanel.this.showInspector(vm.getObjectHeap().newOop(handle));
                }
            }
        };
        this.objectsEditor = new JEditorPane();
        this.objectsEditor.setContentType("text/html");
        this.objectsEditor.setEditable(false);
        this.objectsEditor.addHyperlinkListener(hyperListener);
        this.queryEditor = new JTextArea();
        JButton queryButton = new JButton("Execute");
        queryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                final StringBuffer buf = new StringBuffer();
                buf.append("<html><body>");
                try {
                    FindByQueryPanel.this.queryEngine.executeQuery(FindByQueryPanel.this.queryEditor.getText(), new ObjectVisitor(){

                        public void visit(Object o) {
                            if (o != null && o instanceof JSJavaObject) {
                                String oopAddr = ((JSJavaObject)o).getOop().getHandle().toString();
                                buf.append("<a href='");
                                buf.append(oopAddr);
                                buf.append("'>");
                                buf.append(oopAddr);
                                buf.append("</a>");
                            } else {
                                buf.append(o == null ? "null" : o.toString());
                            }
                            buf.append("<br>");
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                    buf.append("<b>");
                    buf.append(e.getMessage());
                    buf.append("</b>");
                }
                buf.append("</body></html>");
                FindByQueryPanel.this.objectsEditor.setText(buf.toString());
            }
        });
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JLabel("SOQL Query :"), "West");
        topPanel.add((Component)new JScrollPane(this.queryEditor), "Center");
        topPanel.add((Component)queryButton, "East");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)new JScrollPane(this.objectsEditor), "Center");
        JSplitPane splitPane = new JSplitPane(0, topPanel, bottomPanel);
        splitPane.setDividerLocation(0.3);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
    }
}

