/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.CompactibleSpace;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class ContiguousSpace
extends CompactibleSpace {
    private static AddressField topField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ContiguousSpace");
        topField = type.getAddressField("_top");
    }

    public ContiguousSpace(Address addr) {
        super(addr);
    }

    public Address top() {
        return topField.getValue(this.addr);
    }

    public long capacity() {
        return this.end().minus(this.bottom());
    }

    public long used() {
        return this.top().minus(this.bottom());
    }

    public long free() {
        return this.end().minus(this.top());
    }

    public MemRegion usedRegion() {
        return new MemRegion(this.bottom(), this.top());
    }

    public List getLiveRegions() {
        ArrayList<MemRegion> res = new ArrayList<MemRegion>();
        res.add(new MemRegion(this.bottom(), this.top()));
        return res;
    }

    public boolean contains(Address p) {
        return this.bottom().lessThanOrEqual(p) && this.top().greaterThan(p);
    }

    public void printOn(PrintStream tty) {
        tty.print(" [" + this.bottom() + "," + this.top() + "," + this.end() + ")");
        super.printOn(tty);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                ContiguousSpace.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

