/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.BranchInstruction;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.x86.X86Instruction;
import sun.jvm.hotspot.asm.x86.X86PCRelativeAddress;

public class X86CondJmpInstruction
extends X86Instruction
implements BranchInstruction {
    private final X86PCRelativeAddress addr;

    public X86CondJmpInstruction(String name, X86PCRelativeAddress addr, int size, int prefixes) {
        super(name, size, prefixes);
        this.addr = addr;
        if (addr instanceof X86PCRelativeAddress) {
            addr.setInstructionSize(this.getSize());
        }
    }

    public String asString(long currentPc, SymbolFinder symFinder) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getPrefixString());
        buf.append(this.getName());
        buf.append(spaces);
        if (this.addr instanceof X86PCRelativeAddress) {
            long disp = this.addr.getDisplacement();
            long address = disp + currentPc;
            buf.append(symFinder.getSymbolFor(address));
        }
        return buf.toString();
    }

    public Address getBranchDestination() {
        return this.addr;
    }

    public boolean isBranch() {
        return true;
    }

    public boolean isConditional() {
        return true;
    }
}

