/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.ui;

import com.sun.java.swing.action.BackAction;
import com.sun.java.swing.action.CancelAction;
import com.sun.java.swing.action.DelegateAction;
import com.sun.java.swing.action.FinishAction;
import com.sun.java.swing.action.NextAction;
import com.sun.java.swing.ui.CommonUI;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class WizardDlg
extends JDialog {
    private CardLayout panesLayout;
    private JPanel panesPanel;
    private DelegateAction backAction;
    private DelegateAction nextAction;
    private DelegateAction finishAction;
    private DelegateAction cancelAction;
    private ActionListener finishListener;
    private ActionListener cancelListener;
    private ActionListener nextListener;
    private ActionListener backListener;
    private int numCards;
    private int cardShowing;
    private String title;
    private Vector panels;
    private Vector images;
    private static WizardDlg wizardDlg;

    public WizardDlg(JFrame frame, String title, Vector panels, Vector images) {
        super(frame, title, true);
        this.title = title;
        this.images = images;
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.panesLayout = new CardLayout();
        this.panesPanel = new JPanel(this.panesLayout);
        pane.add((Component)this.panesPanel, "Center");
        pane.add((Component)this.createButtonPanel(), "South");
        this.setPanels(panels);
        this.pack();
        CommonUI.centerComponent(this);
    }

    public WizardDlg(JFrame frame, String title, Vector panels) {
        this(frame, title, panels, null);
    }

    public WizardDlg(String title, Vector panels) {
        this(new JFrame(), title, panels, null);
    }

    public void setPanels(Vector panels) {
        this.numCards = panels.size();
        this.cardShowing = 1;
        this.panels = panels;
        this.panesPanel.removeAll();
        for (int i = 0; i < this.numCards; ++i) {
            this.panesPanel.add((Component)((JPanel)panels.elementAt(i)), new Integer(i).toString());
        }
        this.validate();
        this.enableBackNextButtons();
    }

    public void reset() {
        this.cardShowing = 1;
        this.panesLayout.first(this.panesPanel);
        this.enableBackNextButtons();
    }

    public void setWestPanel(JPanel panel) {
        Container pane = this.getContentPane();
        pane.add((Component)panel, "West");
    }

    public static void main(String[] args) {
        JPanel p1 = new JPanel();
        p1.add(new JButton("One"));
        JPanel p2 = new JPanel();
        p2.add(new JButton("Two"));
        JPanel p3 = new JPanel();
        p3.add(new JButton("Three"));
        JPanel p4 = new JPanel();
        p4.add(new JButton("Four"));
        Vector<JPanel> panels = new Vector<JPanel>();
        panels.addElement(p1);
        panels.addElement(p2);
        panels.addElement(p3);
        panels.addElement(p4);
        wizardDlg = new WizardDlg("Test Dialog", panels);
        wizardDlg.addFinishListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        wizardDlg.addCancelListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.exit(0);
            }
        });
        wizardDlg.setVisible(true);
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        this.backAction = new BackAction();
        this.nextAction = new NextAction();
        this.finishAction = new FinishAction();
        this.cancelAction = new CancelAction();
        this.backAction.setEnabled(false);
        this.finishAction.setEnabled(false);
        this.backAction.addActionListener(new BackListener());
        this.nextAction.addActionListener(new NextListener());
        this.finishAction.addActionListener(new FinishListener());
        this.cancelAction.addActionListener(new CancelListener());
        panel.add(CommonUI.createButton(this.backAction));
        panel.add(CommonUI.createButton(this.nextAction));
        panel.add(CommonUI.createButton(this.finishAction));
        panel.add(CommonUI.createButton(this.cancelAction));
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)panel, "Center");
        p2.add((Component)new JSeparator(), "North");
        return p2;
    }

    private void enableBackNextButtons() {
        if (this.cardShowing == 1) {
            this.backAction.setEnabled(false);
            this.finishAction.setEnabled(false);
            if (this.numCards > 1) {
                this.nextAction.setEnabled(true);
            } else {
                this.finishAction.setEnabled(true);
                this.nextAction.setEnabled(false);
            }
        } else if (this.cardShowing == this.numCards) {
            this.nextAction.setEnabled(false);
            this.finishAction.setEnabled(true);
            if (this.numCards > 1) {
                this.backAction.setEnabled(true);
            } else {
                this.backAction.setEnabled(false);
            }
        } else {
            this.backAction.setEnabled(true);
            this.nextAction.setEnabled(true);
            this.finishAction.setEnabled(false);
        }
        this.setTitle();
    }

    private void setTitle() {
        JPanel panel = (JPanel)this.panels.elementAt(this.cardShowing - 1);
        String newTitle = this.title;
        String panelTitle = panel.getName();
        if (panelTitle != null && panelTitle.equals("")) {
            newTitle = newTitle + " - ";
            newTitle = newTitle + panelTitle;
        }
        super.setTitle(newTitle);
    }

    public synchronized void addFinishListener(ActionListener l) {
        this.finishListener = AWTEventMulticaster.add(this.finishListener, l);
    }

    public synchronized void removeFinishListener(ActionListener l) {
        this.finishListener = AWTEventMulticaster.remove(this.finishListener, l);
    }

    public synchronized void addCancelListener(ActionListener l) {
        this.cancelListener = AWTEventMulticaster.add(this.cancelListener, l);
    }

    public synchronized void removeCancelListener(ActionListener l) {
        this.cancelListener = AWTEventMulticaster.remove(this.cancelListener, l);
    }

    public synchronized void addNextListener(ActionListener l) {
        this.nextListener = AWTEventMulticaster.add(this.nextListener, l);
    }

    public synchronized void removeNextListener(ActionListener l) {
        this.nextListener = AWTEventMulticaster.remove(this.nextListener, l);
    }

    public synchronized void addBackListener(ActionListener l) {
        this.backListener = AWTEventMulticaster.add(this.backListener, l);
    }

    public synchronized void removeBackListener(ActionListener l) {
        this.backListener = AWTEventMulticaster.remove(this.backListener, l);
    }

    private class BackListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            WizardDlg.this.cardShowing--;
            if (WizardDlg.this.cardShowing < 1) {
                WizardDlg.this.cardShowing = 1;
            } else {
                WizardDlg.this.panesLayout.previous(WizardDlg.this.panesPanel);
            }
            if (WizardDlg.this.backListener != null) {
                WizardDlg.this.backListener.actionPerformed(evt);
            }
            WizardDlg.this.enableBackNextButtons();
        }

        private BackListener() {
        }
    }

    private class NextListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            WizardDlg.this.cardShowing++;
            if (WizardDlg.this.cardShowing > WizardDlg.this.numCards) {
                WizardDlg.this.cardShowing = WizardDlg.this.numCards;
            } else {
                WizardDlg.this.panesLayout.next(WizardDlg.this.panesPanel);
            }
            if (WizardDlg.this.nextListener != null) {
                WizardDlg.this.nextListener.actionPerformed(evt);
            }
            WizardDlg.this.enableBackNextButtons();
        }

        private NextListener() {
        }
    }

    private class FinishListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            if (WizardDlg.this.finishListener != null) {
                WizardDlg.this.finishListener.actionPerformed(evt);
            }
            WizardDlg.this.setVisible(false);
        }

        private FinishListener() {
        }
    }

    private class CancelListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            if (WizardDlg.this.cancelListener != null) {
                WizardDlg.this.cancelListener.actionPerformed(evt);
            }
            WizardDlg.this.setVisible(false);
        }

        private CancelListener() {
        }
    }
}

