/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public enum ImageResources {
    INSTANCE;

    private static final String APPLICATION_ICON_PATH = "net/sourceforge/jnlp/resources/netx-icon.png";
    private final Map<String, Image> cache = new HashMap<String, Image>();

    void clearCache() {
        this.cache.clear();
    }

    private Image getApplicationImage() {
        if (this.cache.containsKey(APPLICATION_ICON_PATH)) {
            return this.cache.get(APPLICATION_ICON_PATH);
        }
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        InputStream in = cl.getResourceAsStream(APPLICATION_ICON_PATH);
        try {
            BufferedImage image = ImageIO.read(in);
            this.cache.put(APPLICATION_ICON_PATH, image);
            return image;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public List<Image> getApplicationImages() {
        ArrayList<Image> images = new ArrayList<Image>();
        Image appImage = this.getApplicationImage();
        if (appImage != null) {
            images.add(appImage);
        }
        return images;
    }
}

