/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertificateUtils;
import net.sourceforge.jnlp.security.KeyStores;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.NetscapeCertTypeExtension;

public class JarCertVerifier
implements CertVerifier {
    private static final String META_INF = "META-INF/";
    private static final String SIG_PREFIX = "META-INF/SIG-";
    private static final long SIX_MONTHS = 15552000000L;
    X509Certificate[] certChain;
    boolean verbose = false;
    boolean showcerts = false;
    private boolean hasExpiredCert = false;
    private boolean hasExpiringCert = false;
    private boolean notYetValidCert = false;
    private boolean badKeyUsage = false;
    private boolean badExtendedKeyUsage = false;
    private boolean badNetscapeCertType = false;
    private boolean alreadyTrustPublisher = false;
    private boolean rootInCacerts = false;
    private CertPath certPath = null;
    private boolean noSigningIssues = true;
    private boolean anyJarsSigned = false;
    private ArrayList<String> verifiedJars = null;
    private ArrayList<String> unverifiedJars = null;
    private HashMap<CertPath, Integer> certs = new HashMap();
    private ArrayList<String> details = new ArrayList();
    private int totalSignableEntries = 0;

    @Override
    public boolean getAlreadyTrustPublisher() {
        return this.alreadyTrustPublisher;
    }

    @Override
    public boolean getRootInCacerts() {
        return this.rootInCacerts;
    }

    @Override
    public CertPath getCertPath() {
        return this.certPath;
    }

    @Override
    public boolean hasSigningIssues() {
        return this.hasExpiredCert || this.notYetValidCert || this.badKeyUsage || this.badExtendedKeyUsage || this.badNetscapeCertType;
    }

    @Override
    public boolean noSigningIssues() {
        return this.noSigningIssues;
    }

    public boolean anyJarsSigned() {
        return this.anyJarsSigned;
    }

    @Override
    public ArrayList<String> getDetails() {
        return this.details;
    }

    public ArrayList<CertPath> getCerts() {
        return new ArrayList<CertPath>(this.certs.keySet());
    }

    public boolean isFullySignedByASingleCert() {
        for (CertPath cPath : this.certs.keySet()) {
            if (this.certs.get(cPath) != this.totalSignableEntries) continue;
            return true;
        }
        return false;
    }

    public void verifyJars(List<JARDesc> jars, ResourceTracker tracker) throws Exception {
        this.verifiedJars = new ArrayList();
        this.unverifiedJars = new ArrayList();
        for (JARDesc jar : jars) {
            File jarFile = tracker.getCacheFile(jar.getLocation());
            if (jarFile == null) continue;
            String localFile = jarFile.getAbsolutePath();
            verifyResult result = this.verifyJar(localFile);
            if (result == verifyResult.UNSIGNED) {
                this.unverifiedJars.add(localFile);
                continue;
            }
            if (result == verifyResult.SIGNED_NOT_OK) {
                this.noSigningIssues = false;
                this.verifiedJars.add(localFile);
                continue;
            }
            if (result != verifyResult.SIGNED_OK) continue;
            this.verifiedJars.add(localFile);
        }
        for (CertPath cPath : this.certs.keySet()) {
            if (this.certs.get(cPath) != this.totalSignableEntries) continue;
            this.certPath = cPath;
            this.checkTrustedCerts();
            if (!this.alreadyTrustPublisher && !this.rootInCacerts) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private verifyResult verifyJar(String jarName) throws Exception {
        boolean anySigned = false;
        boolean hasUnsignedEntry = false;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarName, true);
            Vector<JarEntry> entriesVec = new Vector<JarEntry>();
            byte[] buffer = new byte[8192];
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                entriesVec.addElement(je);
                InputStream is = jarFile.getInputStream(je);
                try {
                    int n;
                    while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            if (jarFile.getManifest() != null) {
                if (this.verbose) {
                    System.out.println();
                }
                long now = System.currentTimeMillis();
                for (JarEntry je : entriesVec) {
                    String name = je.getName();
                    CodeSigner[] signers = je.getCodeSigners();
                    boolean isSigned = signers != null;
                    anySigned |= isSigned;
                    boolean shouldHaveSignature = !je.isDirectory() && !JarCertVerifier.isMetaInfFile(name);
                    hasUnsignedEntry |= shouldHaveSignature && !isSigned;
                    if (shouldHaveSignature) {
                        ++this.totalSignableEntries;
                    }
                    if (!shouldHaveSignature || !isSigned) continue;
                    for (int i = 0; i < signers.length; ++i) {
                        CertPath certPath = signers[i].getSignerCertPath();
                        if (!this.certs.containsKey(certPath)) {
                            this.certs.put(certPath, 1);
                        } else {
                            this.certs.put(certPath, this.certs.get(certPath) + 1);
                        }
                        Certificate cert = signers[i].getSignerCertPath().getCertificates().get(0);
                        if (!(cert instanceof X509Certificate)) continue;
                        this.checkCertUsage((X509Certificate)cert, null);
                        if (this.showcerts) continue;
                        long notBefore = ((X509Certificate)cert).getNotBefore().getTime();
                        long notAfter = ((X509Certificate)cert).getNotAfter().getTime();
                        if (now < notBefore) {
                            this.notYetValidCert = true;
                        }
                        if (notAfter < now) {
                            this.hasExpiredCert = true;
                            continue;
                        }
                        if (notAfter >= now + 15552000000L) continue;
                        this.hasExpiringCert = true;
                    }
                }
            } else {
                ++this.totalSignableEntries;
            }
            if (!anySigned) {
                verifyResult verifyResult2 = verifyResult.UNSIGNED;
                return verifyResult2;
            }
            this.anyJarsSigned = true;
            if (hasUnsignedEntry || this.hasExpiredCert || this.hasExpiringCert || this.badKeyUsage || this.badExtendedKeyUsage || this.badNetscapeCertType || this.notYetValidCert) {
                this.addToDetails(Translator.R("SRunWithoutRestrictions"));
                if (this.badKeyUsage) {
                    this.addToDetails(Translator.R("SBadKeyUsage"));
                }
                if (this.badExtendedKeyUsage) {
                    this.addToDetails(Translator.R("SBadExtendedKeyUsage"));
                }
                if (this.badNetscapeCertType) {
                    this.addToDetails(Translator.R("SBadNetscapeCertType"));
                }
                if (hasUnsignedEntry) {
                    this.addToDetails(Translator.R("SHasUnsignedEntry"));
                }
                if (this.hasExpiredCert) {
                    this.addToDetails(Translator.R("SHasExpiredCert"));
                }
                if (this.hasExpiringCert) {
                    this.addToDetails(Translator.R("SHasExpiringCert"));
                }
                if (this.notYetValidCert) {
                    this.addToDetails(Translator.R("SNotYetValidCert"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        return anySigned && !hasUnsignedEntry && !this.hasExpiredCert && !this.badKeyUsage && !this.badExtendedKeyUsage && !this.badNetscapeCertType && !this.notYetValidCert ? verifyResult.SIGNED_OK : verifyResult.SIGNED_NOT_OK;
    }

    private void checkTrustedCerts() throws Exception {
        if (this.certPath != null) {
            Certificate c;
            X509Certificate publisher = (X509Certificate)this.getPublisher();
            KeyStore[] certKeyStores = KeyStores.getCertKeyStores();
            this.alreadyTrustPublisher = CertificateUtils.inKeyStores(publisher, certKeyStores);
            X509Certificate root = (X509Certificate)this.getRoot();
            KeyStore[] caKeyStores = KeyStores.getCAKeyStores();
            Iterator<? extends Certificate> i$ = this.certPath.getCertificates().iterator();
            while (i$.hasNext() && !(this.rootInCacerts = CertificateUtils.inKeyStores((X509Certificate)(c = i$.next()), caKeyStores))) {
            }
            if (!this.rootInCacerts) {
                this.addToDetails(Translator.R("SUntrustedCertificate"));
            } else {
                this.addToDetails(Translator.R("STrustedCertificate"));
            }
        }
    }

    @Override
    public Certificate getPublisher() {
        if (this.certPath != null) {
            List<? extends Certificate> certList = this.certPath.getCertificates();
            if (certList.size() > 0) {
                return certList.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public Certificate getRoot() {
        if (this.certPath != null) {
            List<? extends Certificate> certList = this.certPath.getCertificates();
            if (certList.size() > 0) {
                return certList.get(certList.size() - 1);
            }
            return null;
        }
        return null;
    }

    private void addToDetails(String detail) {
        if (!this.details.contains(detail)) {
            this.details.add(detail);
        }
    }

    static boolean isMetaInfFile(String name) {
        String ucName = name.toUpperCase();
        return ucName.startsWith(META_INF);
    }

    void checkCertUsage(X509Certificate userCert, boolean[] bad) {
        boolean[] keyUsage;
        if (bad != null) {
            bad[2] = false;
            bad[1] = false;
            bad[0] = false;
        }
        if (!((keyUsage = userCert.getKeyUsage()) == null || keyUsage.length >= 1 && keyUsage[0])) {
            if (bad != null) {
                bad[0] = true;
            } else {
                this.badKeyUsage = true;
            }
        }
        try {
            List<String> xKeyUsage = userCert.getExtendedKeyUsage();
            if (xKeyUsage != null && !xKeyUsage.contains("2.5.29.37.0") && !xKeyUsage.contains("1.3.6.1.5.5.7.3.3")) {
                if (bad != null) {
                    bad[1] = true;
                } else {
                    this.badExtendedKeyUsage = true;
                }
            }
        }
        catch (CertificateParsingException e) {
            // empty catch block
        }
        try {
            byte[] netscapeEx = userCert.getExtensionValue("2.16.840.1.113730.1.1");
            if (netscapeEx != null) {
                DerInputStream in = new DerInputStream(netscapeEx);
                byte[] encoded = in.getOctetString();
                NetscapeCertTypeExtension extn = new NetscapeCertTypeExtension(encoded = new DerValue(encoded).getUnalignedBitString().toByteArray());
                Boolean val = (Boolean)extn.get("object_signing");
                if (!val.booleanValue()) {
                    if (bad != null) {
                        bad[2] = true;
                    } else {
                        this.badNetscapeCertType = true;
                    }
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public boolean allJarsSigned() {
        return this.unverifiedJars.size() == 0;
    }

    static enum verifyResult {
        UNSIGNED,
        SIGNED_OK,
        SIGNED_NOT_OK;

    }
}

