/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.jnlp.JNLPMatcherException;
import net.sourceforge.jnlp.Node;
import net.sourceforge.nanoxml.XMLElement;

public final class JNLPMatcher {
    private final Node appTemplateNode;
    private final Node launchJNLPNode;
    private final boolean isTemplate;

    public JNLPMatcher(Reader appTemplate, Reader launchJNLP, boolean isTemplate) throws JNLPMatcherException {
        if (appTemplate == null && launchJNLP == null) {
            throw new JNLPMatcherException("Template JNLP file and Launching JNLP file are both null.");
        }
        if (appTemplate == null) {
            throw new JNLPMatcherException("Template JNLP file is null.");
        }
        if (launchJNLP == null) {
            throw new JNLPMatcherException("Launching JNLP file is null.");
        }
        ByteArrayOutputStream poutTemplate = null;
        ByteArrayOutputStream poutJNLPFile = null;
        try {
            XMLElement appTemplateXML = new XMLElement();
            XMLElement launchJNLPXML = new XMLElement();
            poutTemplate = new ByteArrayOutputStream();
            appTemplateXML.sanitizeInput(appTemplate, poutTemplate);
            poutJNLPFile = new ByteArrayOutputStream();
            launchJNLPXML.sanitizeInput(launchJNLP, poutJNLPFile);
            appTemplateXML.parseFromReader(new StringReader(poutTemplate.toString()));
            launchJNLPXML.parseFromReader(new StringReader(poutJNLPFile.toString()));
            this.appTemplateNode = new Node(appTemplateXML);
            this.launchJNLPNode = new Node(launchJNLPXML);
            this.isTemplate = isTemplate;
            this.closeOutputStream(poutTemplate);
            this.closeOutputStream(poutJNLPFile);
        }
        catch (Exception e) {
            try {
                throw new JNLPMatcherException("Failed to create an instance of JNLPVerify with specified InputStreamReader", e);
            }
            catch (Throwable throwable) {
                this.closeOutputStream(poutTemplate);
                this.closeOutputStream(poutJNLPFile);
                throw throwable;
            }
        }
    }

    public boolean isMatch() {
        return this.matchNodes(this.appTemplateNode, this.launchJNLPNode);
    }

    private boolean matchNodes(Node appTemplate, Node launchJNLP) {
        if (appTemplate != null && launchJNLP != null) {
            Node templateNode = appTemplate;
            Node launchNode = launchJNLP;
            LinkedList<Node> appTemplateChild = new LinkedList<Node>(Arrays.asList(templateNode.getChildNodes()));
            LinkedList<Node> launchJNLPChild = new LinkedList<Node>(Arrays.asList(launchNode.getChildNodes()));
            if (templateNode.getNodeName().equals(launchNode.getNodeName()) && appTemplateChild.size() == launchJNLPChild.size()) {
                int childLength = appTemplateChild.size();
                int i = 0;
                block0: while (i < childLength) {
                    for (int j = 0; j < childLength; ++j) {
                        boolean isSame = this.matchNodes((Node)appTemplateChild.get(i), (Node)launchJNLPChild.get(j));
                        if (!isSame && j == childLength - 1) {
                            return false;
                        }
                        if (!isSame) continue;
                        appTemplateChild.remove(i);
                        launchJNLPChild.remove(j);
                        --childLength;
                        continue block0;
                    }
                }
                if (!templateNode.getNodeValue().equals(launchNode.getNodeValue())) {
                    if (this.isTemplate && !templateNode.getNodeValue().equals("*")) {
                        return false;
                    }
                    if (!this.isTemplate) {
                        return false;
                    }
                }
                return this.matchAttributes(templateNode, launchNode);
            }
        }
        return false;
    }

    private boolean matchAttributes(Node templateNode, Node launchNode) {
        if (templateNode != null && launchNode != null) {
            List<String> appTemplateAttributes = templateNode.getAttributeNames();
            List<String> launchJNLPAttributes = launchNode.getAttributeNames();
            Collections.sort(appTemplateAttributes);
            Collections.sort(launchJNLPAttributes);
            if (appTemplateAttributes.size() == launchJNLPAttributes.size()) {
                int size = appTemplateAttributes.size();
                for (int i = 0; i < size; ++i) {
                    if (launchJNLPAttributes.get(i).equals(appTemplateAttributes.get(i))) {
                        String attribute = launchJNLPAttributes.get(i);
                        boolean isSame = templateNode.getAttribute(attribute).equals(launchNode.getAttribute(attribute));
                        if (!this.isTemplate && !isSame) {
                            return false;
                        }
                        if (!this.isTemplate || isSame || templateNode.getAttribute(attribute).equals("*")) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void closeOutputStream(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

