/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import sun.applet.PluginDebug;

class Signature {
    private String signature;
    private int currentIndex;
    private List<Class> typeList;
    private static final char ARRAY = '[';
    private static final char OBJECT = 'L';
    private static final char SIGNATURE_ENDCLASS = ';';
    private static final char SIGNATURE_FUNC = '(';
    private static final char SIGNATURE_ENDFUNC = ')';
    private static final char VOID = 'V';
    private static final char BOOLEAN = 'Z';
    private static final char BYTE = 'B';
    private static final char CHARACTER = 'C';
    private static final char SHORT = 'S';
    private static final char INTEGER = 'I';
    private static final char LONG = 'J';
    private static final char FLOAT = 'F';
    private static final char DOUBLE = 'D';

    private String nextTypeName() {
        char key = this.signature.charAt(this.currentIndex++);
        switch (key) {
            case '[': {
                return this.nextTypeName() + "[]";
            }
            case 'L': {
                int endClass = this.signature.indexOf(59, this.currentIndex);
                String retVal = this.signature.substring(this.currentIndex, endClass);
                retVal = retVal.replace('/', '.');
                this.currentIndex = endClass + 1;
                return retVal;
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case ')': {
                return null;
            }
            case '(': {
                return this.nextTypeName();
            }
        }
        throw new IllegalArgumentException("Invalid JNI signature character '" + key + "'");
    }

    public Signature(String signature, ClassLoader cl) {
        this.signature = signature;
        this.currentIndex = 0;
        this.typeList = new ArrayList<Class>(10);
        while (this.currentIndex < signature.length()) {
            String elem = this.nextTypeName();
            if (elem == null) continue;
            Class primitive = Signature.primitiveNameToType(elem);
            if (primitive != null) {
                this.typeList.add(primitive);
                continue;
            }
            int dimsize = 0;
            int n = elem.indexOf(91);
            if (n != -1) {
                String arrayType = elem.substring(0, n);
                ++dimsize;
                n = elem.indexOf(91, n + 1);
                while (n != -1) {
                    ++dimsize;
                    n = elem.indexOf(91, n + 1);
                }
                int[] dims = new int[dimsize];
                primitive = Signature.primitiveNameToType(arrayType);
                if (primitive != null) {
                    this.typeList.add(Array.newInstance(primitive, dims).getClass());
                    continue;
                }
                this.typeList.add(Array.newInstance(Signature.getClass(arrayType, cl), dims).getClass());
                continue;
            }
            this.typeList.add(Signature.getClass(elem, cl));
        }
        if (signature.length() < 2) {
            throw new IllegalArgumentException("Invalid JNI signature '" + signature + "'");
        }
    }

    public static Class getClass(String name, ClassLoader cl) {
        Class<?> c = null;
        try {
            c = Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            PluginDebug.debug("Class ", name, " not found in primordial loader. Looking in ", cl);
            try {
                c = cl.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(new ClassNotFoundException("Unable to find class " + name));
            }
        }
        return c;
    }

    public static Class primitiveNameToType(String name) {
        if (name.equals("void")) {
            return Void.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        return null;
    }

    public Class[] getClassArray() {
        return this.typeList.subList(0, this.typeList.size()).toArray(new Class[0]);
    }
}

