/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.applet.Applet;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.NetxPanel;
import sun.applet.AppletPanel;
import sun.applet.AppletSecurityContextManager;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginDebug;
import sun.applet.PluginStreamHandler;

class PluginAppletPanelFactory {
    PluginAppletPanelFactory() {
    }

    public AppletPanel createPanel(PluginStreamHandler streamhandler, final int identifier, final long handle, int x, int y, final URL doc, final Hashtable<String, String> atts) {
        final NetxPanel panel = AccessController.doPrivileged(new PrivilegedAction<NetxPanel>(){

            @Override
            public NetxPanel run() {
                NetxPanel panel = new NetxPanel(doc, atts, false);
                NetxPanel.debug((String)"Using NetX panel");
                PluginDebug.debug(atts.toString());
                return panel;
            }
        });
        Thread panelInit = new Thread(panel.getThreadGroup(), new Runnable(){

            @Override
            public void run() {
                panel.createNewAppContext();
                PluginAppletViewer.framePanel(identifier, handle, panel);
                panel.init();
                PluginAppletPanelFactory.this.initEventQueue((AppletPanel)panel);
            }
        }, "NetXPanel initializer");
        panelInit.start();
        while (panelInit.isAlive()) {
            try {
                panelInit.join();
            }
            catch (InterruptedException e) {}
        }
        PluginAppletViewer.waitForAppletInit(panel);
        Applet a = panel.getApplet();
        if (a == null) {
            streamhandler.write("instance " + identifier + " reference " + -1 + " fatalError: " + "Initialization timed out");
            return null;
        }
        PluginDebug.debug("Applet ", a.getClass(), " initialized");
        streamhandler.write("instance " + identifier + " reference 0 initialized");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    panel.getParent().setSize(Integer.valueOf((String)atts.get("width")), Integer.valueOf((String)atts.get("height")));
                }
            });
        }
        catch (InvocationTargetException ite) {
            PluginDebug.debug("Unable to resize panel: ");
            ite.printStackTrace();
        }
        catch (InterruptedException ie) {
            PluginDebug.debug("Unable to resize panel: ");
            ie.printStackTrace();
        }
        AppletSecurityContextManager.getSecurityContext(0).associateSrc(panel.getAppletClassLoader(), doc);
        AppletSecurityContextManager.getSecurityContext(0).associateInstance(identifier, panel.getAppletClassLoader());
        return panel;
    }

    public boolean isStandalone() {
        return false;
    }

    private void initEventQueue(AppletPanel panel) {
        PrivilegedAction<String> pa = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("appletviewer.send.event");
            }
        };
        String eventList = AccessController.doPrivileged(pa);
        if (eventList == null) {
            panel.sendEvent(1);
            panel.sendEvent(2);
            panel.sendEvent(3);
        } else {
            String[] events;
            for (String event : events = eventList.split(",")) {
                PluginDebug.debug("Adding event to queue: ", event);
                if ("dispose".equals(event)) {
                    panel.sendEvent(0);
                    continue;
                }
                if ("load".equals(event)) {
                    panel.sendEvent(1);
                    continue;
                }
                if ("init".equals(event)) {
                    panel.sendEvent(2);
                    continue;
                }
                if ("start".equals(event)) {
                    panel.sendEvent(3);
                    continue;
                }
                if ("stop".equals(event)) {
                    panel.sendEvent(4);
                    continue;
                }
                if ("destroy".equals(event)) {
                    panel.sendEvent(5);
                    continue;
                }
                if ("quit".equals(event)) {
                    panel.sendEvent(6);
                    continue;
                }
                if ("error".equals(event)) {
                    panel.sendEvent(7);
                    continue;
                }
                PluginDebug.debug("Unrecognized event name: ", event);
            }
            while (!panel.emptyEventQueue()) {
            }
        }
    }
}

