#!/bin/sh
echo 'name: zlib
version: 0.5.4.0
id: zlib-0.5.4.0-f9a7b27d857d3e506b8524567650abc8

license: BSD3
copyright: (c) 2006-2012 Duncan Coutts
maintainer: Duncan Coutts <duncan@community.haskell.org>
stability:
homepage:
package-url:
synopsis: Compression and decompression in the gzip and zlib formats
description: This package provides a pure interface for compressing and
             decompressing streams of data represented as lazy
             '\''ByteString'\''s. It uses the zlib C library so it has high
             performance. It supports the \"zlib\", \"gzip\" and \"raw\"
             compression formats.
             .
             It provides a convenient high level API suitable for most
             tasks and for the few cases where more control is needed it
             provides access to the full zlib feature set.
category: Codec
author: Duncan Coutts <duncan@community.haskell.org>
pkgpath: archivers/hs-zlib
exposed: True
exposed-modules: Codec.Compression.GZip Codec.Compression.Zlib
                 Codec.Compression.Zlib.Raw Codec.Compression.Zlib.Internal
hidden-modules: Codec.Compression.Zlib.Stream
trusted: False
import-dirs: /usr/local/lib/ghc/zlib-0.5.4.0
library-dirs: /usr/local/lib/ghc/zlib-0.5.4.0
hs-libraries: HSzlib-0.5.4.0
extra-libraries: z
extra-ghci-libraries:
include-dirs:
includes: zlib.h
depends: base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-zlib-0.5.4.0/html/zlib.haddock
haddock-html: /usr/local/share/doc/hs-zlib-0.5.4.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
