#!/bin/sh
echo 'name: text
version: 0.11.2.3
id: text-0.11.2.3-0a507fb72e97feed1b44644051bc0e5f

license: BSD3
copyright: 2009-2011 Bryan O'\''Sullivan, 2008-2009 Tom Harper
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability:
homepage: https://github.com/bos/text
package-url:
synopsis: An efficient packed Unicode text type.
description:  
             .
             An efficient packed, immutable Unicode text type (both strict and
             lazy), with a powerful loop fusion optimization framework.
             .
             The '\''Text'\'' type represents Unicode character strings, in a time and
             space-efficient manner. This package provides text processing
             capabilities that are optimized for performance critical use, both
             in terms of large data quantities and high speed.
             .
             The '\''Text'\'' type provides character-encoding, type-safe case
             conversion via whole-string case conversion functions. It also
             provides a range of functions for converting '\''Text'\'' values to and from
             '\''ByteStrings'\'', using several standard encodings.
             .
             Efficient locale-sensitive support for text IO is also supported.
             .
             These modules are intended to be imported qualified, to avoid name
             clashes with Prelude functions, e.g.
             .
             > import qualified Data.Text as T
             .
             To use an extended and very rich family of functions for working
             with Unicode text (including normalization, regular expressions,
             non-standard encodings, text breaking, and locales), see
             the @text-icu@ package:
             <http://hackage.haskell.org/package/text-icu>
             .
             &#8212;&#8212; RELEASE NOTES &#8212;&#8212;
             .
             Changes in 0.11.2.0:
             .
             * String literals are now converted directly from the format in
             which GHC stores them into '\''Text'\'', without an intermediate
             transformation through '\''String'\'', and without inlining of
             conversion code at each site where a string literal is declared.
             .
category: Data, Text
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: devel/hs-text
exposed: True
exposed-modules: Data.Text Data.Text.Array Data.Text.Encoding
                 Data.Text.Encoding.Error Data.Text.Foreign Data.Text.IO
                 Data.Text.Internal Data.Text.Lazy Data.Text.Lazy.Builder
                 Data.Text.Lazy.Builder.Int Data.Text.Lazy.Builder.RealFloat
                 Data.Text.Lazy.Encoding Data.Text.Lazy.IO Data.Text.Lazy.Internal
                 Data.Text.Lazy.Read Data.Text.Read
hidden-modules: Data.Text.Encoding.Fusion
                Data.Text.Encoding.Fusion.Common Data.Text.Encoding.Utf16
                Data.Text.Encoding.Utf32 Data.Text.Encoding.Utf8 Data.Text.Fusion
                Data.Text.Fusion.CaseMapping Data.Text.Fusion.Common
                Data.Text.Fusion.Internal Data.Text.Fusion.Size
                Data.Text.IO.Internal Data.Text.Lazy.Builder.Functions
                Data.Text.Lazy.Builder.RealFloat.Functions
                Data.Text.Lazy.Encoding.Fusion Data.Text.Lazy.Fusion
                Data.Text.Lazy.Search Data.Text.Private Data.Text.Search
                Data.Text.Unsafe Data.Text.Unsafe.Base Data.Text.UnsafeChar
                Data.Text.UnsafeShift Data.Text.Util
trusted: False
import-dirs: /usr/local/lib/ghc/text-0.11.2.3
library-dirs: /usr/local/lib/ghc/text-0.11.2.3
hs-libraries: HStext-0.11.2.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.0-0b6c5ca7e879a14d110ca4c001dd9297
         base-4.5.1.0-f38bf31a759416ec7b167d6dc132959a
         bytestring-0.9.2.1-4f95f32adc23f1bc25c472a646e99581
         deepseq-1.3.0.0-c26e15897417ecd448742528253d68f6
         ghc-prim-0.2.0.0-7d3c2c69a5e8257a04b2c679c40e2fa7
         integer-gmp-0.4.0.0-af3a28fdc4138858e0c7c5ecc2a64f43
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-text-0.11.2.3/html/text.haddock
haddock-html: /usr/local/share/doc/hs-text-0.11.2.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
